/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.metadata.audio.reader.ASFParser;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMAMetaData
implements MetaReader {
    protected final AudioMetaData audioData = new AudioMetaData();

    public WMAMetaData(File file) throws IOException {
        this.parseFile(file);
    }

    public WMAMetaData(ASFParser aSFParser) throws IOException {
        this.set(aSFParser);
    }

    private void parseFile(File file) throws IOException {
        ASFParser aSFParser = new ASFParser(file);
        this.set(aSFParser);
    }

    private void set(ASFParser aSFParser) throws IOException {
        if (aSFParser.hasVideo()) {
            throw new IOException("use WMV instead!");
        }
        if (!aSFParser.hasAudio()) {
            throw new IOException("no audio data!");
        }
        this.audioData.setTitle(aSFParser.getTitle());
        this.audioData.setAlbum(aSFParser.getAlbum());
        this.audioData.setArtist(aSFParser.getArtist());
        this.audioData.setYear(aSFParser.getYear());
        this.audioData.setComment(aSFParser.getComment());
        this.audioData.setTrack(String.valueOf(aSFParser.getTrack()));
        this.audioData.setBitrate(aSFParser.getBitrate());
        this.audioData.setLength(aSFParser.getLength());
        this.audioData.setGenre(aSFParser.getGenre());
        this.audioData.setLicense(aSFParser.getCopyright());
        if (aSFParser.getLicenseInfo() != null) {
            this.audioData.setLicenseType(aSFParser.getLicenseInfo());
        }
    }

    @Override
    public MetaData getMetaData() {
        return this.audioData;
    }

    @Override
    public String getSchemaURI() {
        return "http://www.limewire.com/schemas/audio.xsd";
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        return this.audioData.toNameValueList();
    }
}

