/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;

public class MP3MetaData
extends AudioDataReader {
    public MP3MetaData(File file) throws IOException, IllegalArgumentException {
        super(file);
    }

    protected void readTag(AudioFile audioFile, Tag tag) {
        MP3File mP3File = (MP3File)audioFile;
        mP3File.getID3v1Tag();
        AbstractID3v2Tag abstractID3v2Tag = mP3File.getID3v2Tag();
        ID3v1Tag iD3v1Tag = mP3File.getID3v1Tag();
        if (abstractID3v2Tag != null) {
            this.readV2Tag(abstractID3v2Tag);
        }
        if (iD3v1Tag != null) {
            this.readV1Tag(iD3v1Tag);
        }
    }

    private void readV1Tag(ID3v1Tag iD3v1Tag) {
        if (this.audioData.getTitle() == null || this.audioData.getTitle().length() == 0) {
            this.audioData.setTitle(iD3v1Tag.getFirstTitle());
        }
        if (this.audioData.getArtist() == null || this.audioData.getArtist().length() == 0) {
            this.audioData.setArtist(iD3v1Tag.getFirstArtist());
        }
        if (this.audioData.getAlbum() == null || this.audioData.getAlbum().length() == 0) {
            this.audioData.setAlbum(iD3v1Tag.getFirstAlbum());
        }
        if (this.audioData.getYear() == null || this.audioData.getYear().length() == 0) {
            this.audioData.setYear(iD3v1Tag.getFirstYear());
        }
        if (this.audioData.getComment() == null || this.audioData.getComment().length() == 0) {
            this.audioData.setComment(iD3v1Tag.getFirstComment());
        }
        if (this.audioData.getGenre() == null || this.audioData.getGenre().length() == 0) {
            this.audioData.setGenre(iD3v1Tag.getFirstGenre());
        }
        if (this.audioData.getTrack() == null || this.audioData.getTrack().length() == 0) {
            try {
                this.audioData.setTrack(iD3v1Tag.getFirstTrack());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private void readV2Tag(AbstractID3v2Tag abstractID3v2Tag) {
        this.audioData.setTitle(abstractID3v2Tag.getFirstTitle());
        this.audioData.setArtist(abstractID3v2Tag.getFirstArtist());
        this.audioData.setAlbum(abstractID3v2Tag.getFirstAlbum());
        this.audioData.setYear(abstractID3v2Tag.getFirstYear());
        this.audioData.setComment(abstractID3v2Tag.getFirstComment());
        this.audioData.setGenre(this.parseGenre(abstractID3v2Tag.getFirstGenre()));
        this.audioData.setTrack(abstractID3v2Tag.getFirstTrack());
        this.audioData.setLicense(abstractID3v2Tag.getFirst("TCOP"));
        Iterator iterator = abstractID3v2Tag.iterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame;
            if (this.audioData.getLicenseType() != null && this.audioData.getLicenseType().equals("NOT CLEARED")) {
                return;
            }
            Object e = iterator.next();
            if (!(e instanceof AbstractID3v2Frame) || (abstractID3v2Frame = (AbstractID3v2Frame)e).getId().equals("TIT2") || abstractID3v2Frame.getId().equals("TALB") || abstractID3v2Frame.getId().equals("TOAL") || abstractID3v2Frame.getId().equals("TOPE") || abstractID3v2Frame.getId().equals("TPE1") || abstractID3v2Frame.getId().equals("TPE2") || abstractID3v2Frame.getId().equals("TPE3") || abstractID3v2Frame.getId().equals("TPE4")) continue;
            if (abstractID3v2Frame.getBody().getObject("Text") != null) {
                this.checkLWS(abstractID3v2Frame.getBody().getObject("Text").toString());
                continue;
            }
            this.isRawCheck(abstractID3v2Frame.getRawContent());
        }
    }

    private void isRawCheck(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8");
            this.checkLWS(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void checkLWS(String string) {
        if (!(this.audioData.getLicenseType() != null && this.audioData.getLicenseType().equals("NOT CLEARED") || string.indexOf("NOT CLEARED") == -1)) {
            this.audioData.setLicenseType("NOT CLEARED");
        }
    }

    private String parseGenre(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        String string2 = string;
        if (string.charAt(0) == '(') {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ')') continue;
                n = i + 1;
            }
            string2 = string.substring(n);
        }
        return string2;
    }
}

