/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioMetaData
implements MetaData {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private String track;
    private String genre;
    private int bitrate = -1;
    private int length = -1;
    private short totalTracks = (short)-1;
    private short disk = (short)-1;
    private short totalDisks = (short)-1;
    private String license;
    private String licensetype;
    private String channels;
    private int sampleRate = -1;
    private boolean isVBR = false;

    @Override
    public String getSchemaURI() {
        return "http://www.limewire.com/schemas/audio.xsd";
    }

    @Override
    public void populate(LimeXMLDocument limeXMLDocument) {
        this.title = limeXMLDocument.getValue("audios__audio__title__") == null ? "" : limeXMLDocument.getValue("audios__audio__title__");
        this.artist = limeXMLDocument.getValue("audios__audio__artist__") == null ? "" : limeXMLDocument.getValue("audios__audio__artist__");
        this.album = limeXMLDocument.getValue("audios__audio__album__") == null ? "" : limeXMLDocument.getValue("audios__audio__album__");
        this.year = limeXMLDocument.getValue("audios__audio__year__") == null ? "" : limeXMLDocument.getValue("audios__audio__year__");
        this.track = limeXMLDocument.getValue("audios__audio__track__") == null ? "" : limeXMLDocument.getValue("audios__audio__track__");
        this.comment = limeXMLDocument.getValue("audios__audio__comments__") == null ? "" : limeXMLDocument.getValue("audios__audio__comments__");
        this.genre = limeXMLDocument.getValue("audios__audio__genre__") == null ? "" : limeXMLDocument.getValue("audios__audio__genre__");
        this.license = limeXMLDocument.getValue("audios__audio__license__") == null ? "" : limeXMLDocument.getValue("audios__audio__license__");
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>();
        this.add(arrayList, this.title, "audios__audio__title__");
        this.add(arrayList, this.artist, "audios__audio__artist__");
        this.add(arrayList, this.album, "audios__audio__album__");
        this.add(arrayList, this.year, "audios__audio__year__");
        this.add(arrayList, this.comment, "audios__audio__comments__");
        this.add(arrayList, this.track, "audios__audio__track__");
        this.add(arrayList, this.genre, "audios__audio__genre__");
        this.add(arrayList, this.bitrate, "audios__audio__bitrate__");
        this.add(arrayList, this.length, "audios__audio__seconds__");
        this.add(arrayList, this.license, "audios__audio__license__");
        this.add(arrayList, this.licensetype, "audios__audio__licensetype__");
        return arrayList;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTrack() {
        return this.track;
    }

    public short getTotalTracks() {
        return this.totalTracks;
    }

    public short getDisk() {
        return this.disk;
    }

    public short getTotalDisks() {
        return this.totalDisks;
    }

    public String getGenre() {
        return this.genre;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getLength() {
        return this.length;
    }

    public String getLicense() {
        return this.license;
    }

    public String getLicenseType() {
        return this.licensetype;
    }

    public String getNumChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isVBR() {
        return this.isVBR;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setArtist(String string) {
        this.artist = string;
    }

    public void setAlbum(String string) {
        this.album = string;
    }

    public void setYear(String string) {
        this.year = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setTrack(String string) {
        this.track = string;
    }

    public void setTotalTracks(short s) {
        this.totalTracks = s;
    }

    public void setDisk(short s) {
        this.disk = s;
    }

    public void setTotalDisks(short s) {
        this.totalDisks = s;
    }

    public void setGenre(String string) {
        this.genre = string;
    }

    public void setBitrate(int n) {
        this.bitrate = n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setLicense(String string) {
        this.license = string;
    }

    public void setLicenseType(String string) {
        this.licensetype = string;
    }

    public void setNumChannels(String string) {
        this.channels = string;
    }

    public void setSampleRate(int n) {
        this.sampleRate = n;
    }

    public void setVBR(boolean bl) {
        this.isVBR = bl;
    }

    private void add(List<NameValue<String>> list, String string, String string2) {
        if (this.isValid(string)) {
            list.add(new NameValue<String>(string2, string.trim()));
        }
    }

    private void add(List<NameValue<String>> list, int n, String string) {
        if (this.isValid(n)) {
            list.add(new NameValue<String>(string, "" + n));
        }
    }

    private boolean isValid(String string) {
        return string != null && !string.trim().equals("");
    }

    private boolean isValid(int n) {
        return n >= 0;
    }

    public static boolean isCorrupted(LimeXMLDocument limeXMLDocument) {
        if (!"http://www.limewire.com/schemas/audio.xsd".equals(limeXMLDocument.getSchemaURI())) {
            return false;
        }
        for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (!string.equals("audios__audio__album__") && !string.equals("audios__audio__artist__") || string2.length() != 30 || string2.charAt(29) == ' ' || string2.charAt(28) != ' ') continue;
            return true;
        }
        return false;
    }

    public static LimeXMLDocument fixCorruption(LimeXMLDocument limeXMLDocument, LimeXMLDocumentFactory limeXMLDocumentFactory) {
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>(limeXMLDocument.getNumFields());
        for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ((string.equals("audios__audio__album__") || string.equals("audios__audio__artist__")) && string2.length() == 30 && string2.charAt(29) != ' ' && string2.charAt(28) == ' ') {
                string2 = string2.substring(0, 29).trim();
            }
            arrayList.add(new NameValue<String>(string, string2));
        }
        return limeXMLDocumentFactory.createLimeXMLDocument(arrayList, limeXMLDocument.getSchemaURI());
    }

    public static boolean isNonLimeAudioField(String string) {
        return !string.equals("audios__audio__track__") && !string.equals("audios__audio__artist__") && !string.equals("audios__audio__album__") && !string.equals("audios__audio__title__") && !string.equals("audios__audio__genre__") && !string.equals("audios__audio__year__") && !string.equals("audios__audio__comments__") && !string.equals("audios__audio__bitrate__") && !string.equals("audios__audio__seconds__") && !string.equals("audios__audio__license__") && !string.equals("audios__audio__price__") && !string.equals("audios__audio__licensetype__");
    }
}

