/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.metadata.audio.reader.ASFParser;
import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import com.limegroup.gnutella.metadata.audio.reader.MP3MetaData;
import com.limegroup.gnutella.metadata.audio.reader.OGGMetaData;
import com.limegroup.gnutella.metadata.audio.reader.WMAMetaData;
import com.limegroup.gnutella.metadata.audio.writer.FlacDataEditor;
import com.limegroup.gnutella.metadata.audio.writer.M4ADataEditor;
import com.limegroup.gnutella.metadata.audio.writer.MP3DataEditor;
import com.limegroup.gnutella.metadata.audio.writer.OGGDataEditor;
import com.limegroup.gnutella.metadata.video.reader.MOVMetaData;
import com.limegroup.gnutella.metadata.video.reader.MPEGMetaData;
import com.limegroup.gnutella.metadata.video.reader.OGMMetaData;
import com.limegroup.gnutella.metadata.video.reader.RIFFMetaData;
import com.limegroup.gnutella.metadata.video.reader.WMVMetaData;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaDataFactoryImpl
implements MetaDataFactory {
    private static final Log LOG = LogFactory.getLog(MetaDataFactory.class);

    public MetaWriter getEditorForFile(String string) {
        if (LimeXMLUtils.isSupportedAudioFormat(string)) {
            return this.getAudioEditorForFile(string);
        }
        return null;
    }

    public MetaReader parse(File file) throws IOException {
        try {
            if (LimeXMLUtils.isSupportedAudioFormat(file)) {
                return this.parseAudioFile(file);
            }
            if (LimeXMLUtils.isSupportedVideoFormat(file)) {
                return this.parseVideoMetaData(file);
            }
            if (LimeXMLUtils.isSupportedMultipleFormat(file)) {
                return this.parseMultipleFormat(file);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            LOG.warn((Object)"Ran out of memory while parsing.", (Throwable)outOfMemoryError);
            throw (IOException)new IOException().initCause(outOfMemoryError);
        }
        catch (Exception exception) {
            LOG.warn((Object)"Exception parsing file.", (Throwable)exception);
            throw (IOException)new IOException().initCause(exception);
        }
        return null;
    }

    private MetaReader parseMultipleFormat(File file) throws IOException {
        if (LimeXMLUtils.isASFFile(file)) {
            ASFParser aSFParser = new ASFParser(file);
            if (aSFParser.hasVideo()) {
                return new WMVMetaData(aSFParser);
            }
            if (aSFParser.hasAudio()) {
                return new WMAMetaData(aSFParser);
            }
        }
        return null;
    }

    private MetaWriter getAudioEditorForFile(String string) {
        if (LimeXMLUtils.isMP3File(string)) {
            return new MP3DataEditor();
        }
        if (LimeXMLUtils.isOGGFile(string)) {
            return new OGGDataEditor();
        }
        if (LimeXMLUtils.isM4AFile(string)) {
            return new M4ADataEditor();
        }
        if (LimeXMLUtils.isFLACFile(string)) {
            return new FlacDataEditor();
        }
        return null;
    }

    private MetaReader parseAudioFile(File file) throws IOException, IllegalArgumentException {
        if (LimeXMLUtils.isMP3File(file)) {
            return new MP3MetaData(file);
        }
        if (LimeXMLUtils.isOGGFile(file)) {
            return new OGGMetaData(file);
        }
        if (LimeXMLUtils.isFLACFile(file)) {
            return new AudioDataReader(file);
        }
        if (LimeXMLUtils.isM4AFile(file)) {
            return new AudioDataReader(file);
        }
        if (LimeXMLUtils.isWMAFile(file)) {
            return new WMAMetaData(file);
        }
        return null;
    }

    private MetaReader parseVideoMetaData(File file) throws IOException {
        if (LimeXMLUtils.isRIFFFile(file)) {
            return new RIFFMetaData(file);
        }
        if (LimeXMLUtils.isOGMFile(file)) {
            return new OGMMetaData(file);
        }
        if (LimeXMLUtils.isWMVFile(file)) {
            return new WMVMetaData(file);
        }
        if (LimeXMLUtils.isMPEGFile(file)) {
            return new MPEGMetaData(file);
        }
        if (LimeXMLUtils.isQuickTimeFile(file)) {
            return new MOVMetaData(file);
        }
        return null;
    }
}

