/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AdvancedStatsToggle;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMImpl;
import com.limegroup.gnutella.messages.vendor.ContentRequest;
import com.limegroup.gnutella.messages.vendor.ContentResponse;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.messages.vendor.HeadPing;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.InspectionRequestImpl;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.OOBProxyControlVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessageFactory;
import com.limegroup.gnutella.messages.vendor.SimppRequestVM;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackRedirect;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.UpdateResponse;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.messages.vendor.VendorMessageParserBinder;
import org.limewire.security.MACCalculatorRepositoryManager;

@Singleton
public class VendorMessageParserBinderImpl
implements VendorMessageParserBinder {
    private final ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory;
    private final HeadPongFactory headPongFactory;
    private final MACCalculatorRepositoryManager macManager;

    @Inject
    public VendorMessageParserBinderImpl(ReplyNumberVendorMessageFactory replyNumberVendorMessageFactory, HeadPongFactory headPongFactory, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        this.replyNumberVendorMessageFactory = replyNumberVendorMessageFactory;
        this.headPongFactory = headPongFactory;
        this.macManager = mACCalculatorRepositoryManager;
    }

    public void bind(VendorMessageFactory vendorMessageFactory) {
        vendorMessageFactory.setParser(4, VendorMessage.F_BEAR_VENDOR_ID, new HopsFlowVendorMessageParser());
        vendorMessageFactory.setParser(11, VendorMessage.F_LIME_VENDOR_ID, new LimeACKVendorMessageParser());
        vendorMessageFactory.setParser(12, VendorMessage.F_LIME_VENDOR_ID, new ReplyNumberVendorMessageParser());
        vendorMessageFactory.setParser(7, VendorMessage.F_BEAR_VENDOR_ID, new TCPConnectBackVendorMessageParser());
        vendorMessageFactory.setParser(0, VendorMessage.F_NULL_VENDOR_ID, new MessagesSupportedVendorMessageParser());
        vendorMessageFactory.setParser(7, VendorMessage.F_GTKG_VENDOR_ID, new UDPConnectBackVendorMessageParser());
        vendorMessageFactory.setParser(21, VendorMessage.F_LIME_VENDOR_ID, new PushProxyRequestParser());
        vendorMessageFactory.setParser(22, VendorMessage.F_LIME_VENDOR_ID, new PushProxyAcknowledgementParser());
        vendorMessageFactory.setParser(11, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusRequestParser());
        vendorMessageFactory.setParser(12, VendorMessage.F_BEAR_VENDOR_ID, new QueryStatusResponseParser());
        vendorMessageFactory.setParser(7, VendorMessage.F_LIME_VENDOR_ID, new TCPConnectBackRedirectParser());
        vendorMessageFactory.setParser(8, VendorMessage.F_LIME_VENDOR_ID, new UDPConnectBackRedirectParser());
        vendorMessageFactory.setParser(10, VendorMessage.F_NULL_VENDOR_ID, new CapabilitiesVMParser());
        vendorMessageFactory.setParser(16, VendorMessage.F_LIME_VENDOR_ID, new SimppRequestVMParser());
        vendorMessageFactory.setParser(17, VendorMessage.F_LIME_VENDOR_ID, new SimppVMParser());
        vendorMessageFactory.setParser(5, VendorMessage.F_LIME_VENDOR_ID, new UDPCrawlerPingParser());
        vendorMessageFactory.setParser(23, VendorMessage.F_LIME_VENDOR_ID, new HeadPingParser());
        vendorMessageFactory.setParser(24, VendorMessage.F_LIME_VENDOR_ID, new HeadPongParser());
        vendorMessageFactory.setParser(26, VendorMessage.F_LIME_VENDOR_ID, new UpdateRequestParser());
        vendorMessageFactory.setParser(27, VendorMessage.F_LIME_VENDOR_ID, new UpdateResponseParser());
        vendorMessageFactory.setParser(28, VendorMessage.F_LIME_VENDOR_ID, new ContentRequestParser());
        vendorMessageFactory.setParser(29, VendorMessage.F_LIME_VENDOR_ID, new ContentResponseParser());
        vendorMessageFactory.setParser(25, VendorMessage.F_LIME_VENDOR_ID, new HeaderUpdateVendorMessageParser());
        vendorMessageFactory.setParser(13, VendorMessage.F_LIME_VENDOR_ID, new OOBProxyControlVendorMessageParser());
        vendorMessageFactory.setParser(30, VendorMessage.F_LIME_VENDOR_ID, new InspectionRequestVendorMessageParser());
        vendorMessageFactory.setParser(32, VendorMessage.F_LIME_VENDOR_ID, new AdvancedStatsToggleVendorMessageParser());
        vendorMessageFactory.setParser(33, VendorMessage.F_LIME_VENDOR_ID, new DHTContactsMessageParser(this.macManager));
    }

    private static class DHTContactsMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private final MACCalculatorRepositoryManager macManager;

        private DHTContactsMessageParser(MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
            this.macManager = mACCalculatorRepositoryManager;
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new DHTContactsMessage(byArray, by, by2, n, byArray2, network, this.macManager);
        }
    }

    private static class AdvancedStatsToggleVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private AdvancedStatsToggleVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new AdvancedStatsToggle(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class InspectionRequestVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private InspectionRequestVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new InspectionRequestImpl(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class OOBProxyControlVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private OOBProxyControlVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new OOBProxyControlVendorMessage(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class HeaderUpdateVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private HeaderUpdateVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new HeaderUpdateVendorMessage(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class ContentResponseParser
    implements VendorMessageFactory.VendorMessageParser {
        private ContentResponseParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new ContentResponse(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class ContentRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private ContentRequestParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new ContentRequest(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class UpdateResponseParser
    implements VendorMessageFactory.VendorMessageParser {
        private UpdateResponseParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new UpdateResponse(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class UpdateRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private UpdateRequestParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new UpdateRequest(byArray, by, by2, n, byArray2, network);
        }
    }

    private class HeadPongParser
    implements VendorMessageFactory.VendorMessageParser {
        private HeadPongParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return VendorMessageParserBinderImpl.this.headPongFactory.createFromNetwork(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class HeadPingParser
    implements VendorMessageFactory.VendorMessageParser {
        private HeadPingParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new HeadPing(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class UDPCrawlerPingParser
    implements VendorMessageFactory.VendorMessageParser {
        private UDPCrawlerPingParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new UDPCrawlerPing(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class SimppVMParser
    implements VendorMessageFactory.VendorMessageParser {
        private SimppVMParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new SimppVM(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class SimppRequestVMParser
    implements VendorMessageFactory.VendorMessageParser {
        private SimppRequestVMParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new SimppRequestVM(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class CapabilitiesVMParser
    implements VendorMessageFactory.VendorMessageParser {
        private CapabilitiesVMParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new CapabilitiesVMImpl(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class UDPConnectBackRedirectParser
    implements VendorMessageFactory.VendorMessageParser {
        private UDPConnectBackRedirectParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new UDPConnectBackRedirect(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class TCPConnectBackRedirectParser
    implements VendorMessageFactory.VendorMessageParser {
        private TCPConnectBackRedirectParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new TCPConnectBackRedirect(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class QueryStatusResponseParser
    implements VendorMessageFactory.VendorMessageParser {
        private QueryStatusResponseParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new QueryStatusResponse(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class QueryStatusRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private QueryStatusRequestParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new QueryStatusRequest(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class PushProxyAcknowledgementParser
    implements VendorMessageFactory.VendorMessageParser {
        private PushProxyAcknowledgementParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new PushProxyAcknowledgement(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class PushProxyRequestParser
    implements VendorMessageFactory.VendorMessageParser {
        private PushProxyRequestParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new PushProxyRequest(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class UDPConnectBackVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private UDPConnectBackVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new UDPConnectBackVendorMessage(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class MessagesSupportedVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private MessagesSupportedVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new MessagesSupportedVendorMessage(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class TCPConnectBackVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private TCPConnectBackVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new TCPConnectBackVendorMessage(byArray, by, by2, n, byArray2, network);
        }
    }

    private class ReplyNumberVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private ReplyNumberVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return VendorMessageParserBinderImpl.this.replyNumberVendorMessageFactory.createFromNetwork(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class LimeACKVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private LimeACKVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new LimeACKVendorMessage(byArray, by, by2, n, byArray2, network);
        }
    }

    private static class HopsFlowVendorMessageParser
    implements VendorMessageFactory.VendorMessageParser {
        private HopsFlowVendorMessageParser() {
        }

        public VendorMessage parse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
            return new HopsFlowVendorMessage(byArray, by, by2, n, byArray2, network);
        }
    }
}

