/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.service.ErrorService;

public final class UpdateResponse
extends AbstractVendorMessage
implements VendorMessage.ControlMessage {
    private static final int NON_GGEP_VERSION = 1;
    private static final int OLD_KEY_VERSION = 2;
    private static final int NEW_KEY_VERSION = 3;
    public static final int VERSION = 3;
    private byte[] update;

    UpdateResponse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        block7: {
            super(byArray, by, by2, F_LIME_VENDOR_ID, 27, n, byArray2, network);
            if (n == 1) {
                this.update = byArray2;
            } else {
                try {
                    GGEP gGEP = new GGEP(byArray2, 0, null);
                    if (gGEP.hasKey("U")) {
                        this.update = gGEP.getBytes("U");
                        break block7;
                    }
                    if (gGEP.hasKey("C")) {
                        this.update = gGEP.getBytes("C");
                        break block7;
                    }
                    throw new BadPacketException("no update in GGEP?");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException("bad ggep property");
                }
                catch (BadGGEPBlockException badGGEPBlockException) {
                    this.update = byArray2;
                }
            }
        }
    }

    private UpdateResponse(byte[] byArray, int n) {
        super(F_LIME_VENDOR_ID, 27, n, byArray);
    }

    public static UpdateResponse createUpdateResponse(byte[] byArray, UpdateRequest updateRequest) {
        if (!updateRequest.isOldRequest()) {
            byte[] byArray2 = UpdateResponse.createGGEP(updateRequest, byArray);
            return new UpdateResponse(byArray2, 3);
        }
        if (!updateRequest.hasGGEP()) {
            return new UpdateResponse(byArray, 1);
        }
        byte[] byArray3 = UpdateResponse.createGGEP(updateRequest, byArray);
        return new UpdateResponse(byArray3, 2);
    }

    public boolean isNewVersion() {
        return this.getVersion() >= 3;
    }

    private static byte[] createGGEP(UpdateRequest updateRequest, byte[] byArray) {
        GGEP gGEP = new GGEP();
        if (updateRequest.requestsCompressed()) {
            gGEP.putCompressed("C", byArray);
        } else {
            gGEP.put("U", byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gGEP.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getUpdate() {
        return this.update;
    }
}

