/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPongFactory;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UDPCrawlerPongFactoryImpl
implements UDPCrawlerPongFactory {
    private final Provider<DHTManager> dhtManager;
    private final Provider<ConnectionManager> connectionManager;

    @Inject
    public UDPCrawlerPongFactoryImpl(Provider<DHTManager> provider, Provider<ConnectionManager> provider2) {
        this.dhtManager = provider;
        this.connectionManager = provider2;
    }

    @Override
    public UDPCrawlerPong createUDPCrawlerPong(UDPCrawlerPing uDPCrawlerPing) {
        return new UDPCrawlerPong(uDPCrawlerPing, this.derivePayload(uDPCrawlerPing));
    }

    /*
     * WARNING - void declaration
     */
    private byte[] derivePayload(UDPCrawlerPing uDPCrawlerPing) {
        void var7_18;
        byte by = (byte)(uDPCrawlerPing.getFormat() & 0x7F);
        List list = new LinkedList<RoutedConnection>();
        List<RoutedConnection> list2 = new LinkedList<RoutedConnection>();
        boolean bl = uDPCrawlerPing.hasNewOnly();
        for (RoutedConnection list3 : ((ConnectionManager)this.connectionManager.get()).getInitializedConnections()) {
            if (bl) {
                if (list3.getConnectionCapabilities().remoteHostSupportsUDPCrawling() < 1) continue;
                list.add(list3);
                continue;
            }
            if (!list3.isGoodUltrapeer()) continue;
            list.add(list3);
        }
        for (RoutedConnection routedConnection : ((ConnectionManager)this.connectionManager.get()).getInitializedClientConnections()) {
            list2.add(routedConnection);
        }
        if (!uDPCrawlerPing.hasLocaleInfo()) {
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < list.size()) {
                int n = (int)Math.floor(Math.random() * (double)(list.size() - uDPCrawlerPing.getNumberUP()));
                list = list.subList(n, n + uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < list2.size()) {
                int n = (int)Math.floor(Math.random() * (double)(list2.size() - uDPCrawlerPing.getNumberLeaves()));
                list2 = list2.subList(n, n + uDPCrawlerPing.getNumberLeaves());
            }
        } else {
            String string = ApplicationSettings.LANGUAGE.getValue();
            List<RoutedConnection> list3 = ((ConnectionManager)this.connectionManager.get()).getInitializedConnectionsMatchLocale(string);
            for (RoutedConnection routedConnection : list3) {
                list.remove(routedConnection);
                list.add(0, routedConnection);
            }
            List<RoutedConnection> list4 = ((ConnectionManager)this.connectionManager.get()).getInitializedClientConnectionsMatchLocale(string);
            for (RoutedConnection routedConnection : list4) {
                list2.remove(routedConnection);
                list2.add(0, routedConnection);
            }
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < list.size()) {
                list = list.subList(0, uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < list2.size()) {
                list2 = list2.subList(0, uDPCrawlerPing.getNumberLeaves());
            }
        }
        int n = 6;
        if (uDPCrawlerPing.hasConnectionTime()) {
            n += 2;
        }
        if (uDPCrawlerPing.hasLocaleInfo()) {
            n += 2;
        }
        if (uDPCrawlerPing.hasReplies()) {
            n += 4;
        }
        int n2 = 3;
        if (uDPCrawlerPing.hasNodeUptime()) {
            var7_17 += 4;
        }
        if (uDPCrawlerPing.hasDHTStatus()) {
            ++var7_18;
        }
        Object object = new byte[(list.size() + list2.size()) * n + var7_18];
        object[0] = (byte)list.size();
        object[1] = (byte)list2.size();
        object[2] = by;
        if (uDPCrawlerPing.hasNodeUptime()) {
            long l = ((ConnectionManager)this.connectionManager.get()).getCurrentAverageUptime() / 1000L;
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            ByteUtils.int2leb((int)l, (byte[])object, 3);
        }
        if (uDPCrawlerPing.hasDHTStatus()) {
            int n3 = 0;
            DHTManager dHTManager = (DHTManager)this.dhtManager.get();
            if (dHTManager.isRunning()) {
                switch (dHTManager.getDHTMode()) {
                    case ACTIVE: {
                        n3 = (byte)(n3 | 2);
                        break;
                    }
                    case PASSIVE: {
                        n3 = (byte)(n3 | 4);
                        break;
                    }
                    case PASSIVE_LEAF: {
                        n3 = (byte)(n3 | 8);
                    }
                }
                if (!dHTManager.isMemberOfDHT()) {
                    n3 = (byte)(n3 | 1);
                }
            }
            object[var7_18 - true] = n3;
        }
        list.addAll(list2);
        long l = System.currentTimeMillis();
        for (Object object2 : list) {
            void var7_19;
            System.arraycopy(NetworkUtils.getBytes(object2.getInetAddress(), object2.getPort(), ByteOrder.LITTLE_ENDIAN), 0, object, (int)var7_19, 6);
            var7_19 += 6;
            if (uDPCrawlerPing.hasConnectionTime()) {
                long l2 = l - object2.getConnectionTime();
                short s = (short)(l2 / Constants.MINUTE);
                ByteUtils.short2leb(s, (byte[])object, (int)var7_19);
                var7_19 += 2;
            }
            if (uDPCrawlerPing.hasLocaleInfo()) {
                System.arraycopy(object2.getLocalePref().getBytes(), 0, object, (int)var7_19, 2);
                var7_19 += 2;
            }
            if (!uDPCrawlerPing.hasReplies()) continue;
            ByteUtils.int2leb(ByteUtils.long2int(object2.getConnectionMessageStatistics().getNumQueryReplies()), (byte[])object, (int)var7_19);
            var7_19 += 4;
        }
        if (uDPCrawlerPing.hasUserAgent()) {
            Object object3;
            Object object4;
            Object object2;
            StringBuilder stringBuilder = new StringBuilder();
            for (RoutedConnection routedConnection : list) {
                object4 = routedConnection.getConnectionCapabilities().getUserAgent();
                object4 = StringUtils.replace((String)object4, ";", "\\;");
                stringBuilder.append((String)object4).append(";");
            }
            stringBuilder.append(LimeWireUtils.getHttpServer());
            object2 = new ByteArrayOutputStream();
            try {
                object3 = new GZIPOutputStream((OutputStream)object2);
                object4 = new byte[2];
                ByteUtils.short2leb((short)stringBuilder.length(), (byte[])object4, 0);
                ((FilterOutputStream)object3).write((byte[])object4);
                ((FilterOutputStream)object3).write(stringBuilder.toString().getBytes());
                ((DeflaterOutputStream)object3).flush();
                ((DeflaterOutputStream)object3).close();
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            object3 = ((ByteArrayOutputStream)object2).toByteArray();
            object4 = object;
            object = new byte[((Object)object).length + ((Object)object3).length + 2];
            System.arraycopy(object4, 0, object, 0, ((Object)object4).length);
            ByteUtils.short2leb((short)((Object)object3).length, (byte[])object, ((Object)object4).length);
            System.arraycopy(object3, 0, object, ((Object)object4).length + 2, ((Object)object3).length);
        }
        return object;
    }
}

