/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import org.limewire.util.ByteUtils;

public class UDPCrawlerPing
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    public static final int ALL = -1;
    private int _numberUP;
    private int _numberLeaves;
    private byte _format;
    public static final byte PLAIN = 0;
    public static final byte CONNECTION_TIME = 1;
    public static final byte LOCALE_INFO = 2;
    public static final byte NEW_ONLY = 4;
    public static final byte USER_AGENT = 8;
    public static final byte NODE_UPTIME = 16;
    public static final byte REPLIES = 32;
    public static final byte DHT_STATUS = 64;
    public static final byte FEATURE_MASK = 127;

    public UDPCrawlerPing(GUID gUID, int n, int n2, byte by) {
        super(F_LIME_VENDOR_ID, 5, 1, UDPCrawlerPing.derivePayload(n, n2, by));
        this.setGUID(gUID);
        this._numberUP = n;
        this._numberLeaves = n2;
        this._format = (byte)(by & 0x7F);
    }

    public UDPCrawlerPing(GUID gUID) {
        this(gUID, -1, -1, 0);
    }

    private static byte[] derivePayload(int n, int n2, byte by) {
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        by = (byte)(by & 0x7F);
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[3];
        ByteUtils.short2leb((short)n, byArray, 0);
        byArray2[0] = byArray[0];
        ByteUtils.short2leb((short)n2, byArray, 0);
        byArray2[1] = byArray[0];
        byArray2[2] = by;
        return byArray2;
    }

    protected UDPCrawlerPing(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 5, n, byArray2, network);
        if (this.getVersion() == 1 && (byArray2 == null || byArray2.length != 3)) {
            throw new BadPacketException();
        }
        this._numberUP = ByteUtils.ubyte2int(byArray2[0]);
        this._numberLeaves = ByteUtils.ubyte2int(byArray2[1]);
        this._format = byArray2[2];
        this._format = (byte)(this._format & 0x7F);
    }

    public int getNumberUP() {
        return this._numberUP;
    }

    public int getNumberLeaves() {
        return this._numberLeaves;
    }

    public boolean hasNodeUptime() {
        return (byte)(0x10 & this._format) == 16;
    }

    public boolean hasDHTStatus() {
        return (byte)(0x40 & this._format) == 64;
    }

    public boolean hasConnectionTime() {
        return (byte)(1 & this._format) == 1;
    }

    public boolean hasLocaleInfo() {
        return (byte)(2 & this._format) == 2;
    }

    public boolean hasNewOnly() {
        return (byte)(4 & this._format) == 4;
    }

    public boolean hasUserAgent() {
        return (byte)(8 & this._format) == 8;
    }

    public boolean hasReplies() {
        return this.hasFeature((byte)32);
    }

    public boolean hasFeature(byte by) {
        return (byte)(by & this._format) == by;
    }

    public byte getFormat() {
        return this._format;
    }
}

