/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEPParser;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.SecureGGEPData;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.security.Signature;
import java.security.SignatureException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.security.SecureMessage;
import org.limewire.service.ErrorService;

public class RoutableGGEPMessage
extends AbstractVendorMessage
implements SecureMessage,
VendorMessage.ControlMessage {
    static final String RETURN_ADDRESS_KEY = "RA";
    static final String VERSION_KEY = "V";
    static final String TO_ADDRESS_KEY = "TO";
    private int _secureStatus = 0;
    protected final GGEP ggep;
    private final SecureGGEPData secureData;
    private final IpPort returnAddress;
    private final IpPort destAddress;
    private final long routableVersion;

    protected RoutableGGEPMessage(byte[] byArray, byte by, byte by2, byte[] byArray2, int n, int n2, byte[] byArray3, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, byArray2, n, n2, byArray3, network);
        Object object;
        long l;
        GGEPParser gGEPParser = new GGEPParser();
        gGEPParser.scanForGGEPs(byArray3, 0);
        GGEP gGEP = gGEPParser.getSecureGGEP();
        if (gGEP == null) {
            throw new BadPacketException("no secure ggep");
        }
        this.secureData = new SecureGGEPData(gGEPParser);
        gGEP = gGEPParser.getNormalGGEP();
        if (gGEP == null) {
            throw new BadPacketException("no normal ggep");
        }
        this.ggep = gGEP;
        try {
            l = gGEP.getLong(VERSION_KEY);
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            l = -1L;
        }
        this.routableVersion = l;
        IpPort ipPort = null;
        try {
            object = gGEP.get(RETURN_ADDRESS_KEY);
            if (object != null) {
                ipPort = NetworkUtils.getIpPort(object, ByteOrder.LITTLE_ENDIAN);
            }
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.returnAddress = ipPort;
        object = null;
        try {
            byte[] byArray4 = gGEP.get(TO_ADDRESS_KEY);
            if (byArray4 != null) {
                object = NetworkUtils.getIpPort(byArray4, ByteOrder.LITTLE_ENDIAN);
            }
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
        this.destAddress = object;
    }

    protected RoutableGGEPMessage(byte[] byArray, int n, int n2, GGEPSigner gGEPSigner, GGEP gGEP) {
        super(byArray, n, n2, RoutableGGEPMessage.derivePayload(gGEPSigner, gGEP));
        this.ggep = gGEP;
        this.returnAddress = null;
        this.destAddress = null;
        this.routableVersion = -1L;
        this.secureData = null;
    }

    private static byte[] derivePayload(GGEPSigner gGEPSigner, GGEP gGEP) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gGEP.write(byteArrayOutputStream);
            gGEPSigner.getSecureGGEP(gGEP).write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public IpPort getReturnAddress() {
        return this.returnAddress;
    }

    public IpPort getDestinationAddress() {
        return this.destAddress;
    }

    public long getRoutableVersion() {
        return this.routableVersion;
    }

    public byte[] getSecureSignature() {
        SecureGGEPData secureGGEPData = this.secureData;
        if (secureGGEPData != null) {
            try {
                return secureGGEPData.getGGEP().getBytes("SIG");
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                return null;
            }
        }
        return null;
    }

    public int getSecureStatus() {
        return this._secureStatus;
    }

    public void setSecureStatus(int n) {
        this._secureStatus = n;
    }

    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        SecureGGEPData secureGGEPData = this.secureData;
        if (secureGGEPData != null) {
            signature.update(this.getPayload(), 0, secureGGEPData.getStartIndex());
            int n = secureGGEPData.getEndIndex();
            int n2 = this.getPayload().length - n;
            signature.update(this.getPayload(), n, n2);
        }
    }

    public static interface GGEPSigner {
        public GGEP getSecureGGEP(GGEP var1);
    }
}

