/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.service.ErrorService;

public class ContentResponse
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    private GGEP ggep;

    public ContentResponse(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 29, n, byArray2, network);
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        try {
            this.ggep = new GGEP(this.getPayload(), 0);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            throw new BadPacketException(badGGEPBlockException);
        }
    }

    public ContentResponse(URN uRN, boolean bl) {
        super(F_LIME_VENDOR_ID, 29, 1, ContentResponse.derivePayload(uRN, bl));
        try {
            this.ggep = new GGEP(this.getPayload(), 0);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            ErrorService.error(badGGEPBlockException);
        }
    }

    private static byte[] derivePayload(URN uRN, boolean bl) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        GGEP gGEP = new GGEP();
        gGEP.put("S1", uRN.getBytes());
        gGEP.put("SV", bl ? 1 : 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gGEP.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public URN getURN() {
        try {
            return URN.createSHA1UrnFromBytes(this.ggep.getBytes("S1"));
        }
        catch (IOException iOException) {
            return null;
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            return null;
        }
    }

    public boolean getOK() {
        try {
            return this.ggep.getInt("SV") != 0;
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            return false;
        }
    }
}

