/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.Comparators;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilitiesVMImpl
extends AbstractVendorMessage
implements CapabilitiesVM {
    private final Map<byte[], Integer> capabilities;

    CapabilitiesVMImpl(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_NULL_VENDOR_ID, 10, n, byArray2, network);
        this.capabilities = new TreeMap<byte[], Integer>(new Comparators.ByteArrayComparator());
        try {
            int n2;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            int n3 = ByteUtils.ushort2int(ByteUtils.leb2short(byteArrayInputStream));
            for (n2 = 0; n2 < n3; ++n2) {
                this.readCapability(byteArrayInputStream, false);
            }
            if (byteArrayInputStream.available() > 0) {
                n3 = ByteUtils.ushort2int(ByteUtils.leb2short(byteArrayInputStream));
                for (n2 = 0; n2 < n3; ++n2) {
                    this.readCapability(byteArrayInputStream, true);
                }
            }
        }
        catch (IOException iOException) {
            throw new BadPacketException(iOException);
        }
    }

    CapabilitiesVMImpl(Map<byte[], Integer> map) {
        super(F_NULL_VENDOR_ID, 10, 1, CapabilitiesVMImpl.derivePayload(map));
        this.capabilities = map;
    }

    private static byte[] derivePayload(Map<byte[], Integer> map) {
        try {
            TreeMap<byte[], Integer> treeMap = new TreeMap<byte[], Integer>(new Comparators.ByteArrayComparator());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteUtils.short2leb((short)map.size(), byteArrayOutputStream);
            for (Map.Entry<byte[], Integer> entry : map.entrySet()) {
                CapabilitiesVMImpl.writeCapability(byteArrayOutputStream, entry.getKey(), entry.getValue(), false);
                if (entry.getValue() <= 65535) continue;
                treeMap.put(entry.getKey(), entry.getValue());
            }
            if (treeMap.size() > 0) {
                ByteUtils.short2leb((short)treeMap.size(), byteArrayOutputStream);
                for (Map.Entry<Object, Integer> entry : treeMap.entrySet()) {
                    CapabilitiesVMImpl.writeCapability(byteArrayOutputStream, (byte[])entry.getKey(), entry.getValue(), true);
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    @Override
    public int supportsCapability(byte[] byArray) {
        Integer n = this.capabilities.get(byArray);
        if (n == null || n <= -1) {
            return -1;
        }
        return n;
    }

    @Override
    public int supportsTLS() {
        return this.supportsCapability(TLS_SUPPORT_BYTES);
    }

    @Override
    public int supportsFeatureQueries() {
        return this.supportsCapability(FEATURE_SEARCH_BYTES);
    }

    @Override
    public boolean supportsWhatIsNew() {
        return FeatureSearchData.supportsWhatIsNew(this.supportsCapability(FEATURE_SEARCH_BYTES));
    }

    @Override
    public int supportsSIMPP() {
        return this.supportsCapability(SIMPP_BYTES);
    }

    @Override
    public int supportsUpdate() {
        return this.supportsCapability(UPDATE_BYTES);
    }

    @Override
    public int isActiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.ACTIVE.getCapabilityName());
    }

    @Override
    public int isPassiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE.getCapabilityName());
    }

    @Override
    public int isPassiveLeafNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE_LEAF.getCapabilityName());
    }

    @Override
    public boolean canAcceptIncomingTCP() {
        return this.supportsCapability(INCOMING_TCP_BYTES) != 0;
    }

    @Override
    public boolean canDoFWT() {
        return this.supportsCapability(FWT_SUPPORT_BYTES) != 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CapabilitiesVMImpl) {
            CapabilitiesVMImpl capabilitiesVMImpl = (CapabilitiesVMImpl)object;
            return ((Object)this.capabilities).equals(capabilitiesVMImpl.capabilities);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.capabilities).hashCode();
    }

    private void readCapability(InputStream inputStream, boolean bl) throws IOException {
        int n;
        int n2 = n = bl ? 8 : 6;
        if (inputStream.available() < n) {
            throw new IOException("invalid block.");
        }
        byte[] byArray = new byte[4];
        inputStream.read(byArray, 0, byArray.length);
        int n3 = bl ? ByteUtils.leb2int(inputStream) : ByteUtils.ushort2int(ByteUtils.leb2short(inputStream));
        this.capabilities.put(byArray, n3);
    }

    static void writeCapability(OutputStream outputStream, byte[] byArray, int n, boolean bl) throws IOException {
        outputStream.write(byArray);
        if (bl) {
            ByteUtils.int2leb(n, outputStream);
        } else {
            ByteUtils.short2leb((short)n, outputStream);
        }
    }

    @Override
    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }

    @Override
    public String toString() {
        return "{CapabilitiesVM:" + super.toString() + "; supporting: " + this.capabilities + "}";
    }
}

