/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMImpl;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CapabilitiesVMFactoryImpl
implements CapabilitiesVMFactory {
    private final Provider<DHTManager> dhtManager;
    private final Provider<SimppManager> simppManager;
    private final Provider<NetworkManager> networkManager;
    private volatile CapabilitiesVM currentCapabilities;

    @Inject
    public CapabilitiesVMFactoryImpl(Provider<DHTManager> provider, Provider<SimppManager> provider2, Provider<NetworkManager> provider3) {
        this.dhtManager = provider;
        this.simppManager = provider2;
        this.networkManager = provider3;
    }

    @Override
    public CapabilitiesVM getCapabilitiesVM() {
        if (this.currentCapabilities == null) {
            this.currentCapabilities = new CapabilitiesVMImpl(this.getSupportedMessages());
        }
        return this.currentCapabilities;
    }

    @Override
    public void updateCapabilities() {
        this.currentCapabilities = new CapabilitiesVMImpl(this.getSupportedMessages());
    }

    protected Map<byte[], Integer> getSupportedMessages() {
        TreeMap<byte[], Integer> treeMap = new TreeMap<byte[], Integer>(new Comparators.ByteArrayComparator());
        treeMap.put(new byte[]{73, 77, 80, 80}, Integer.MAX_VALUE);
        treeMap.put(new byte[]{76, 77, 85, 80}, Integer.MAX_VALUE);
        treeMap.put(CapabilitiesVM.FEATURE_SEARCH_BYTES, 1);
        treeMap.put(CapabilitiesVM.SIMPP_BYTES, ((SimppManager)this.simppManager.get()).getVersion());
        treeMap.put(CapabilitiesVM.INCOMING_TCP_BYTES, ((NetworkManager)this.networkManager.get()).acceptedIncomingConnection() ? 1 : 0);
        treeMap.put(CapabilitiesVM.FWT_SUPPORT_BYTES, ((NetworkManager)this.networkManager.get()).supportsFWTVersion());
        if (((DHTManager)this.dhtManager.get()).isMemberOfDHT()) {
            DHTManager.DHTMode dHTMode = ((DHTManager)this.dhtManager.get()).getDHTMode();
            assert (dHTMode != null);
            treeMap.put(dHTMode.getCapabilityName(), ((DHTManager)this.dhtManager.get()).getVersion().shortValue());
        }
        if (SSLSettings.isIncomingTLSEnabled()) {
            treeMap.put(CapabilitiesVM.TLS_SUPPORT_BYTES, 1);
        }
        return treeMap;
    }
}

