/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.HUGEExtension;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRequestImpl
extends AbstractMessage
implements QueryRequest {
    private final byte[] PAYLOAD;
    private final int MIN_SPEED;
    private final String QUERY;
    private final LimeXMLDocument XML_DOC;
    private int _featureSelector = 0;
    private boolean _isSecurityTokenRequired;
    private boolean _partialResultsDesired;
    private boolean _doNotProxy = false;
    private final Set<URN> QUERY_URNS;
    private final AddressSecurityToken QUERY_KEY;
    private Integer _metaMask = null;
    private boolean originated = false;
    private volatile int _hashCode = 0;
    private static final char[] ILLEGAL_CHARS = SearchSettings.ILLEGAL_CHARS.getValue();
    private static final int MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();
    private static final int MAX_XML_QUERY_LENGTH = SearchSettings.MAX_XML_QUERY_LENGTH.getValue();

    QueryRequestImpl(byte[] byArray, byte by, int n, String string, String string2, Set<? extends URN> set, AddressSecurityToken addressSecurityToken, boolean bl, Message.Network network, boolean bl2, int n2, boolean bl3, int n3, boolean bl4, boolean bl5, LimeXMLDocumentFactory limeXMLDocumentFactory) {
        super(byArray, (byte)-128, by, (byte)0, 0, network);
        Set<URN> set2;
        if (bl4 && string != null) {
            string = I18NConvert.instance().getNorm(string);
        }
        if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0 || set != null && set.size() != 0)) {
            throw new IllegalArgumentException("cannot create empty query");
        }
        if (string != null && string.length() > MAX_QUERY_LENGTH) {
            throw new IllegalArgumentException("query too big: " + string);
        }
        if (string2 != null && string2.length() > MAX_XML_QUERY_LENGTH) {
            throw new IllegalArgumentException("xml too big: " + string2);
        }
        if (string != null && (set == null || set.size() <= 0 || !string.equals("\\")) && QueryRequestImpl.hasIllegalChars(string)) {
            throw new IllegalArgumentException("illegal chars: " + string);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad feature = " + n2);
        }
        this._featureSelector = n2;
        if (n3 > 0 && n3 < 4 || n3 > 248) {
            throw new IllegalArgumentException("Bad Meta Flag = " + n3);
        }
        if (n3 > 0) {
            this._metaMask = new Integer(n3);
        }
        if (n == 0) {
            n = 128;
            if (bl && !this.isMulticast()) {
                n |= 0x40;
            }
            if (bl && bl5) {
                n |= 2;
            }
            if (!bl2) {
                n |= 0x20;
            } else if (!SearchSettings.DISABLE_OOB_V2.getBoolean()) {
                n |= 4;
            }
        }
        this.MIN_SPEED = n;
        this.QUERY = string == null ? "" : string;
        if (string2 == null || string2.equals("")) {
            this.XML_DOC = null;
        } else {
            set2 = null;
            try {
                set2 = limeXMLDocumentFactory.createLimeXMLDocument(string2);
            }
            catch (SAXException sAXException) {
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.XML_DOC = set2;
        }
        set2 = null;
        set2 = set != null ? new UrnSet(set) : URN.NO_URN_SET;
        this.QUERY_KEY = addressSecurityToken;
        this._doNotProxy = bl3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ByteArrayOutputStream byteArrayOutputStream2;
            ByteUtils.short2leb((short)this.MIN_SPEED, byteArrayOutputStream);
            byteArrayOutputStream.write(this.QUERY.getBytes("UTF-8"));
            byteArrayOutputStream.write(0);
            boolean bl6 = false;
            byte[] byArray2 = null;
            if (this.XML_DOC != null) {
                assert (string2 != null);
                byArray2 = string2.getBytes("UTF-8");
            }
            bl6 = this.writeGemExtension((OutputStream)byteArrayOutputStream, bl6, byArray2);
            bl6 = this.writeGemExtensions(byteArrayOutputStream, bl6, set2 == null ? null : set2.iterator());
            GGEP gGEP = new GGEP(true);
            if (this.QUERY_KEY != null) {
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                this.QUERY_KEY.write(byteArrayOutputStream2);
                gGEP.put("QK", byteArrayOutputStream2.toByteArray());
            }
            if (this._featureSelector > 0) {
                gGEP.put("WH", this._featureSelector);
            }
            if (this._doNotProxy) {
                gGEP.put("NP");
            }
            if (this._metaMask != null) {
                gGEP.put("M", this._metaMask);
            }
            if (bl2) {
                this._isSecurityTokenRequired = true;
                gGEP.put("SO");
            }
            if (SearchSettings.desiresPartialResults()) {
                this._partialResultsDesired = true;
                gGEP.put("PR");
            }
            if (!gGEP.isEmpty()) {
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                gGEP.write(byteArrayOutputStream2);
                bl6 = this.writeGemExtension((OutputStream)byteArrayOutputStream, bl6, byteArrayOutputStream2.toByteArray());
            }
            byteArrayOutputStream.write(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("could not get UTF-8 bytes for query :" + this.QUERY + " with richquery :" + string2);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        this.PAYLOAD = byteArrayOutputStream.toByteArray();
        this.updateLength(this.PAYLOAD.length);
        this.QUERY_URNS = Collections.unmodifiableSet(set2);
    }

    QueryRequestImpl(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network, LimeXMLDocumentFactory limeXMLDocumentFactory, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws BadPacketException {
        super(byArray, (byte)-128, by, by2, byArray2.length, network);
        this.PAYLOAD = byArray2;
        QueryRequestPayloadParser queryRequestPayloadParser = new QueryRequestPayloadParser(byArray2, mACCalculatorRepositoryManager);
        this.QUERY = queryRequestPayloadParser.query;
        LimeXMLDocument limeXMLDocument = null;
        try {
            limeXMLDocument = limeXMLDocumentFactory.createLimeXMLDocument(queryRequestPayloadParser.richQuery);
        }
        catch (SAXException sAXException) {
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.XML_DOC = limeXMLDocument;
        this.MIN_SPEED = queryRequestPayloadParser.minSpeed;
        this._featureSelector = queryRequestPayloadParser.featureSelector;
        this._doNotProxy = queryRequestPayloadParser.doNotProxy;
        this._metaMask = queryRequestPayloadParser.metaMask;
        this._isSecurityTokenRequired = queryRequestPayloadParser.hasSecurityTokenRequest;
        this._partialResultsDesired = queryRequestPayloadParser.partialResultsDesired;
        this.QUERY_URNS = queryRequestPayloadParser.queryUrns == null ? Collections.emptySet() : Collections.unmodifiableSet(queryRequestPayloadParser.queryUrns);
        this.QUERY_KEY = queryRequestPayloadParser.addressSecurityToken;
        if (this.QUERY.length() == 0 && queryRequestPayloadParser.richQuery.length() == 0 && this.QUERY_URNS.size() == 0) {
            throw new BadPacketException("empty query");
        }
        if (this.QUERY.length() > MAX_QUERY_LENGTH) {
            throw new BadPacketException("query too big: " + this.QUERY);
        }
        if (queryRequestPayloadParser.richQuery.length() > MAX_XML_QUERY_LENGTH) {
            throw new BadPacketException("xml too big: " + queryRequestPayloadParser.richQuery);
        }
        if ((this.QUERY_URNS.size() <= 0 || !this.QUERY.equals("\\")) && QueryRequestImpl.hasIllegalChars(this.QUERY)) {
            throw new BadPacketException("illegal chars: " + this.QUERY);
        }
    }

    private static boolean hasIllegalChars(String string) {
        return StringUtils.containsCharacters(string, ILLEGAL_CHARS);
    }

    public static byte[] newQueryGUID(boolean bl) {
        if (bl) {
            return GUID.makeGuidRequery();
        }
        byte[] byArray = GUID.makeGuid();
        if (MessageSettings.STAMP_QUERIES.getValue()) {
            GUID.timeStampGuid(byArray);
        }
        return byArray;
    }

    @Override
    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.PAYLOAD);
    }

    @Override
    public byte[] getPayload() {
        return this.PAYLOAD;
    }

    @Override
    public String getQuery() {
        return this.QUERY;
    }

    @Override
    public LimeXMLDocument getRichQuery() {
        return this.XML_DOC;
    }

    @Override
    public String getRichQueryString() {
        if (this.XML_DOC == null) {
            return null;
        }
        return this.XML_DOC.getXMLString();
    }

    @Override
    public Set<URN> getQueryUrns() {
        return this.QUERY_URNS;
    }

    @Override
    public boolean hasQueryUrns() {
        return !this.QUERY_URNS.isEmpty();
    }

    @Override
    public int getMinSpeed() {
        return this.MIN_SPEED;
    }

    @Override
    public boolean isFirewalledSource() {
        return !this.isMulticast() && (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x40) > 0;
    }

    @Override
    public boolean desiresXMLResponses() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x20) > 0;
    }

    @Override
    public boolean canDoFirewalledTransfer() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 2) > 0;
    }

    @Override
    public boolean desiresOutOfBandReplies() {
        return this.desiresOutOfBandRepliesV2() || this.desiresOutOfBandRepliesV3();
    }

    @Override
    public boolean desiresOutOfBandRepliesV2() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 4) > 0;
    }

    @Override
    public boolean desiresOutOfBandRepliesV3() {
        return this.isSecurityTokenRequired();
    }

    @Override
    public boolean doNotProxy() {
        return this._doNotProxy;
    }

    @Override
    public boolean isWhatIsNewRequest() {
        return this._featureSelector == 1;
    }

    @Override
    public boolean isFeatureQuery() {
        return this._featureSelector > 0;
    }

    @Override
    public boolean isBrowseHostQuery() {
        return "    ".equals(this.getQuery());
    }

    @Override
    public int getFeatureSelector() {
        return this._featureSelector;
    }

    @Override
    public boolean isSecurityTokenRequired() {
        return this._isSecurityTokenRequired;
    }

    @Override
    public boolean desiresPartialResults() {
        return this._partialResultsDesired;
    }

    @Override
    public String getReplyAddress() {
        return new GUID(this.getGUID()).getIP();
    }

    @Override
    public boolean matchesReplyAddress(byte[] byArray) {
        return new GUID(this.getGUID()).matchesIP(byArray);
    }

    @Override
    public int getReplyPort() {
        return new GUID(this.getGUID()).getPort();
    }

    @Override
    public boolean isLimeRequery() {
        return GUID.isLimeRequeryGUID(this.getGUID());
    }

    @Override
    public boolean isQueryForLW() {
        for (String string : SearchSettings.LIME_SEARCH_TERMS.getValue()) {
            if (this.getQuery().length() > 0 && this.getQuery().toLowerCase(Locale.US).contains(string)) {
                return true;
            }
            if (this.getRichQuery() == null) continue;
            for (String string2 : this.getRichQuery().getKeyWords()) {
                if (!string2.toLowerCase(Locale.US).contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public AddressSecurityToken getQueryKey() {
        return this.QUERY_KEY;
    }

    @Override
    public boolean desiresAll() {
        return this._metaMask == null;
    }

    @Override
    public boolean desiresAudio() {
        if (this._metaMask != null) {
            return (this._metaMask & 4) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresVideo() {
        if (this._metaMask != null) {
            return (this._metaMask & 8) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresDocuments() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x10) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresImages() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x20) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresWindowsPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x40) > 0;
        }
        return true;
    }

    @Override
    public boolean desiresLinuxOSXPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x80) > 0;
        }
        return true;
    }

    @Override
    public int getMetaMask() {
        if (this._metaMask != null) {
            return this._metaMask;
        }
        return 0;
    }

    @Override
    public void originate() {
        this.originated = true;
    }

    @Override
    public boolean isOriginated() {
        return this.originated;
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return QueryRequest.class;
    }

    protected boolean writeGemExtension(OutputStream outputStream, boolean bl, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return bl;
        }
        if (bl) {
            outputStream.write(28);
        }
        outputStream.write(byArray);
        return true;
    }

    protected boolean writeGemExtension(OutputStream outputStream, boolean bl, String string) throws IOException {
        if (string != null) {
            return this.writeGemExtension(outputStream, bl, string.getBytes());
        }
        return this.writeGemExtension(outputStream, bl, new byte[0]);
    }

    protected boolean writeGemExtensions(OutputStream outputStream, boolean bl, Iterator<?> iterator) throws IOException {
        if (iterator == null) {
            return bl;
        }
        while (iterator.hasNext()) {
            bl = this.writeGemExtension(outputStream, bl, iterator.next().toString());
        }
        return bl;
    }

    protected static byte[] readNullTerminatedBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (inputStream.available() > 0 && (n = inputStream.read()) != 0) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int n = 17;
            n = 37 * n + this.QUERY.hashCode();
            if (this.XML_DOC != null) {
                n = 37 * n + this.XML_DOC.hashCode();
            }
            n = 37 * n + ((Object)this.QUERY_URNS).hashCode();
            if (this.QUERY_KEY != null) {
                n = 37 * n + this.QUERY_KEY.hashCode();
            }
            this._hashCode = n;
        }
        return this._hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QueryRequestImpl)) {
            return false;
        }
        QueryRequestImpl queryRequestImpl = (QueryRequestImpl)object;
        return this.MIN_SPEED == queryRequestImpl.MIN_SPEED && this.QUERY.equals(queryRequestImpl.QUERY) && (this.XML_DOC == null ? queryRequestImpl.XML_DOC == null : this.XML_DOC.equals(queryRequestImpl.XML_DOC)) && ((Object)this.QUERY_URNS).equals(queryRequestImpl.QUERY_URNS) && Arrays.equals(this.getGUID(), queryRequestImpl.getGUID()) && Arrays.equals(this.PAYLOAD, queryRequestImpl.PAYLOAD);
    }

    @Override
    public String toString() {
        return "<query: \"" + this.getQuery() + "\", " + "ttl: " + this.getTTL() + ", " + "hops: " + this.getHops() + ", " + "meta: \"" + this.getRichQueryString() + "\", " + "urns: " + this.getQueryUrns().size() + ">";
    }

    static byte[] patchInGGEP(byte[] byArray, GGEP gGEP, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws BadPacketException {
        HUGEExtension.GGEPBlock gGEPBlock;
        QueryRequestPayloadParser queryRequestPayloadParser = new QueryRequestPayloadParser(byArray, mACCalculatorRepositoryManager);
        HUGEExtension hUGEExtension = queryRequestPayloadParser.huge;
        if (hUGEExtension != null && (gGEPBlock = QueryRequestImpl.getLastBlock(hUGEExtension.getGGEPBlocks())) != null) {
            GGEP gGEP2 = new GGEP(true);
            gGEP2.merge(gGEPBlock.getGGEP());
            gGEP2.merge(gGEP);
            return QueryRequestImpl.insertBytes(byArray, queryRequestPayloadParser.hugeStart + gGEPBlock.getStartPos(), queryRequestPayloadParser.hugeStart + gGEPBlock.getEndPos(), gGEP2.toByteArray());
        }
        if (QueryRequestImpl.isFirstNullByteAfterOffset(byArray, byArray.length - 1, 2)) {
            return QueryRequestImpl.insertGGEP(byArray, byArray.length, byArray.length, gGEP.toByteArray(), true);
        }
        if (byArray[byArray.length - 1] != 28) {
            return QueryRequestImpl.insertGGEP(byArray, byArray.length - 1, byArray.length - 1, gGEP.toByteArray(), true);
        }
        return QueryRequestImpl.insertGGEP(byArray, byArray.length, byArray.length, gGEP.toByteArray(), false);
    }

    private static boolean isFirstNullByteAfterOffset(byte[] byArray, int n, int n2) {
        if (byArray[n] != 0) {
            return false;
        }
        for (int i = n2; i < n; ++i) {
            if (byArray[i] != 0) continue;
            return false;
        }
        return true;
    }

    private static HUGEExtension.GGEPBlock getLastBlock(List<HUGEExtension.GGEPBlock> list) {
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private static byte[] insertGGEP(byte[] byArray, int n, int n2, byte[] byArray2, boolean bl) {
        if (bl) {
            byte[] byArray3 = new byte[byArray2.length + 1];
            byArray3[0] = 28;
            System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
            return QueryRequestImpl.insertBytes(byArray, n, n2, byArray3);
        }
        return QueryRequestImpl.insertBytes(byArray, n, n2, byArray2);
    }

    private static byte[] insertBytes(byte[] byArray, int n, int n2, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length - (n2 - n)];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        if (n2 < byArray.length) {
            System.arraycopy(byArray, n2, byArray3, n + byArray2.length, byArray.length - n2);
        }
        return byArray3;
    }

    static class QueryRequestPayloadParser {
        String query = "";
        String richQuery = "";
        int minSpeed = 0;
        Set<URN> queryUrns = null;
        Set<URN.Type> requestedUrnTypes = null;
        AddressSecurityToken addressSecurityToken = null;
        HUGEExtension huge;
        int featureSelector;
        boolean doNotProxy;
        boolean doNotProxyV3;
        Integer metaMask;
        boolean hasSecurityTokenRequest;
        boolean partialResultsDesired;
        int hugeStart;
        int hugeEnd;

        public QueryRequestPayloadParser(byte[] byArray, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws BadPacketException {
            try {
                Object object;
                PositionByteArrayInputStream positionByteArrayInputStream = new PositionByteArrayInputStream(byArray);
                short s = ByteUtils.leb2short(positionByteArrayInputStream);
                this.minSpeed = ByteUtils.ushort2int(s);
                this.query = new String(QueryRequestImpl.readNullTerminatedBytes(positionByteArrayInputStream), "UTF-8");
                this.hugeStart = positionByteArrayInputStream.getPos();
                byte[] byArray2 = QueryRequestImpl.readNullTerminatedBytes(positionByteArrayInputStream);
                this.huge = new HUGEExtension(byArray2);
                this.hugeEnd = positionByteArrayInputStream.getPos();
                GGEP gGEP = this.huge.getGGEP();
                if (gGEP != null) {
                    try {
                        if (gGEP.hasKey("QK")) {
                            object = gGEP.getBytes("QK");
                            this.addressSecurityToken = new AddressSecurityToken((byte[])object, mACCalculatorRepositoryManager);
                        }
                        if (gGEP.hasKey("WH")) {
                            this.featureSelector = gGEP.getInt("WH");
                        }
                        if (gGEP.hasKey("NP")) {
                            this.doNotProxy = true;
                        }
                        if (gGEP.hasKey("M")) {
                            this.metaMask = new Integer(gGEP.getInt("M"));
                            if (this.metaMask < 4 || this.metaMask > 248) {
                                this.metaMask = null;
                            }
                        }
                        if (gGEP.hasKey("SO")) {
                            this.hasSecurityTokenRequest = true;
                        }
                        if (gGEP.hasKey("PR")) {
                            this.partialResultsDesired = true;
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                this.queryUrns = this.huge.getURNS();
                this.requestedUrnTypes = this.huge.getURNTypes();
                object = this.huge.getMiscBlocks().iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (this.richQuery.equals("")) {
                        if (!string.startsWith("<?xml")) continue;
                        this.richQuery = string;
                        continue;
                    }
                    break;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new BadPacketException(unsupportedEncodingException.getMessage());
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
        }

        static class PositionByteArrayInputStream
        extends ByteArrayInputStream {
            public PositionByteArrayInputStream(byte[] byArray) {
                super(byArray);
            }

            public int getPos() {
                return this.pos;
            }
        }
    }
}

