/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEPParser;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyData;
import com.limegroup.gnutella.messages.SecureGGEPData;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.search.HostDataFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GGEP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkUtils;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryReplyImpl
extends AbstractMessage
implements QueryReply {
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    private static final GGEPUtil _ggepUtil = new GGEPUtil();
    private byte[] _payload;
    private byte[] _address = new byte[4];
    private int _secureStatus = 0;
    private boolean _parsed = false;
    private volatile QueryReplyData _data;
    private volatile boolean _multicastAllowed = false;
    private byte[] clientGUID = null;
    private final HostDataFactory hostDataFactory;
    private final ResponseFactory responseFactory;
    private final boolean local;

    QueryReplyImpl(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network, HostDataFactory hostDataFactory, ResponseFactory responseFactory) throws BadPacketException {
        super(byArray, (byte)-127, by, by2, byArray2.length, network);
        this.hostDataFactory = hostDataFactory;
        this.responseFactory = responseFactory;
        this._payload = byArray2;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            throw new BadPacketException("invalid port");
        }
        if ((this.getSpeed() & 0xFFFFFFFF00000000L) != 0L) {
            throw new BadPacketException("invalid speed: " + this.getSpeed());
        }
        this.setAddress();
        if (!NetworkUtils.isValidAddress(this.getIPBytes())) {
            throw new BadPacketException("invalid address");
        }
        this.local = false;
    }

    protected QueryReplyImpl(byte[] byArray, byte by, int n, byte[] byArray2, long l, Response[] responseArray, byte[] byArray3, byte[] byArray4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, Set<? extends IpPort> set, SecurityToken securityToken, HostDataFactory hostDataFactory, ResponseFactory responseFactory) {
        super(byArray, (byte)-127, by, (byte)0, 0, Message.Network.UNKNOWN);
        this.hostDataFactory = hostDataFactory;
        this.responseFactory = responseFactory;
        this.local = true;
        if (byArray4.length > 32768) {
            throw new IllegalArgumentException("xml too large: " + new String(byArray4));
        }
        int n2 = responseArray.length;
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + byArray2.length);
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(byArray2));
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + l);
        }
        if (n2 >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n2);
        }
        this._data = new QueryReplyData();
        this._data.setXmlBytes(byArray4);
        this._data.setProxies(set);
        this._data.setSupportsFWTransfer(bl9);
        this._data.setSecurityToken(securityToken != null ? securityToken.getBytes() : null);
        boolean bl10 = SSLSettings.isIncomingTLSEnabled();
        this._data.setTLSCapable(bl10);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n3;
            byteArrayOutputStream.write(n2);
            ByteUtils.short2leb((short)n, byteArrayOutputStream);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            ByteUtils.int2leb((int)l, byteArrayOutputStream);
            for (n3 = n2; n3 > 0; --n3) {
                Response response = responseArray[n2 - n3];
                response.writeToStream(byteArrayOutputStream);
            }
            if (bl || securityToken != null) {
                byteArrayOutputStream.write(76);
                byteArrayOutputStream.write(73);
                byteArrayOutputStream.write(77);
                byteArrayOutputStream.write(69);
                byteArrayOutputStream.write(4);
                n3 = _ggepUtil.getQRGGEP(false, false, false, false, IpPort.EMPTY_SET, null).length;
                boolean bl11 = set != null && set.size() > 0;
                byte by2 = (byte)((bl2 && !bl8 ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
                byte by3 = (byte)(1 | (bl3 && !bl8 ? 4 : 0) | (bl4 ? 8 : 0) | (bl5 || bl8 ? 16 : 0) | (bl7 || bl8 || bl11 || bl9 || securityToken != null || bl10 ? 32 : (n3 > 0 ? 32 : 0)));
                byteArrayOutputStream.write(by2);
                byteArrayOutputStream.write(by3);
                int n4 = byArray4.length + 1;
                if (n4 > 32768) {
                    n4 = 32768;
                }
                ByteUtils.short2leb((short)n4, byteArrayOutputStream);
                int n5 = bl6 ? 1 : 0;
                byteArrayOutputStream.write(n5);
                byte[] byArray5 = _ggepUtil.getQRGGEP(bl7, bl8, bl9, bl10, set, securityToken);
                byteArrayOutputStream.write(byArray5, 0, byArray5.length);
                this.writeSecureGGEP(byteArrayOutputStream, byArray4);
                byteArrayOutputStream.write(byArray4, 0, byArray4.length);
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(byArray3, 0, 16);
            this._payload = byteArrayOutputStream.toByteArray();
            this.updateLength(this._payload.length);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        this.setAddress();
    }

    protected void writeSecureGGEP(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
    }

    private void setAddress() {
        this._address[0] = this._payload[3];
        this._address[1] = this._payload[4];
        this._address[2] = this._payload[5];
        this._address[3] = this._payload[6];
    }

    @Override
    public void setOOBAddress(InetAddress inetAddress, int n) {
        this._address = inetAddress.getAddress();
        ByteUtils.short2leb((short)n, this._payload, 1);
    }

    @Override
    public void setGUID(GUID gUID) {
        super.setGUID(gUID);
    }

    @Override
    public void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this._payload);
    }

    @Override
    public void setBrowseHostReply(boolean bl) {
        this.parseResults();
        this._data.setBrowseHostReply(bl);
    }

    @Override
    public boolean isBrowseHostReply() {
        this.parseResults();
        return this._data.isBrowseHostReply();
    }

    @Override
    public byte[] getXMLBytes() {
        this.parseResults();
        return this._data.getXmlBytes();
    }

    @Override
    public short getResultCount() {
        return (short)ByteUtils.ubyte2int(this._payload[0]);
    }

    @Override
    public short getPartialResultCount() {
        this.parseResults();
        return this._data.getPartialResultCount();
    }

    @Override
    public short getUniqueResultCount() {
        this.parseResults();
        return this._data.getUniqueResultURNs();
    }

    @Override
    public int getPort() {
        return ByteUtils.ushort2int(ByteUtils.leb2short(this._payload, 1));
    }

    @Override
    public String getIP() {
        return NetworkUtils.ip2string(this._address);
    }

    @Override
    public byte[] getIPBytes() {
        return this._address;
    }

    @Override
    public long getSpeed() {
        return ByteUtils.uint2long(ByteUtils.leb2int(this._payload, 7));
    }

    @Override
    public Response[] getResultsArray() throws BadPacketException {
        this.parseResults();
        Response[] responseArray = this._data.getResponses();
        if (responseArray == null) {
            throw new BadPacketException();
        }
        return responseArray;
    }

    @Override
    public Iterator<Response> getResults() throws BadPacketException {
        return this.getResultsAsList().iterator();
    }

    @Override
    public List<Response> getResultsAsList() throws BadPacketException {
        return Arrays.asList(this.getResultsArray());
    }

    @Override
    public String getVendor() throws BadPacketException {
        this.parseResults();
        String string = this._data.getVendor();
        if (string == null) {
            throw new BadPacketException();
        }
        return string;
    }

    @Override
    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this._data.getPushFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for push flag: " + this._data.getPushFlag());
    }

    @Override
    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this._data.getBusyFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for busy flag: " + this._data.getBusyFlag());
    }

    @Override
    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this._data.getUploadedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for uploaded flag: " + this._data.getUploadedFlag());
    }

    @Override
    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this._data.getMeasuredSpeedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for measured speed flag: " + this._data.getMeasuredSpeedFlag());
    }

    @Override
    public byte[] getSecureSignature() {
        this.parseResults();
        SecureGGEPData secureGGEPData = this._data.getSecureGGEP();
        if (secureGGEPData != null) {
            try {
                return secureGGEPData.getGGEP().getBytes("SIG");
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        this.parseResults();
        SecureGGEPData secureGGEPData = this._data.getSecureGGEP();
        if (secureGGEPData != null) {
            signature.update(this._payload, 0, secureGGEPData.getStartIndex());
            int n = secureGGEPData.getEndIndex();
            int n2 = this._payload.length - 16 - n;
            signature.update(this._payload, n, n2);
        }
    }

    @Override
    public synchronized int getSecureStatus() {
        return this._secureStatus;
    }

    @Override
    public synchronized void setSecureStatus(int n) {
        this._secureStatus = n;
    }

    @Override
    public boolean isTLSCapable() {
        this.parseResults();
        return this._data.isTLSCapable();
    }

    @Override
    public boolean getSupportsChat() {
        this.parseResults();
        return this._data.isSupportsChat();
    }

    @Override
    public boolean getSupportsFWTransfer() {
        this.parseResults();
        return this._data.isSupportsFWTransfer();
    }

    @Override
    public byte getFWTransferVersion() {
        this.parseResults();
        return this._data.getFwTransferVersion();
    }

    @Override
    public boolean getSupportsBrowseHost() {
        this.parseResults();
        return this._data.isSupportsBrowseHost();
    }

    @Override
    public boolean isReplyToMulticastQuery() {
        this.parseResults();
        return this._multicastAllowed && this._data.isReplyToMulticast();
    }

    @Override
    public void setMulticastAllowed(boolean bl) {
        this._multicastAllowed = bl;
    }

    @Override
    public boolean isFakeMulticast() {
        this.parseResults();
        return !this._multicastAllowed && this._data.isReplyToMulticast();
    }

    @Override
    public Set<? extends IpPort> getPushProxies() {
        this.parseResults();
        return this._data.getProxies();
    }

    @Override
    public byte[] getSecurityToken() {
        this.parseResults();
        return this._data.getSecurityToken();
    }

    @Override
    public HostData getHostData() throws BadPacketException {
        this.parseResults();
        HostData hostData = this._data.getHostData();
        if (hostData == null) {
            throw new BadPacketException();
        }
        return hostData;
    }

    @Override
    public boolean hasSecureData() {
        this.parseResults();
        return this._data.getSecureGGEP() != null;
    }

    private synchronized void parseResults() {
        if (this._parsed) {
            return;
        }
        this._parsed = true;
        this.parseResults2();
    }

    private void parseResults2() {
        Object object;
        int n = 11;
        this._data = new QueryReplyData();
        int n2 = this.getResultCount();
        if (n2 > FilterSettings.MAX_RESPONSES_PER_REPLY.getValue()) {
            return;
        }
        Response[] responseArray = new Response[n2];
        HashSet<URN> hashSet = new HashSet<URN>(responseArray.length);
        short s = 0;
        int n3 = 0;
        try {
            object = new ByteArrayInputStream(this._payload, n, this._payload.length - n);
            while (n2 > 0) {
                Response response = this.responseFactory.createFromStream((InputStream)object);
                if (response.getRanges() != null && response.getRanges().getSize() > 0L) {
                    n3 = (short)(n3 + 1);
                }
                responseArray[responseArray.length - n2] = response;
                n += response.getIncomingLength();
                if (response.getUrns().isEmpty()) {
                    s = (short)(s + 1);
                } else {
                    hashSet.addAll(response.getUrns());
                }
                --n2;
            }
            this._data.setResponses(responseArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        s = (short)(s + (short)hashSet.size());
        this._data.setUniqueResultURNs(s);
        this._data.setPartialResultCount((short)Math.min(s, n3));
        try {
            int n4;
            int n5;
            if (n >= this._payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            object = null;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Set<IpPort> set = IpPort.EMPTY_SET;
            byte[] byArray = null;
            boolean bl4 = false;
            try {
                object = new String(this._payload, n, 4, "ISO-8859-1");
                assert (((String)object).length() == 4) : "Vendor length wrong.  Wrong character encoding?";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("No support for ISO-8859-1 encoding");
            }
            int n10 = ByteUtils.ubyte2int(this._payload[n += 4]);
            if (n10 <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++n + n10 > this._payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            this._data.setQHDOffset(n - 1);
            if (n10 > 1) {
                n5 = this._payload[n];
                n4 = this._payload[n + 1];
                if ((n4 & 1) != 0) {
                    int n11 = n6 = (n5 & 1) == 1 ? 1 : 0;
                }
                if ((n5 & 4) != 0) {
                    int n12 = n7 = (n4 & 4) != 0 ? 1 : 0;
                }
                if ((n5 & 8) != 0) {
                    int n13 = n8 = (n4 & 8) != 0 ? 1 : 0;
                }
                if ((n5 & 0x10) != 0) {
                    int n14 = n9 = (n4 & 0x10) != 0 ? 1 : 0;
                }
                if ((n5 & 0x20) != 0 && (n4 & 0x20) != 0) {
                    GGEPParser gGEPParser = new GGEPParser();
                    gGEPParser.scanForGGEPs(this._payload, n + 2);
                    GGEP gGEP = gGEPParser.getNormalGGEP();
                    if (gGEP != null) {
                        this._data.setGGEPStart(gGEPParser.getNormalStartIndex());
                        this._data.setGGEPEnd(gGEPParser.getNormalEndIndex());
                        try {
                            bl2 = gGEP.hasKey("BH");
                            if (gGEP.hasKey("FW")) {
                                this._data.setFwTransferVersion(gGEP.getBytes("FW")[0]);
                                this._data.setSupportsFWTransfer(this._data.getFwTransferVersion() > 0);
                            }
                            bl3 = gGEP.hasKey("MCAST");
                            set = _ggepUtil.getPushProxies(gGEP);
                            if (gGEP.hasKey("SO") && ((byArray = gGEP.getBytes("SO")) == null || byArray.length == 0)) {
                                throw new BadPacketException("Message had empty OOB security token");
                            }
                            bl4 = gGEP.hasKey("TLS");
                        }
                        catch (BadGGEPPropertyException badGGEPPropertyException) {
                            // empty catch block
                        }
                    }
                    if (gGEPParser.getSecureGGEP() != null) {
                        this._data.setSecureGGEP(new SecureGGEPData(gGEPParser));
                    }
                }
                n += 2;
            }
            if (n10 > 2) {
                int n15;
                int n16;
                if ((n16 = (n5 = (n15 = ByteUtils.ubyte2int(this._payload[n++]))) | (n4 = (n15 = ByteUtils.ubyte2int(this._payload[n++])) << 8)) > 1) {
                    int n17 = this._payload.length - 16 - n16;
                    byte[] byArray2 = new byte[n16 - 1];
                    System.arraycopy(this._payload, n17, byArray2, 0, n16 - 1);
                    this._data.setXmlBytes(byArray2);
                } else {
                    this._data.setXmlBytes(DataUtils.EMPTY_BYTE_ARRAY);
                }
            }
            if ((n5 = this._payload.length - n) > 0 && (((String)object).equals("LIME") || ((String)object).equals("RAZA"))) {
                n4 = this._payload[n];
                boolean bl5 = bl = (n4 & 1) != 0;
            }
            if (n > this._payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            this._data.setVendor(((String)object).toUpperCase(Locale.US));
            this._data.setPushFlag(n6);
            this._data.setBusyFlag(n7);
            this._data.setUploadedFlag(n8);
            this._data.setMeasuredSpeedFlag(n9);
            this._data.setSupportsChat(bl);
            this._data.setSupportsBrowseHost(bl2);
            this._data.setReplyToMulticast(bl3);
            this._data.setProxies(set);
            this._data.setSecurityToken(byArray);
            this._data.setTLSCapable(bl4);
            this._data.setHostData(this.hostDataFactory.createHostData(this));
        }
        catch (BadPacketException badPacketException) {
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    @Override
    public byte[] getClientGUID() {
        if (this.clientGUID == null) {
            byte[] byArray = new byte[16];
            int n = super.getLength();
            System.arraycopy(this._payload, n - 16, byArray, 0, 16);
            this.clientGUID = byArray;
        }
        return this.clientGUID;
    }

    @Override
    public byte[] getPayload() {
        return this._payload;
    }

    @Override
    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    @Override
    public int calculateQualityOfService(boolean bl, NetworkManager networkManager) {
        int n;
        int n2;
        try {
            n2 = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException badPacketException) {
            n2 = 0;
        }
        boolean bl2 = this.isReplyToMulticastQuery();
        if (bl2) {
            bl = false;
            n = -1;
        } else if (networkManager.isPrivateAddress(this.getIPBytes())) {
            n = 1;
        } else {
            try {
                n = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException badPacketException) {
                n = 0;
            }
        }
        boolean bl3 = false;
        if (this.getPushProxies() != null && this.getPushProxies().size() > 1) {
            bl3 = true;
        }
        if (this.getSupportsFWTransfer() && networkManager.canDoFWT()) {
            bl = false;
            n = -1;
        }
        if (Arrays.equals(this._address, networkManager.getAddress())) {
            return 3;
        }
        if (bl2) {
            return 4;
        }
        if (bl && n == 1) {
            return -1;
        }
        if (n2 == 0 || n == 0) {
            return 0;
        }
        if (n2 == 1) {
            assert (n == -1 || !bl);
            if (n == 1) {
                return 0;
            }
            return 1;
        }
        if (n2 == -1) {
            assert (n == -1 || !bl);
            if (n == 1 && !bl3) {
                return 2;
            }
            return 3;
        }
        assert (false) : "Unexpected case!";
        return -1;
    }

    public static boolean isFirewalledQuality(int n) {
        return n == 0 || n == 2;
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return QueryReply.class;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    int getGGEPStart() {
        this.parseResults();
        return this._data.getGGEPStart();
    }

    int getGGEPEnd() {
        this.parseResults();
        return this._data.getGGEPEnd();
    }

    int getQHDOffset() {
        this.parseResults();
        return this._data.getQHDOffset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GGEPUtil {
        private final byte[] _standardGGEP;
        private final byte[] _bhGGEP;
        private final byte[] _bhTLSGGEP;
        private final byte[] _mcGGEP;
        private final byte[] _mcTLSGGEP;
        private final byte[] _bhAndMC;
        private final byte[] _bhMCAndTLS;
        private final byte[] _tlsGGEP;

        public GGEPUtil() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this._standardGGEP = this.create(byteArrayOutputStream, new String[0]);
            this._bhGGEP = this.create(byteArrayOutputStream, "BH");
            this._mcGGEP = this.create(byteArrayOutputStream, "MCAST");
            this._mcTLSGGEP = this.create(byteArrayOutputStream, "MCAST", "TLS");
            this._bhAndMC = this.create(byteArrayOutputStream, "BH", "MCAST");
            this._bhTLSGGEP = this.create(byteArrayOutputStream, "BH", "TLS");
            this._bhMCAndTLS = this.create(byteArrayOutputStream, "BH", "MCAST", "TLS");
            this._tlsGGEP = this.create(byteArrayOutputStream, "TLS");
        }

        private byte[] create(ByteArrayOutputStream byteArrayOutputStream, String ... stringArray) {
            byteArrayOutputStream.reset();
            GGEP gGEP = new GGEP(true);
            for (String string : stringArray) {
                gGEP.put(string);
            }
            try {
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            assert (byArray != null);
            return byArray;
        }

        public byte[] getQRGGEP(boolean bl, boolean bl2, boolean bl3, boolean bl4, Set<? extends IpPort> set, SecurityToken securityToken) {
            byte[] byArray = this._standardGGEP;
            if (set != null && !set.isEmpty() || securityToken != null) {
                if (set == null) {
                    set = Collections.emptySet();
                }
                GGEP gGEP = new GGEP(true);
                if (bl) {
                    gGEP.put("BH");
                }
                if (bl2) {
                    gGEP.put("MCAST");
                }
                if (bl4) {
                    gGEP.put("TLS");
                }
                if (bl3) {
                    gGEP.put("FW", new byte[]{1});
                }
                if (securityToken != null) {
                    gGEP.put("SO", securityToken.getBytes());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = 0;
                BitNumbers bitNumbers = HTTPHeaderUtils.getTLSIndices(set, Math.min(4, set.size()));
                if (!set.isEmpty()) {
                    Iterator<IpPort> iterator = set.iterator();
                    while (iterator.hasNext() && n < 4) {
                        IpPort ipPort = iterator.next();
                        try {
                            byteArrayOutputStream.write(NetworkUtils.getBytes(ipPort, ByteOrder.LITTLE_ENDIAN));
                            ++n;
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    if (n > 0) {
                        gGEP.put("PUSH", byteArrayOutputStream.toByteArray());
                        if (!bitNumbers.isEmpty()) {
                            gGEP.put("PUSH_TLS", bitNumbers.toByteArray());
                        }
                    }
                    byteArrayOutputStream.reset();
                    gGEP.write(byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {}
            } else {
                byArray = bl && bl2 && bl4 ? this._bhMCAndTLS : (bl && bl2 ? this._bhAndMC : (bl && bl4 ? this._bhTLSGGEP : (bl ? this._bhGGEP : (bl2 && bl4 ? this._mcTLSGGEP : (bl2 ? this._mcGGEP : (bl4 ? this._tlsGGEP : this._standardGGEP))))));
            }
            return byArray;
        }

        public Set<? extends IpPort> getPushProxies(GGEP gGEP) {
            IpPortSet ipPortSet = null;
            BitNumbers bitNumbers = null;
            if (gGEP.hasKey("PUSH_TLS")) {
                try {
                    bitNumbers = new BitNumbers(gGEP.getBytes("PUSH_TLS"));
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            if (gGEP.hasKey("PUSH")) {
                try {
                    byte[] byArray = gGEP.getBytes("PUSH");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    int n = 0;
                    while (byteArrayInputStream.available() > 0) {
                        byte[] byArray2 = new byte[6];
                        if (byteArrayInputStream.read(byArray2, 0, byArray2.length) == byArray2.length) {
                            try {
                                if (ipPortSet == null) {
                                    ipPortSet = new IpPortSet();
                                }
                                IpPort ipPort = NetworkUtils.getIpPort(byArray2, ByteOrder.LITTLE_ENDIAN);
                                if (bitNumbers != null && bitNumbers.isSet(n)) {
                                    ipPort = new ConnectableImpl(ipPort, true);
                                }
                                ipPortSet.add(ipPort);
                            }
                            catch (InvalidDataException invalidDataException) {
                                // empty catch block
                            }
                        }
                        ++n;
                    }
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            return ipPortSet != null ? ipPortSet : IpPort.EMPTY_SET;
        }
    }
}

