/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.Connectable;
import org.limewire.io.GGEP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.util.ByteUtils;
import phex.common.Ip2CountryDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingReplyImpl
extends AbstractMessage
implements IpPort,
Connectable,
PingReply {
    private final List<IpPort> PACKED_IP_PORTS;
    private final List<IpPort> PACKED_DHT_IP_PORTS;
    private final List<IpPort> PACKED_UDP_HOST_CACHES;
    private final String UDP_CACHE_ADDRESS;
    private final int FREE_ULTRAPEER_SLOTS;
    private final int FREE_LEAF_SLOTS;
    private final byte[] PAYLOAD;
    private final InetAddress IP;
    private final int PORT;
    private final InetAddress MY_IP;
    private final int MY_PORT;
    private final long FILES;
    private final long KILOBYTES;
    private final int DAILY_UPTIME;
    private final boolean SUPPORTS_UNICAST;
    private final String VENDOR;
    private final int VENDOR_MAJOR_VERSION;
    private final int VENDOR_MINOR_VERSION;
    private final AddressSecurityToken QUERY_KEY;
    private final int DHT_VERSION;
    private final DHTManager.DHTMode DHT_MODE;
    private final boolean TLS_CAPABLE;
    private final boolean HAS_GGEP_EXTENSION;
    private String CLIENT_LOCALE;
    private int FREE_LOCALE_SLOTS;

    protected PingReplyImpl(byte[] byArray, byte by, byte by2, byte[] byArray2, GGEP gGEP, InetAddress inetAddress, Message.Network network, MACCalculatorRepositoryManager mACCalculatorRepositoryManager, NetworkInstanceUtils networkInstanceUtils) throws BadPacketException {
        super(byArray, (byte)1, by, by2, byArray2.length, network);
        this.PAYLOAD = byArray2;
        this.PORT = ByteUtils.ushort2int(ByteUtils.leb2short(this.PAYLOAD, 0));
        this.FILES = ByteUtils.uint2long(ByteUtils.leb2int(this.PAYLOAD, 6));
        this.KILOBYTES = ByteUtils.uint2long(ByteUtils.leb2int(this.PAYLOAD, 10));
        this.IP = inetAddress;
        int n = -1;
        boolean bl = false;
        String string = "";
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        AddressSecurityToken addressSecurityToken = null;
        boolean bl2 = false;
        String string2 = Ip2CountryDB.getInstance().getIP2Language(this.IP.getHostAddress(), ApplicationSettings.DEFAULT_LOCALE.getValue());
        int n6 = -1;
        InetAddress inetAddress2 = null;
        int n7 = 0;
        List<IpPort> list = Collections.emptyList();
        List<Object> list2 = Collections.emptyList();
        List<Object> list3 = Collections.emptyList();
        String string3 = null;
        int n8 = -1;
        DHTManager.DHTMode dHTMode = null;
        if (gGEP != null) {
            Object object;
            block46: {
                if (gGEP.hasKey("DU")) {
                    try {
                        n = gGEP.getInt("DU");
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                bl = gGEP.hasKey("GUE");
                if (gGEP.hasKey("QK")) {
                    try {
                        object = gGEP.getBytes("QK");
                        addressSecurityToken = new AddressSecurityToken((byte[])object, mACCalculatorRepositoryManager);
                    }
                    catch (InvalidSecurityTokenException invalidSecurityTokenException) {
                        throw new BadPacketException("invalid query key");
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        throw new BadPacketException("invalid query key");
                    }
                }
                if (gGEP.hasKey("UP")) {
                    try {
                        object = gGEP.getBytes("UP");
                        if (((byte[])object).length >= 3) {
                            n4 = object[1];
                            n5 = object[2];
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                if (gGEP.hasKey("DHT")) {
                    try {
                        object = gGEP.getBytes("DHT");
                        if (((byte[])object).length >= 3) {
                            n8 = ByteUtils.ushort2int(ByteUtils.beb2short(object, 0));
                            byte by3 = (byte)(object[2] & 0xF);
                            dHTMode = DHTManager.DHTMode.valueOf(by3);
                            if (dHTMode == null) {
                                n8 = -1;
                            }
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                if (gGEP.hasKey("LOC")) {
                    try {
                        object = gGEP.getBytes("LOC");
                        if (((byte[])object).length >= 2) {
                            string2 = new String((byte[])object, 0, 2);
                        }
                        if (((byte[])object).length >= 3) {
                            n6 = ByteUtils.ubyte2int(object[2]);
                        }
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
                if (gGEP.hasKey("IP")) {
                    try {
                        object = gGEP.getBytes("IP");
                        byte[] byArray3 = new byte[4];
                        if (((byte[])object).length >= 6) {
                            System.arraycopy(object, 0, byArray3, 0, 4);
                        }
                        if (!NetworkUtils.isValidAddress(byArray3)) break block46;
                        try {
                            inetAddress2 = InetAddress.getByAddress(byArray3);
                            n7 = ByteUtils.ushort2int(ByteUtils.leb2short(object, 4));
                            if (networkInstanceUtils.isPrivateAddress(inetAddress2) || !NetworkUtils.isValidPort(n7)) {
                                inetAddress2 = null;
                                n7 = 0;
                            }
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
            }
            if (gGEP.hasKey("UDPHC")) {
                string3 = "";
                try {
                    string3 = gGEP.getString("UDPHC");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            if (gGEP.hasKey("IPP")) {
                try {
                    object = gGEP.getBytes("IPP");
                    list = NetworkUtils.unpackIps(object);
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                }
                catch (InvalidDataException invalidDataException) {
                    // empty catch block
                }
                if (gGEP.hasKey("IPP_TLS")) {
                    try {
                        object = gGEP.getBytes("IPP_TLS");
                        list = this.decoratePackedIPs((byte[])object, list);
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {
                        // empty catch block
                    }
                }
            }
            if (gGEP.hasKey("DHTIPP")) {
                try {
                    object = gGEP.getBytes("DHTIPP");
                    list2 = NetworkUtils.unpackIps(object);
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                }
                catch (InvalidDataException invalidDataException) {
                    // empty catch block
                }
            }
            if (gGEP.hasKey("PHC")) {
                try {
                    object = gGEP.getString("PHC");
                    list3 = this.listCaches((String)object);
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            bl2 = gGEP.hasKey("TLS");
        }
        this.MY_IP = inetAddress2;
        this.MY_PORT = n7;
        this.HAS_GGEP_EXTENSION = gGEP != null;
        this.DAILY_UPTIME = n;
        this.SUPPORTS_UNICAST = bl;
        this.VENDOR = string;
        this.VENDOR_MAJOR_VERSION = n2;
        this.VENDOR_MINOR_VERSION = n3;
        this.QUERY_KEY = addressSecurityToken;
        this.FREE_LEAF_SLOTS = n4;
        this.FREE_ULTRAPEER_SLOTS = n5;
        this.CLIENT_LOCALE = string2;
        this.FREE_LOCALE_SLOTS = n6;
        this.UDP_CACHE_ADDRESS = string3 != null && "".equals(string3) ? this.getAddress() : string3;
        this.PACKED_IP_PORTS = list;
        this.PACKED_DHT_IP_PORTS = list2;
        this.PACKED_UDP_HOST_CACHES = list3;
        this.DHT_VERSION = n8;
        this.DHT_MODE = dHTMode;
        this.TLS_CAPABLE = bl2;
    }

    private List<IpPort> decoratePackedIPs(byte[] byArray, List<IpPort> list) {
        if (byArray.length == 0) {
            return list;
        }
        ArrayList<IpPort> arrayList = null;
        BitNumbers bitNumbers = new BitNumbers(byArray);
        int n = 0;
        for (IpPort ipPort : list) {
            if (bitNumbers.isSet(n)) {
                ExtendedEndpoint extendedEndpoint = new ExtendedEndpoint(ipPort.getInetAddress(), ipPort.getPort());
                extendedEndpoint.setTLSCapable(true);
                if (arrayList == null) {
                    arrayList = new ArrayList<IpPort>(list.size());
                    arrayList.addAll(list.subList(0, n));
                }
                arrayList.add(extendedEndpoint);
            } else if (arrayList != null) {
                arrayList.add(ipPort);
            }
            if (n >= bitNumbers.getMax()) {
                if (arrayList == null || n + 1 >= list.size()) break;
                arrayList.addAll(list.subList(n + 1, list.size()));
                break;
            }
            ++n;
        }
        if (arrayList != null) {
            assert (arrayList.size() == list.size()) : "decorated: " + arrayList + ", hosts: " + list;
            return arrayList;
        }
        return list;
    }

    @Override
    public boolean hasFreeSlots() {
        return this.hasFreeLeafSlots() || this.hasFreeUltrapeerSlots();
    }

    @Override
    public boolean hasFreeLeafSlots() {
        return this.FREE_LEAF_SLOTS > 0;
    }

    @Override
    public boolean hasFreeUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS > 0;
    }

    @Override
    public int getNumLeafSlots() {
        return this.FREE_LEAF_SLOTS;
    }

    @Override
    public int getNumUltrapeerSlots() {
        return this.FREE_ULTRAPEER_SLOTS;
    }

    @Override
    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.PAYLOAD);
    }

    @Override
    public int getPort() {
        return this.PORT;
    }

    @Override
    public String getAddress() {
        return this.IP.getHostAddress();
    }

    @Override
    public byte[] getIPBytes() {
        byte[] byArray = new byte[]{this.PAYLOAD[2], this.PAYLOAD[3], this.PAYLOAD[4], this.PAYLOAD[5]};
        return byArray;
    }

    @Override
    public long getFiles() {
        return this.FILES;
    }

    @Override
    public long getKbytes() {
        return this.KILOBYTES;
    }

    @Override
    public int getDailyUptime() {
        return this.DAILY_UPTIME;
    }

    @Override
    public boolean supportsUnicast() {
        return this.SUPPORTS_UNICAST;
    }

    @Override
    public AddressSecurityToken getQueryKey() {
        return this.QUERY_KEY;
    }

    @Override
    public List<IpPort> getPackedIPPorts() {
        return this.PACKED_IP_PORTS;
    }

    @Override
    public List<IpPort> getPackedDHTIPPorts() {
        return this.PACKED_DHT_IP_PORTS;
    }

    @Override
    public List<IpPort> getPackedUDPHostCaches() {
        return this.PACKED_UDP_HOST_CACHES;
    }

    @Override
    public DHTManager.DHTMode getDHTMode() {
        return this.DHT_MODE;
    }

    @Override
    public int getDHTVersion() {
        return this.DHT_VERSION;
    }

    @Override
    public boolean hasGGEPExtension() {
        return this.HAS_GGEP_EXTENSION;
    }

    private List<IpPort> listCaches(String string) {
        LinkedList<IpPortImpl> linkedList = new LinkedList<IpPortImpl>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            int n2;
            String string2;
            block7: {
                string2 = stringTokenizer.nextToken();
                n2 = string2.indexOf("&");
                if (n2 != -1) {
                    string2 = string2.substring(0, n2);
                }
                n2 = string2.indexOf(":");
                n = 6346;
                if (n2 == 0 || n2 == string2.length()) continue;
                if (n2 != -1) {
                    try {
                        n = Integer.valueOf(string2.substring(n2 + 1));
                        break block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                n2 = string2.length();
            }
            if (!NetworkUtils.isValidPort(n)) continue;
            String string3 = string2.substring(0, n2);
            try {
                linkedList.add(new IpPortImpl(string3, n));
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public boolean isUltrapeer() {
        long l = this.getKbytes();
        if (l < 8L) {
            return false;
        }
        return PingReplyImpl.isPowerOf2(ByteUtils.long2int(l));
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    @Override
    public String toString() {
        return "PingReply(" + this.getAddress() + ":" + this.getPort() + ", free ultrapeers slots: " + this.hasFreeUltrapeerSlots() + ", free leaf slots: " + this.hasFreeLeafSlots() + ", vendor: " + this.VENDOR + " " + this.VENDOR_MAJOR_VERSION + "." + this.VENDOR_MINOR_VERSION + ", " + super.toString() + ", locale : " + this.CLIENT_LOCALE + ")";
    }

    @Override
    public InetAddress getInetAddress() {
        return this.IP;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public InetAddress getMyInetAddress() {
        return this.MY_IP;
    }

    @Override
    public int getMyPort() {
        return this.MY_PORT;
    }

    @Override
    public String getClientLocale() {
        return this.CLIENT_LOCALE;
    }

    @Override
    public int getNumFreeLocaleSlots() {
        return this.FREE_LOCALE_SLOTS;
    }

    @Override
    public boolean isUDPHostCache() {
        return this.UDP_CACHE_ADDRESS != null;
    }

    @Override
    public String getUDPCacheAddress() {
        return this.UDP_CACHE_ADDRESS;
    }

    @Override
    public boolean isTLSCapable() {
        return this.TLS_CAPABLE;
    }

    @Override
    public byte[] getPayload() {
        return this.PAYLOAD;
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return PingReply.class;
    }
}

