/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.LocalPongInfo;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingReplyImpl;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.limewire.collection.BitNumbers;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class PingReplyFactoryImpl
implements PingReplyFactory {
    private final NetworkManager networkManager;
    private final Provider<Statistics> statistics;
    private final Provider<UDPService> udpService;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<DHTManager> dhtManager;
    private final LocalPongInfo localPongInfo;
    private final MACCalculatorRepositoryManager macCalculatorRepositoryManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public PingReplyFactoryImpl(NetworkManager networkManager, Provider<Statistics> provider, Provider<UDPService> provider2, Provider<ConnectionManager> provider3, Provider<HostCatcher> provider4, Provider<DHTManager> provider5, LocalPongInfo localPongInfo, MACCalculatorRepositoryManager mACCalculatorRepositoryManager, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.statistics = provider;
        this.udpService = provider2;
        this.connectionManager = provider3;
        this.hostCatcher = provider4;
        this.dhtManager = provider5;
        this.localPongInfo = localPongInfo;
        this.macCalculatorRepositoryManager = mACCalculatorRepositoryManager;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public PingReply create(byte[] byArray, byte by, Collection<? extends IpPort> collection, Collection<? extends IpPort> collection2) {
        return this.create(byArray, by, this.networkManager.getPort(), this.networkManager.getAddress(), this.localPongInfo.getNumSharedFiles(), this.localPongInfo.getSharedFileSize() / 1024, this.localPongInfo.isSupernode(), ((Statistics)this.statistics.get()).calculateDailyUptime(), ((UDPService)this.udpService.get()).isGUESSCapable(), ApplicationSettings.LANGUAGE.getValue().equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : ApplicationSettings.LANGUAGE.getValue(), ((ConnectionManager)this.connectionManager.get()).getNumLimeWireLocalePrefSlots(), collection, collection2);
    }

    @Override
    public PingReply create(byte[] byArray, byte by) {
        return this.create(byArray, by, IpPort.EMPTY_LIST, IpPort.EMPTY_LIST);
    }

    @Override
    public PingReply create(byte[] byArray, byte by, IpPort ipPort) {
        return this.create(byArray, by, ipPort, IpPort.EMPTY_LIST, IpPort.EMPTY_LIST);
    }

    @Override
    public PingReply create(byte[] byArray, byte by, IpPort ipPort, Collection<? extends IpPort> collection, Collection<? extends IpPort> collection2) {
        GGEP gGEP = this.newGGEP(((Statistics)this.statistics.get()).calculateDailyUptime(), this.localPongInfo.isSupernode(), ((UDPService)this.udpService.get()).isGUESSCapable());
        String string = ApplicationSettings.LANGUAGE.getValue().equals("") ? ApplicationSettings.DEFAULT_LOCALE.getValue() : ApplicationSettings.LANGUAGE.getValue();
        this.addLocale(gGEP, string, ((ConnectionManager)this.connectionManager.get()).getNumLimeWireLocalePrefSlots());
        this.addAddress(gGEP, ipPort);
        this.addPackedHosts(gGEP, collection, collection2);
        return this.create(byArray, by, this.networkManager.getPort(), this.networkManager.getAddress(), this.localPongInfo.getNumSharedFiles(), this.localPongInfo.getSharedFileSize() / 1024, this.localPongInfo.isSupernode(), gGEP);
    }

    @Override
    public PingReply createQueryKeyReply(byte[] byArray, byte by, AddressSecurityToken addressSecurityToken) {
        return this.create(byArray, by, this.networkManager.getPort(), this.networkManager.getAddress(), this.localPongInfo.getNumSharedFiles(), this.localPongInfo.getSharedFileSize() / 1024, this.localPongInfo.isSupernode(), this.qkGGEP(addressSecurityToken));
    }

    @Override
    public PingReply createQueryKeyReply(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, AddressSecurityToken addressSecurityToken) {
        return this.create(byArray, by, n, byArray2, l, l2, bl, this.qkGGEP(addressSecurityToken));
    }

    @Override
    public PingReply create(byte[] byArray, byte by, int n, byte[] byArray2) {
        return this.create(byArray, by, n, byArray2, 0L, 0L, false, -1, false);
    }

    @Override
    public PingReply createExternal(byte[] byArray, byte by, int n, byte[] byArray2, boolean bl) {
        return this.create(byArray, by, n, byArray2, 0L, 0L, bl, -1, false);
    }

    @Override
    public PingReply createExternal(byte[] byArray, byte by, int n, byte[] byArray2, int n2, boolean bl) {
        return this.create(byArray, by, n, byArray2, 0L, 0L, bl, n2, false);
    }

    @Override
    public PingReply createGUESSReply(byte[] byArray, byte by, Endpoint endpoint) throws UnknownHostException {
        return this.create(byArray, by, endpoint.getPort(), endpoint.getHostBytes(), 0L, 0L, true, -1, true);
    }

    @Override
    public PingReply createGUESSReply(byte[] byArray, byte by, int n, byte[] byArray2) {
        return this.create(byArray, by, n, byArray2, 0L, 0L, true, -1, true);
    }

    @Override
    public PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2) {
        return this.create(byArray, by, n, byArray2, l, l2, false, -1, false);
    }

    @Override
    public PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, int n2, boolean bl2) {
        return this.create(byArray, by, n, byArray2, l, l2, bl, this.newGGEP(n2, bl, bl2));
    }

    @Override
    public PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, int n2, boolean bl2, String string, int n3) {
        return this.create(byArray, by, n, byArray2, l, l2, bl, n2, bl2, string, n3, IpPort.EMPTY_LIST, IpPort.EMPTY_LIST);
    }

    @Override
    public PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, int n2, boolean bl2, String string, int n3, Collection<? extends IpPort> collection, Collection<? extends IpPort> collection2) {
        GGEP gGEP = this.newGGEP(n2, bl, bl2);
        this.addLocale(gGEP, string, n3);
        this.addPackedHosts(gGEP, collection, collection2);
        return this.create(byArray, by, n, byArray2, l, l2, bl, gGEP);
    }

    @Override
    public PingReply create(byte[] byArray, byte by, int n, byte[] byArray2, long l, long l2, boolean bl, GGEP gGEP) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(byArray2));
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(NetworkUtils.ip2string(byArray2));
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(unknownHostException);
        }
        byte[] byArray3 = null;
        if (gGEP != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            byArray3 = byteArrayOutputStream.toByteArray();
        }
        int n2 = 14 + (byArray3 == null ? 0 : byArray3.length);
        byte[] byArray4 = new byte[n2];
        ByteUtils.short2leb((short)n, byArray4, 0);
        byArray4[2] = byArray2[0];
        byArray4[3] = byArray2[1];
        byArray4[4] = byArray2[2];
        byArray4[5] = byArray2[3];
        ByteUtils.int2leb((int)l, byArray4, 6);
        ByteUtils.int2leb((int)(bl ? this.mark(l2) : l2), byArray4, 10);
        if (byArray3 != null) {
            System.arraycopy(byArray3, 0, byArray4, 14, byArray3.length);
        }
        try {
            return new PingReplyImpl(byArray, by, 0, byArray4, gGEP, inetAddress, Message.Network.UNKNOWN, this.macCalculatorRepositoryManager, this.networkInstanceUtils);
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalStateException(badPacketException);
        }
    }

    @Override
    public PingReply createFromNetwork(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        return this.createFromNetwork(byArray, by, by2, byArray2, Message.Network.UNKNOWN);
    }

    @Override
    public PingReply createFromNetwork(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
        if (byArray == null) {
            throw new NullPointerException("null guid");
        }
        if (byArray2 == null) {
            throw new NullPointerException("null payload");
        }
        if (byArray2.length < 14) {
            throw new BadPacketException("invalid payload length");
        }
        int n = ByteUtils.ushort2int(ByteUtils.leb2short(byArray2, 0));
        if (!NetworkUtils.isValidPort(n)) {
            throw new BadPacketException("invalid port: " + n);
        }
        String string = NetworkUtils.ip2string(byArray2, 2);
        InetAddress inetAddress = null;
        GGEP gGEP = this.parseGGEP(byArray2);
        if (gGEP != null) {
            Object object;
            if (gGEP.hasKey("LOC")) {
                try {
                    gGEP.getBytes("LOC");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException("GGEP error : creating from network : client locale");
                }
            }
            if (gGEP.hasKey("IPP")) {
                object = null;
                try {
                    object = gGEP.getBytes("IPP");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException(badGGEPPropertyException.getMessage());
                }
                if (object == null || ((byte[])object).length % 6 != 0) {
                    throw new BadPacketException("invalid data");
                }
            }
            if (gGEP.hasKey("PHC")) {
                try {
                    gGEP.getBytes("PHC");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    throw new BadPacketException(badGGEPPropertyException.getMessage());
                }
            }
            if (gGEP.hasKey("UDPHC")) {
                try {
                    object = gGEP.getString("UDPHC");
                    inetAddress = InetAddress.getByName((String)object);
                    string = inetAddress.getHostAddress();
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                }
                catch (UnknownHostException unknownHostException) {
                    throw new BadPacketException(unknownHostException.getMessage());
                }
            }
        }
        if (!NetworkUtils.isValidAddress(string)) {
            throw new BadPacketException("invalid address: " + string);
        }
        if (inetAddress == null) {
            try {
                inetAddress = InetAddress.getByName(NetworkUtils.ip2string(byArray2, 2));
            }
            catch (UnknownHostException unknownHostException) {
                throw new BadPacketException("bad IP:" + string + " " + unknownHostException.getMessage());
            }
        }
        return new PingReplyImpl(byArray, by, by2, byArray2, gGEP, inetAddress, network, this.macCalculatorRepositoryManager, this.networkInstanceUtils);
    }

    @Override
    public PingReply mutateGUID(PingReply pingReply, byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("bad guid size: " + byArray.length);
        }
        try {
            return this.createFromNetwork(byArray, pingReply.getTTL(), pingReply.getHops(), pingReply.getPayload(), pingReply.getNetwork());
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException("Input pong was bad!");
        }
    }

    private GGEP newGGEP(int n, boolean bl, boolean bl2) {
        GGEP gGEP = new GGEP();
        if (n >= 0) {
            gGEP.put("DU", n);
        }
        if (bl2 && bl) {
            gGEP.put("GUE");
        }
        if (bl) {
            this.addUltrapeerExtension(gGEP);
        }
        this.addDHTExtension(gGEP);
        if (SSLSettings.isIncomingTLSEnabled()) {
            gGEP.put("TLS");
        }
        return gGEP;
    }

    private GGEP qkGGEP(AddressSecurityToken addressSecurityToken) {
        try {
            GGEP gGEP = new GGEP();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            addressSecurityToken.write(byteArrayOutputStream);
            gGEP.put("QK", byteArrayOutputStream.toByteArray());
            return gGEP;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't encode AddressSecurityToken" + addressSecurityToken, iOException);
        }
    }

    private GGEP addLocale(GGEP gGEP, String string, int n) {
        byte[] byArray = new byte[3];
        byte[] byArray2 = string.getBytes();
        byArray[0] = byArray2[0];
        byArray[1] = byArray2[1];
        byArray[2] = (byte)n;
        gGEP.put("LOC", byArray);
        return gGEP;
    }

    private GGEP addAddress(GGEP gGEP, IpPort ipPort) {
        byte[] byArray = new byte[6];
        System.arraycopy(ipPort.getInetAddress().getAddress(), 0, byArray, 0, 4);
        ByteUtils.short2leb((short)ipPort.getPort(), byArray, 4);
        gGEP.put("IP", byArray);
        return gGEP;
    }

    private GGEP addPackedHosts(GGEP gGEP, Collection<? extends IpPort> collection, Collection<? extends IpPort> collection2) {
        if (collection != null && !collection.isEmpty()) {
            gGEP.put("IPP", NetworkUtils.packIpPorts(collection));
            byte[] byArray = this.getTLSData(collection);
            if (byArray.length != 0) {
                gGEP.put("IPP_TLS", byArray);
            }
        }
        if (collection2 != null && !collection2.isEmpty()) {
            gGEP.put("DHTIPP", NetworkUtils.packIpPorts(collection2));
        }
        return gGEP;
    }

    private byte[] getTLSData(Collection<? extends IpPort> collection) {
        BitNumbers bitNumbers = new BitNumbers(collection.size());
        int n = 0;
        for (IpPort ipPort : collection) {
            if (((HostCatcher)this.hostCatcher.get()).isHostTLSCapable(ipPort)) {
                bitNumbers.set(n);
            }
            ++n;
        }
        return bitNumbers.toByteArray();
    }

    private void addUltrapeerExtension(GGEP gGEP) {
        byte[] byArray = new byte[]{0, this.localPongInfo.getNumFreeLimeWireLeafSlots(), this.localPongInfo.getNumFreeLimeWireNonLeafSlots()};
        gGEP.put("UP", byArray);
    }

    private void addDHTExtension(GGEP gGEP) {
        byte[] byArray = new byte[3];
        int n = ((DHTManager)this.dhtManager.get()).getVersion().shortValue();
        ByteUtils.short2beb((short)n, byArray, 0);
        if (((DHTManager)this.dhtManager.get()).isMemberOfDHT()) {
            DHTManager.DHTMode dHTMode = ((DHTManager)this.dhtManager.get()).getDHTMode();
            assert (dHTMode != null);
            byArray[2] = dHTMode.byteValue();
        } else {
            byArray[2] = DHTManager.DHTMode.INACTIVE.byteValue();
        }
        gGEP.put("DHT", byArray);
    }

    private GGEP parseGGEP(byte[] byArray) {
        if (byArray.length <= 14) {
            return null;
        }
        try {
            return new GGEP(byArray, 14, null);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            return null;
        }
    }

    private long mark(long l) {
        int n = ByteUtils.long2int(l);
        if (n < 12) {
            return 8L;
        }
        if (n < 24) {
            return 16L;
        }
        if (n < 48) {
            return 32L;
        }
        if (n < 96) {
            return 64L;
        }
        if (n < 192) {
            return 128L;
        }
        if (n < 384) {
            return 256L;
        }
        if (n < 768) {
            return 512L;
        }
        if (n < 1536) {
            return 1024L;
        }
        if (n < 3072) {
            return 2048L;
        }
        if (n < 6144) {
            return 4096L;
        }
        if (n < 12288) {
            return 8192L;
        }
        if (n < 24576) {
            return 16384L;
        }
        if (n < 49152) {
            return 32768L;
        }
        if (n < 98304) {
            return 65536L;
        }
        if (n < 196608) {
            return 131072L;
        }
        if (n < 393216) {
            return 262144L;
        }
        if (n < 786432) {
            return 524288L;
        }
        if (n < 0x180000) {
            return 0x100000L;
        }
        if (n < 0x300000) {
            return 0x200000L;
        }
        if (n < 0x600000) {
            return 0x400000L;
        }
        if (n < 0xC00000) {
            return 0x800000L;
        }
        if (n < 0x1800000) {
            return 0x1000000L;
        }
        if (n < 0x3000000) {
            return 0x2000000L;
        }
        if (n < 0x6000000) {
            return 0x4000000L;
        }
        if (n < 0xC000000) {
            return 0x8000000L;
        }
        if (n < 0x18000000) {
            return 0x10000000L;
        }
        if (n < 0x30000000) {
            return 0x20000000L;
        }
        return 0x40000000L;
    }
}

