/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.limewire.collection.Buffer;
import org.limewire.inspection.Inspectable;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Message
extends Comparable<Message> {
    public static final byte F_PING = 0;
    public static final byte F_PING_REPLY = 1;
    public static final byte F_PUSH = 64;
    public static final byte F_QUERY = -128;
    public static final byte F_QUERY_REPLY = -127;
    public static final byte F_ROUTE_TABLE_UPDATE = 48;
    public static final byte F_VENDOR_MESSAGE = 49;
    public static final byte F_VENDOR_MESSAGE_STABLE = 50;
    public static final byte F_UDP_CONNECTION = 65;

    public void writeQuickly(OutputStream var1) throws IOException;

    public void write(OutputStream var1, byte[] var2) throws IOException;

    public void write(OutputStream var1) throws IOException;

    public Network getNetwork();

    public boolean isMulticast();

    public boolean isUDP();

    public boolean isTCP();

    public boolean isUnknownNetwork();

    public byte[] getGUID();

    public byte getFunc();

    public byte getTTL();

    public void setTTL(byte var1) throws IllegalArgumentException;

    public void setHops(byte var1) throws IllegalArgumentException;

    public byte getHops();

    public int getLength();

    public int getTotalLength();

    public byte hop();

    public long getCreationTime();

    public int getPriority();

    public void setPriority(int var1);

    public Class<? extends Message> getHandlerClass();

    public static class MessageCounter
    implements Inspectable {
        private final Map<Class, EnumMap<Network, MessageTypeCounter>> counts = new HashMap<Class, EnumMap<Network, MessageTypeCounter>>();
        private final int history;

        public MessageCounter(int n) {
            this.history = n;
        }

        public synchronized void countMessage(Message message) {
            MessageTypeCounter messageTypeCounter;
            EnumMap<Network, MessageTypeCounter> enumMap = this.counts.get(message.getClass());
            if (enumMap == null) {
                enumMap = new EnumMap(Network.class);
                this.counts.put(message.getClass(), enumMap);
            }
            if ((messageTypeCounter = enumMap.get((Object)message.getNetwork())) == null) {
                messageTypeCounter = new MessageTypeCounter(message.getClass(), message.getNetwork(), this.history);
                enumMap.put(message.getNetwork(), messageTypeCounter);
            }
            messageTypeCounter.countMessage(message);
        }

        public synchronized Object inspect() {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(this.counts.size());
            for (EnumMap<Network, MessageTypeCounter> enumMap : this.counts.values()) {
                for (MessageTypeCounter messageTypeCounter : enumMap.values()) {
                    arrayList.add(messageTypeCounter.inspect());
                }
            }
            return arrayList;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class MessageTypeCounter {
            private final Class clazz;
            private final Network net;
            private long num;
            private long size;
            private Buffer<Long> timestamps;
            private Buffer<Integer> sizes;
            private Buffer<Byte> hops;
            private Buffer<Byte> ttls;
            private long[] totalTtls = new long[5];
            private long[] totalHops = new long[5];

            MessageTypeCounter(Class<? extends Message> clazz, Network network, int n) {
                this.clazz = clazz;
                this.net = network;
                this.timestamps = new Buffer(n);
                this.sizes = new Buffer(n);
                this.hops = new Buffer(n);
                this.ttls = new Buffer(n);
            }

            void countMessage(Message message) {
                ++this.num;
                this.size += (long)message.getLength();
                this.timestamps.add(System.currentTimeMillis());
                this.sizes.add(message.getLength());
                this.hops.add(message.getHops());
                this.ttls.add(message.getTTL());
                int n = Math.min(4, message.getTTL());
                this.totalTtls[n] = this.totalTtls[n] + 1L;
                int n2 = Math.min(4, message.getHops());
                this.totalHops[n2] = this.totalHops[n2] + 1L;
            }

            Map<String, Object> inspect() {
                int n;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("class", this.clazz.toString());
                hashMap.put("net", this.net.toString());
                hashMap.put("num", this.num);
                hashMap.put("size", this.size);
                byte[] byArray = new byte[this.timestamps.getSize() * 6];
                byte[] byArray2 = new byte[this.sizes.getSize() * 2];
                byte[] byArray3 = new byte[this.hops.getSize()];
                byte[] byArray4 = new byte[this.ttls.getSize()];
                for (n = 0; n < this.timestamps.getSize(); ++n) {
                    long l = this.timestamps.get(n);
                    byArray[n * 6] = (byte)(l >> 40 & 0xFFL);
                    byArray[n * 6 + 1] = (byte)(l >> 32 & 0xFFL);
                    ByteUtils.int2beb((int)l, byArray, n * 6 + 2);
                }
                for (n = 0; n < this.sizes.getSize(); ++n) {
                    short s = (short)Math.min(65535, this.sizes.get(n));
                    ByteUtils.short2beb(s, byArray2, n * 2);
                }
                for (n = 0; n < this.hops.getSize(); ++n) {
                    byArray3[n] = this.hops.get(n);
                }
                for (n = 0; n < this.ttls.getSize(); ++n) {
                    byArray4[n] = this.ttls.get(n);
                }
                hashMap.put("times", byArray);
                hashMap.put("sizes", byArray2);
                hashMap.put("hops", byArray3);
                hashMap.put("ttls", byArray4);
                hashMap.put("totalTttls", this.totalTtls);
                hashMap.put("totalHops", this.totalHops);
                return hashMap;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Network {
        UNKNOWN,
        TCP,
        UDP,
        MULTICAST;

    }
}

