/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.GGEP;

public class GGEPParser {
    private static final Log LOG = LogFactory.getLog(GGEPParser.class);
    private GGEP normal = null;
    private GGEP secure = null;
    private int secureStart = -1;
    private int secureEnd = -1;
    private int normalStart = -1;
    private int normalEnd = -1;

    public void scanForGGEPs(byte[] byArray, int n) {
        while (n < byArray.length && byArray[n] != -61) {
            ++n;
        }
        if (n >= byArray.length) {
            LOG.debug((Object)"No GGEP in data");
            return;
        }
        int[] nArray = new int[1];
        GGEP gGEP = null;
        GGEP gGEP2 = null;
        int n2 = -1;
        int n3 = -1;
        try {
            while (n < byArray.length && byArray[n] == -61) {
                GGEP gGEP3 = new GGEP(byArray, n, nArray);
                if (gGEP3.hasKey("SB")) {
                    gGEP2 = gGEP3;
                    n2 = n;
                    n3 = nArray[0];
                    break;
                }
                this.normalStart = n;
                this.normalEnd = nArray[0];
                if (gGEP == null) {
                    gGEP = gGEP3;
                } else {
                    gGEP.merge(gGEP3);
                }
                n = nArray[0];
                nArray[0] = -1;
            }
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            LOG.debug((Object)"Unable to create ggep", (Throwable)badGGEPBlockException);
        }
        this.normal = gGEP;
        this.secure = gGEP2;
        this.secureStart = n2;
        this.secureEnd = n3;
    }

    public GGEP getNormalGGEP() {
        return this.normal;
    }

    public GGEP getSecureGGEP() {
        return this.secure;
    }

    public int getSecureStartIndex() {
        return this.secureStart;
    }

    public int getSecureEndIndex() {
        return this.secureEnd;
    }

    public int getNormalStartIndex() {
        return this.normalStart;
    }

    public int getNormalEndIndex() {
        return this.normalEnd;
    }
}

