/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.messagehandlers.RestrictedResponder;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPongFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.io.NetworkInstanceUtils;

public class UDPCrawlerPingHandler
extends RestrictedResponder {
    private FixedSizeExpiringSet<InetAddress> _UDPListRequestors = new FixedSizeExpiringSet(2000, 600000L);
    private final UDPCrawlerPongFactory udpCrawlerPongFactory;

    @Inject
    public UDPCrawlerPingHandler(NetworkManager networkManager, SimppManager simppManager, UDPReplyHandlerFactory uDPReplyHandlerFactory, UDPReplyHandlerCache uDPReplyHandlerCache, UDPCrawlerPongFactory uDPCrawlerPongFactory, NetworkInstanceUtils networkInstanceUtils) {
        super(FilterSettings.CRAWLER_IP_ADDRESSES, networkManager, simppManager, uDPReplyHandlerFactory, uDPReplyHandlerCache, null, networkInstanceUtils);
        this.udpCrawlerPongFactory = uDPCrawlerPongFactory;
    }

    protected void processAllowedMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        assert (message instanceof UDPCrawlerPing);
        if (!this._UDPListRequestors.add(replyHandler.getInetAddress())) {
            return;
        }
        UDPCrawlerPong uDPCrawlerPong = this.udpCrawlerPongFactory.createUDPCrawlerPong((UDPCrawlerPing)message);
        replyHandler.reply(uDPCrawlerPong);
    }
}

