/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.limegroup.gnutella.ReplyHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.limewire.io.NetworkUtils;
import org.limewire.security.AbstractSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;

public class OOBSecurityToken
extends AbstractSecurityToken {
    public OOBSecurityToken(OOBTokenData oOBTokenData, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) {
        super(oOBTokenData, mACCalculatorRepositoryManager);
    }

    public OOBSecurityToken(byte[] byArray, MACCalculatorRepositoryManager mACCalculatorRepositoryManager) throws InvalidSecurityTokenException {
        super(byArray, mACCalculatorRepositoryManager);
    }

    protected byte[] getFromMAC(byte[] byArray, SecurityToken.TokenData tokenData) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)((OOBTokenData)tokenData).getNumRequests();
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    protected boolean isValidTokenData(SecurityToken.TokenData tokenData) {
        return tokenData instanceof OOBTokenData;
    }

    public static class OOBTokenData
    implements SecurityToken.TokenData {
        private final int numRequests;
        private final byte[] data;

        public OOBTokenData(ReplyHandler replyHandler, byte[] byArray, int n) {
            this(replyHandler.getInetAddress(), replyHandler.getPort(), byArray, n);
        }

        public OOBTokenData(InetAddress inetAddress, int n, byte[] byArray, int n2) {
            if (n2 < 0 || n2 > 255) {
                throw new IllegalArgumentException("requestNum to small or too large " + n2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(35);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeShort(n);
                if (NetworkUtils.isIPv6Compatible(inetAddress)) {
                    dataOutputStream.write(NetworkUtils.getIPv6AddressBytes(inetAddress));
                } else {
                    dataOutputStream.write(inetAddress.getAddress());
                }
                dataOutputStream.write(n2);
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            this.data = byteArrayOutputStream.toByteArray();
            this.numRequests = n2;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getNumRequests() {
            return this.numRequests;
        }
    }
}

