/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.settings.MessageSettings;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.lifecycle.Service;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LimeACKHandler
implements MessageHandler,
Service {
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<UDPService> udpService;
    private final Map<GUID.TimedGUID, QueryResponseBundle> _outOfBandReplies = new Hashtable<GUID.TimedGUID, QueryResponseBundle>();

    @Inject
    public LimeACKHandler(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<MessageRouter> provider, Provider<UDPService> provider2) {
        this.backgroundExecutor = scheduledExecutorService;
        this.messageRouter = provider;
        this.udpService = provider2;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        this.backgroundExecutor.scheduleAtFixedRate(new Expirer(), 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
    }

    @Override
    public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        LimeACKVendorMessage limeACKVendorMessage = (LimeACKVendorMessage)message;
        GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(limeACKVendorMessage.getGUID()), 25000L);
        QueryResponseBundle queryResponseBundle = this._outOfBandReplies.remove(timedGUID);
        SecurityToken securityToken = limeACKVendorMessage.getSecurityToken();
        if (queryResponseBundle != null && limeACKVendorMessage.getNumResults() > 0) {
            Iterable<QueryReply> iterable;
            final InetAddress inetAddress = inetSocketAddress.getAddress();
            final int n = inetSocketAddress.getPort();
            if (limeACKVendorMessage.getNumResults() < queryResponseBundle._responses.length) {
                Response[] responseArray = new Response[limeACKVendorMessage.getNumResults()];
                System.arraycopy(queryResponseBundle._responses, 0, responseArray, 0, responseArray.length);
                iterable = ((MessageRouter)this.messageRouter.get()).responsesToQueryReplies(responseArray, queryResponseBundle._query, 1, securityToken);
            } else {
                iterable = ((MessageRouter)this.messageRouter.get()).responsesToQueryReplies(queryResponseBundle._responses, queryResponseBundle._query, 1, securityToken);
            }
            int n2 = 0;
            for (final QueryReply queryReply : iterable) {
                this.backgroundExecutor.schedule(new Runnable(){

                    public void run() {
                        ((UDPService)LimeACKHandler.this.udpService.get()).send(queryReply, inetAddress, n);
                    }
                }, (long)(n2++ * 200), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bufferResponsesForLaterDelivery(QueryRequest queryRequest, Response[] responseArray) {
        Map<GUID.TimedGUID, QueryResponseBundle> map = this._outOfBandReplies;
        synchronized (map) {
            if (this._outOfBandReplies.size() < MessageSettings.MAX_BUFFERED_OOB_REPLIES.getValue()) {
                GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(queryRequest.getGUID()), 25000L);
                this._outOfBandReplies.put(timedGUID, new QueryResponseBundle(queryRequest, responseArray));
                return true;
            }
            return false;
        }
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet<GUID.TimedGUID> hashSet = new HashSet<GUID.TimedGUID>();
            Map map = LimeACKHandler.this._outOfBandReplies;
            synchronized (map) {
                long l = System.currentTimeMillis();
                for (GUID.TimedGUID timedGUID : LimeACKHandler.this._outOfBandReplies.keySet()) {
                    if (timedGUID == null || !timedGUID.shouldExpire(l)) continue;
                    hashSet.add(timedGUID);
                }
                for (GUID.TimedGUID timedGUID : hashSet) {
                    LimeACKHandler.this._outOfBandReplies.remove(timedGUID);
                }
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest queryRequest, Response[] responseArray) {
            this._query = queryRequest;
            this._responses = responseArray;
        }
    }
}

