/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.License;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;

@Singleton
public class LicenseCache {
    private static final Log LOG = LogFactory.getLog(LicenseCache.class);
    private static final long EXPIRY_TIME = 604800000L;
    private final File CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "licenses.cache");
    private Map<URI, License> licenses;
    private Map<Object, Object> data;
    private boolean dirty = false;

    LicenseCache() {
        this.deserialize();
    }

    synchronized void addVerifiedLicense(License license) {
        this.licenses.put(license.getLicenseURI(), license);
        this.dirty = true;
    }

    synchronized void addData(Object object, Object object2) {
        this.data.put(object, object2);
        this.dirty = true;
    }

    synchronized License getLicense(String string, URI uRI) {
        License license = this.licenses.get(uRI);
        if (license != null) {
            return license.copy(string, uRI);
        }
        return null;
    }

    synchronized Object getData(Object object) {
        return this.data.get(object);
    }

    synchronized boolean isVerifiedAndValid(URN uRN, URI uRI) {
        License license = this.licenses.get(uRI);
        return license != null && license.isValid(uRN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deserialize() {
        block15: {
            ObjectInputStream objectInputStream;
            block14: {
                objectInputStream = null;
                if (this.CACHE_FILE.exists()) break block14;
                IOUtils.close(objectInputStream);
                if (this.licenses == null) {
                    this.licenses = new HashMap<URI, License>();
                }
                if (this.data == null) {
                    this.data = new HashMap<Object, Object>();
                }
                return;
            }
            try {
                objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.CACHE_FILE)));
                Object object = objectInputStream.readObject();
                if (object != null) {
                    this.licenses = GenericsUtils.scanForMap(object, URI.class, License.class, GenericsUtils.ScanMode.REMOVE);
                }
                if ((object = objectInputStream.readObject()) != null) {
                    this.data = GenericsUtils.scanForMap(object, Object.class, Object.class, GenericsUtils.ScanMode.REMOVE);
                }
                this.removeOldEntries();
            }
            catch (Throwable throwable) {
                try {
                    LOG.error((Object)"Can't read licenses", throwable);
                    break block15;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    IOUtils.close(objectInputStream);
                    if (this.licenses == null) {
                        this.licenses = new HashMap<URI, License>();
                    }
                    if (this.data == null) {
                        this.data = new HashMap<Object, Object>();
                    }
                }
            }
            IOUtils.close(objectInputStream);
            if (this.licenses == null) {
                this.licenses = new HashMap<URI, License>();
            }
            if (this.data == null) {
                this.data = new HashMap<Object, Object>();
            }
        }
    }

    private void removeOldEntries() {
        long l = System.currentTimeMillis() - 604800000L;
        Iterator<License> iterator = this.licenses.values().iterator();
        while (iterator.hasNext()) {
            License license = iterator.next();
            if (license.getLastVerifiedTime() >= l) continue;
            this.dirty = true;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        if (!this.dirty) {
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.CACHE_FILE)));
            objectOutputStream.writeObject(this.licenses);
            objectOutputStream.writeObject(this.data);
            objectOutputStream.flush();
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        finally {
            IOUtils.close(objectOutputStream);
        }
        this.dirty = false;
    }
}

