/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.AbstractLicense;
import com.limegroup.gnutella.licenses.CCConstants;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.service.ErrorService;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CCLicense
extends AbstractLicense {
    private static final Log LOG = LogFactory.getLog(CCLicense.class);
    private static final long serialVersionUID = 8213994964631107858L;
    private transient String license;
    private Map<URN, Details> allWorks;

    CCLicense(String string, URI uRI) {
        super(uRI);
        this.license = string;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public URL getLicenseDeed(URN uRN) {
        Details details = this.getDetails(uRN);
        if (details == null || details.licenseURL == null) {
            return this.guessLicenseDeed();
        }
        return details.licenseURL;
    }

    private URL guessLicenseDeed() {
        return CCConstants.guessLicenseDeed(this.license);
    }

    @Override
    public boolean isValid(URN uRN) {
        return this.getDetails(uRN) != null;
    }

    @Override
    public License copy(String string, URI uRI) {
        CCLicense cCLicense = this.clone();
        if (cCLicense != null) {
            cCLicense.license = string;
            cCLicense.licenseLocation = uRI;
        }
        return cCLicense;
    }

    protected CCLicense clone() {
        try {
            return (CCLicense)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ErrorService.error(cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public String getLicenseDescription(URN uRN) {
        Iterator<Object> iterator;
        List<Object> list = Collections.emptyList();
        List<Object> list2 = Collections.emptyList();
        List<Object> list3 = Collections.emptyList();
        Details details = this.getDetails(uRN);
        if (details != null) {
            list = details.permitted;
            list2 = details.prohibited;
            list3 = details.required;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            stringBuilder.append("Permitted: ");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(((String)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("Prohibited: ");
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(((String)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        if (list3 != null && !list3.isEmpty()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("Required: ");
            iterator = list3.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(((String)iterator.next()).toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("Permissions unknown.");
        }
        return stringBuilder.toString();
    }

    @Override
    protected void clear() {
        if (this.allWorks != null) {
            this.allWorks.clear();
        }
    }

    @Override
    protected String getBody(String string, LimeHttpClient limeHttpClient) {
        return this.locateRDF(super.getBody(string, limeHttpClient));
    }

    private void addWork(URN uRN, String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            LOG.warn((Object)("Unable to make licenseURL out of: " + string), (Throwable)malformedURLException);
        }
        Details details = this.getDetails(uRN);
        if (details != null) {
            URL uRL2;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found existing details item for URN: " + uRN));
            }
            if (uRL != null && (uRL2 = this.guessLicenseDeed()) != null && uRL2.equals(uRL)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating license URL to be: " + uRL));
                }
                details.licenseURL = uRL;
            }
            return;
        }
        details = new Details(uRL);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding new " + details + " for urn: " + uRN));
        }
        if (this.allWorks == null) {
            this.allWorks = new HashMap<URN, Details>(1);
        }
        this.allWorks.put(uRN, details);
    }

    private Details getDetails(URN uRN) {
        if (this.allWorks == null) {
            return null;
        }
        Details details = this.allWorks.get(uRN);
        if (details != null) {
            return details;
        }
        if (uRN != null) {
            return this.allWorks.get(null);
        }
        return this.allWorks.values().iterator().next();
    }

    private List<Details> getDetailsForLicenseURL(URL uRL) {
        if (this.allWorks == null || uRL == null) {
            return Collections.emptyList();
        }
        LinkedList<Details> linkedList = new LinkedList<Details>();
        for (Details details : this.allWorks.values()) {
            if (details.licenseURL == null || !uRL.equals(details.licenseURL)) continue;
            linkedList.add(details);
        }
        return linkedList;
    }

    private String locateRDF(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        int n = string.indexOf("<rdf:RDF");
        if (n >= string.length() - 1) {
            return null;
        }
        int n2 = string.indexOf("rdf:RDF", n + 6);
        if (n == -1 || n2 == -1) {
            return null;
        }
        if ((n2 = string.indexOf(62, n2)) == -1) {
            return null;
        }
        return string.substring(n, n2 + 1);
    }

    @Override
    protected void parseDocumentNode(Node node, LicenseCache licenseCache, LimeHttpClient limeHttpClient) {
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        if (licenseCache != null) {
            for (n = 0; n < nodeList.getLength(); ++n) {
                node2 = nodeList.item(n);
                if (!node2.getNodeName().equals("Work")) continue;
                this.parseWorkItem(node2);
            }
        }
        for (n = 0; n < nodeList.getLength(); ++n) {
            node2 = nodeList.item(n);
            if (!node2.getNodeName().equals("License")) continue;
            this.parseLicenseItem(node2);
        }
        if (licenseCache != null) {
            this.updateLicenseDetails(licenseCache, limeHttpClient);
        }
    }

    protected void parseWorkItem(Node node) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Parsing work item.");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("rdf:about");
        URN uRN = null;
        if (node2 != null) {
            try {
                uRN = URN.createSHA1Urn(node2.getNodeValue());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3;
            Node node4 = nodeList.item(i);
            if (!node4.getNodeName().equals("license") || (node3 = (namedNodeMap = node4.getAttributes()).getNamedItem("rdf:resource")) == null) continue;
            this.addWork(uRN, node3.getNodeValue());
        }
    }

    protected void parseLicenseItem(Node node) {
        Object object;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Parsing license item.");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("rdf:about");
        List<Object> list = Collections.emptyList();
        if (node2 != null) {
            object = node2.getNodeValue();
            try {
                list = this.getDetailsForLicenseURL(new URL((String)object));
            }
            catch (MalformedURLException malformedURLException) {
                LOG.warn((Object)("Unable to create license URL for: " + (String)object), (Throwable)malformedURLException);
            }
        }
        if (!list.iterator().hasNext()) {
            return;
        }
        object = null;
        LinkedList<String> linkedList = null;
        LinkedList<String> linkedList2 = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object2 = nodeList.item(i);
            String string = object2.getNodeName();
            if (string.equalsIgnoreCase("requires")) {
                if (object == null) {
                    object = new LinkedList();
                }
                this.addPermission((List<String>)object, (Node)object2);
                continue;
            }
            if (string.equalsIgnoreCase("permits")) {
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList<String>();
                }
                this.addPermission(linkedList2, (Node)object2);
                continue;
            }
            if (!string.equalsIgnoreCase("prohibits")) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
            }
            this.addPermission(linkedList, (Node)object2);
        }
        for (Object object2 : list) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting license details for " + list));
            }
            ((Details)object2).required = object;
            ((Details)object2).prohibited = linkedList;
            ((Details)object2).permitted = linkedList2;
        }
    }

    private void addPermission(List<String> list, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("rdf:resource");
        if (node2 != null) {
            String string = node2.getNodeValue();
            int n = string.lastIndexOf(47);
            if (n != -1 && n != string.length() - 1) {
                String string2 = string.substring(n + 1);
                if (!list.contains(string2)) {
                    list.add(string2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Added permission: " + string2));
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Duplicate permission: " + string2 + "!"));
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.trace((Object)("Unable to find permission name: " + string));
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"No resource item for permission.");
        }
    }

    private void updateLicenseDetails(LicenseCache licenseCache, LimeHttpClient limeHttpClient) {
        if (this.allWorks == null) {
            return;
        }
        for (Details details : this.allWorks.values()) {
            if (details.isDescriptionAvailable() || details.licenseURL == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating licenseURL for :" + details));
            }
            String string = details.licenseURL.toExternalForm();
            Object object = licenseCache.getData(string);
            String string2 = null;
            if (object != null && object instanceof String) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Using cached data for url: " + string));
                }
                string2 = this.locateRDF((String)object);
            } else {
                string2 = this.getBody(string, limeHttpClient);
                if (string2 != null) {
                    licenseCache.addData(string, string2);
                } else {
                    LOG.debug((Object)("Couldn't retrieve license details from url: " + string));
                }
            }
            if (string2 == null) continue;
            this.parseXML(string2, null, limeHttpClient);
        }
    }

    private static class Details
    implements Serializable {
        private static final long serialVersionUID = -1719502030054241350L;
        URL licenseURL;
        List<String> required;
        List<String> permitted;
        List<String> prohibited;

        Details() {
        }

        Details(URL uRL) {
            this.licenseURL = uRL;
        }

        boolean isDescriptionAvailable() {
            return this.required != null || this.permitted != null || this.prohibited != null;
        }

        public String toString() {
            return "details:: license: " + this.licenseURL;
        }
    }
}

