/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import java.io.File;
import java.util.Locale;
import org.limewire.util.OSUtils;

public class SharingUtils {
    public static boolean isFilePhysicallyShareable(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canRead() || file.isHidden()) {
            return false;
        }
        long l = file.length();
        return l > 0L && l <= 0xFFFFFFFFFFL;
    }

    public static boolean isSensitiveDirectory(File file) {
        if (file == null) {
            return false;
        }
        String string = System.getProperty("user.home");
        if (file.equals(new File(string))) {
            return true;
        }
        String string2 = string.substring(string.lastIndexOf(File.separator) + 1);
        String[] stringArray = OSUtils.isWindowsVista() ? new String[]{"Documents and Settings", string2 + File.separator + "Documents", "Desktop", "Program Files", "Windows", "WINNT", "Users", "Local Settings", "Application Data", "Temp", "Temporary Internet Files"} : (OSUtils.isWindows() ? new String[]{"Documents and Settings", "My Documents", "Desktop", "Program Files", "Windows", "WINNT", "Users", "Local Settings", "Application Data", "Temp", "Temporary Internet Files"} : (OSUtils.isMacOSX() ? new String[]{"Users", "System", "System Folder", "Previous Systems", "private", "Volumes", "Desktop", "Applications", "Applications (Mac OS 9)", "Network"} : (OSUtils.isPOSIX() ? new String[]{"bin", "boot", "dev", "etc", "home", "mnt", "opt", "proc", "root", "sbin", "usr", "var"} : new String[]{})));
        String string3 = file.getPath();
        for (String string4 : stringArray) {
            if (!string3.endsWith(File.separator + string4)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFolderBanned(File file) {
        String string;
        String string2;
        File[] fileArray = File.listRoots();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!file.equals(fileArray[i])) continue;
                return true;
            }
        }
        if ((string2 = file.getName().toLowerCase(Locale.US)).equals("cookies")) {
            return true;
        }
        return string2.equals("low") && (string = file.getParent()) != null && string.toLowerCase(Locale.US).equals("cookies");
    }
}

