/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Container {
    private static final Log LOG = LogFactory.getLog(Container.class);
    private final Map<String, Collection<File>> STORED = new HashMap<String, Collection<File>>();
    private final String filename;

    Container(String string) {
        this.filename = string;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() {
        Map<String, Collection<File>> map = this.readFromDisk();
        Container container = this;
        synchronized (container) {
            if (this.STORED.isEmpty()) {
                this.STORED.putAll(map);
            } else {
                for (Map.Entry<String, Collection<File>> entry : map.entrySet()) {
                    String string = entry.getKey();
                    Collection<File> collection = entry.getValue();
                    Collection<File> collection2 = this.STORED.get(string);
                    if (collection2 == null) {
                        this.STORED.put(string, collection);
                        continue;
                    }
                    Collection<File> collection3 = collection2;
                    synchronized (collection3) {
                        collection2.clear();
                        collection2.addAll(collection);
                    }
                }
            }
        }
    }

    synchronized Set<File> getSet(String string) {
        Collection<File> collection = this.STORED.get(string);
        if (collection != null) {
            return (Set)collection;
        }
        Set<File> set = Collections.synchronizedSet(new HashSet());
        this.STORED.put(string, set);
        return set;
    }

    synchronized void clear() {
        for (Collection<File> collection : this.STORED.values()) {
            collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        HashMap<String, Collection<File>> hashMap;
        Container container = this;
        synchronized (container) {
            hashMap = new HashMap<String, Collection<File>>(this.STORED.size());
            for (Map.Entry<String, Collection<File>> entry : this.STORED.entrySet()) {
                Collection<File> collection;
                String string = entry.getKey();
                Collection<File> collection2 = collection = entry.getValue();
                synchronized (collection2) {
                    if (collection instanceof SortedSet) {
                        hashMap.put(string, new TreeSet((SortedSet)collection));
                    } else if (collection instanceof Set) {
                        hashMap.put(string, new HashSet<File>(collection));
                    } else if (collection instanceof List) {
                        if (collection instanceof RandomAccess) {
                            hashMap.put(string, new ArrayList<File>(collection));
                        } else {
                            hashMap.put(string, new LinkedList<File>(collection));
                        }
                    } else {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("Update to clone! key: " + string));
                        }
                        hashMap.put(string, collection);
                    }
                }
            }
        }
        this.writeToDisk(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(Object object) {
        File file = new File(CommonUtils.getUserSettingsDir(), this.filename);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Can't write to disk!", (Throwable)iOException);
        }
        finally {
            IOUtils.close(objectOutputStream);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Collection<File>> readFromDisk() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

