/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.limewire.service.ErrorService;

public class URIUtils {
    private static final String RESERVED = ";/?:@&=+$,";

    public static URI toURI(String string) throws URISyntaxException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            String string2 = URIUtils.encodeURI(string);
            try {
                uRI = new URI(string2);
            }
            catch (URISyntaxException uRISyntaxException2) {
                if (uRISyntaxException.getCause() == null) {
                    uRISyntaxException.initCause(uRISyntaxException2);
                }
                throw uRISyntaxException;
            }
        }
        return uRI;
    }

    private static String encodeURI(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string, RESERVED, true);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (URIUtils.isDelimiter(string2)) {
                stringBuilder.append(string2);
                continue;
            }
            try {
                stringBuilder.append(URLEncoder.encode(string2, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorService.error(unsupportedEncodingException);
            }
        }
        return stringBuilder.toString();
    }

    private static boolean isDelimiter(String string) {
        return RESERVED.contains(string);
    }
}

