/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.HeaderInterceptor;
import org.limewire.io.NetworkUtils;

public class FeatureHeaderInterceptor
implements HeaderInterceptor {
    private static final Log LOG = LogFactory.getLog(FeatureHeaderInterceptor.class);
    private HTTPUploader uploader;

    public FeatureHeaderInterceptor(HTTPUploader hTTPUploader) {
        this.uploader = hTTPUploader;
    }

    public void process(Header header, HttpContext httpContext) throws HttpException, IOException {
        if (this.readChatHeader(header) || this.readContentURNHeader(header) || this.readQueueVersion(header) || this.readFeatureHeader(header) || this.readXDownloadedHeader(header) || this.readNodeHeader(header)) {
            // empty if block
        }
    }

    private boolean readChatHeader(Header header) throws IOException {
        if (!HTTPHeaderName.CHAT.matches(header)) {
            return false;
        }
        if (!this.setHostAndPort(header.getValue())) {
            throw new ProblemReadingHeaderException();
        }
        this.uploader.setChatEnabled(true);
        this.uploader.setBrowseHostEnabled(true);
        return true;
    }

    private boolean readXDownloadedHeader(Header header) {
        if (!HTTPHeaderName.DOWNLOADED.matches(header)) {
            return false;
        }
        try {
            this.uploader.setTotalAmountUploadedBefore(Integer.parseInt(header.getValue()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private boolean readContentURNHeader(Header header) {
        if (!HTTPHeaderName.GNUTELLA_CONTENT_URN.matches(header)) {
            return false;
        }
        try {
            this.uploader.setRequestedURN(URN.createSHA1Urn(header.getValue()));
        }
        catch (IOException iOException) {
            this.uploader.setRequestedURN(URN.INVALID);
        }
        return true;
    }

    private boolean readQueueVersion(Header header) {
        if (!HTTPHeaderName.QUEUE.matches(header)) {
            return false;
        }
        this.uploader.setSupportsQueueing(true);
        return true;
    }

    private boolean readFeatureHeader(Header header) {
        if (!HTTPHeaderName.FEATURES.matches(header)) {
            return false;
        }
        String string = header.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading feature header: " + string));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            int n = string2.indexOf("/");
            string3 = n == -1 ? string2.toLowerCase(Locale.US).trim() : string2.substring(0, n).toLowerCase(Locale.US).trim();
            if (string3.equals("chat")) {
                this.uploader.setChatEnabled(true);
                continue;
            }
            if (string3.equals("browse")) {
                this.uploader.setBrowseHostEnabled(true);
                continue;
            }
            if (string3.equals("queue")) {
                this.uploader.setSupportsQueueing(true);
                continue;
            }
            if (string3.equals("fwalt")) {
                this.uploader.getAltLocTracker().setWantsFAlts(true);
                continue;
            }
            if (!string3.equals("fwt")) continue;
            try {
                this.uploader.getAltLocTracker().setFwtVersion((int)HTTPUtils.parseFeatureToken(string2));
                this.uploader.getAltLocTracker().setWantsFAlts(true);
            }
            catch (ProblemReadingHeaderException problemReadingHeaderException) {}
        }
        return true;
    }

    private boolean readNodeHeader(Header header) {
        if (!HTTPHeaderName.NODE.matches(header)) {
            return false;
        }
        this.setHostAndPort(header.getValue());
        return true;
    }

    private boolean setHostAndPort(String string) {
        int n = -1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() == 2) {
            try {
                InetAddress inetAddress = InetAddress.getByName(stringTokenizer.nextToken().trim());
                n = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (NetworkUtils.isValidPort(n)) {
                    this.uploader.setHost(inetAddress.getHostAddress());
                    this.uploader.setGnutellaPort(n);
                    return true;
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

