/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpParams;
import org.limewire.collection.Cancellable;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.http.httpclient.HttpClientUtils;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.nio.observer.Shutdownable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultHttpExecutor
implements HttpExecutor {
    private static final ExecutorService POOL = ExecutorsHelper.newThreadPool("HttpClient pool");
    private final Provider<LimeHttpClient> clientProvider;

    @Inject
    public DefaultHttpExecutor(Provider<LimeHttpClient> provider) {
        this.clientProvider = provider;
    }

    @Override
    public Shutdownable execute(HttpUriRequest httpUriRequest, HttpParams httpParams, HttpClientListener httpClientListener) {
        return this.execute(httpUriRequest, httpParams, httpClientListener, POOL);
    }

    @Override
    public Shutdownable execute(final HttpUriRequest httpUriRequest, final HttpParams httpParams, final HttpClientListener httpClientListener, ExecutorService executorService) {
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultHttpExecutor.this.performRequest(httpUriRequest, httpParams, httpClientListener);
            }
        };
        executorService.execute(runnable);
        return new Aborter(httpUriRequest);
    }

    @Override
    public void releaseResources(HttpResponse httpResponse) {
        HttpClientUtils.releaseConnection(httpResponse);
    }

    @Override
    public Shutdownable executeAny(HttpClientListener httpClientListener, ExecutorService executorService, Iterable<? extends HttpUriRequest> iterable, HttpParams httpParams, Cancellable cancellable) {
        MultiRequestor multiRequestor = new MultiRequestor(httpClientListener, iterable, httpParams, cancellable);
        executorService.execute(multiRequestor);
        return multiRequestor;
    }

    private boolean performRequest(HttpUriRequest httpUriRequest, HttpParams httpParams, HttpClientListener httpClientListener) {
        HttpResponse httpResponse;
        if (!httpClientListener.allowRequest(httpUriRequest)) {
            return false;
        }
        LimeHttpClient limeHttpClient = (LimeHttpClient)this.clientProvider.get();
        if (httpParams != null) {
            limeHttpClient.setParams(httpParams);
        }
        try {
            httpResponse = limeHttpClient.execute(httpUriRequest);
        }
        catch (IOException iOException) {
            return !httpClientListener.requestFailed(httpUriRequest, null, iOException);
        }
        catch (HttpException httpException) {
            IOException iOException = new IOException();
            iOException.initCause(httpException);
            return !httpClientListener.requestFailed(httpUriRequest, null, iOException);
        }
        catch (IllegalStateException illegalStateException) {
            IOException iOException = new IOException();
            iOException.initCause(illegalStateException);
            return !httpClientListener.requestFailed(httpUriRequest, null, iOException);
        }
        return !httpClientListener.requestComplete(httpUriRequest, httpResponse);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiRequestor
    implements Runnable,
    Shutdownable {
        private boolean shutdown;
        private HttpUriRequest currentMethod;
        private final Iterable<? extends HttpUriRequest> methods;
        private final HttpClientListener listener;
        private HttpParams params;
        private final Cancellable canceller;

        MultiRequestor(HttpClientListener httpClientListener, Iterable<? extends HttpUriRequest> iterable, HttpParams httpParams, Cancellable cancellable) {
            this.methods = iterable;
            this.listener = httpClientListener;
            this.params = httpParams;
            this.canceller = cancellable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (HttpUriRequest httpUriRequest : this.methods) {
                MultiRequestor multiRequestor = this;
                synchronized (multiRequestor) {
                    if (this.shutdown) {
                        return;
                    }
                    this.currentMethod = httpUriRequest;
                }
                if (this.canceller.isCancelled()) {
                    return;
                }
                if (!DefaultHttpExecutor.this.performRequest(httpUriRequest, this.params, this.listener)) continue;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            HttpUriRequest httpUriRequest;
            MultiRequestor multiRequestor = this;
            synchronized (multiRequestor) {
                this.shutdown = true;
                httpUriRequest = this.currentMethod;
            }
            if (httpUriRequest instanceof AbortableHttpRequest) {
                ((AbortableHttpRequest)httpUriRequest).abort();
            }
        }
    }

    private class Aborter
    implements Shutdownable {
        private final AbortableHttpRequest toAbort;

        Aborter(HttpUriRequest httpUriRequest) {
            this.toAbort = httpUriRequest instanceof AbortableHttpRequest ? (AbortableHttpRequest)httpUriRequest : null;
        }

        public void shutdown() {
            if (this.toAbort != null) {
                this.toAbort.abort();
            }
        }
    }
}

