/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeServices;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import java.util.Properties;
import org.limewire.io.IpPort;

public class UltrapeerHandshakeResponder
extends DefaultHandshakeResponder {
    private final HeadersFactory headersFactory;
    private final HandshakeServices handshakeServices;

    UltrapeerHandshakeResponder(String string, HeadersFactory headersFactory, HandshakeServices handshakeServices) {
        super(string);
        this.handshakeServices = handshakeServices;
        this.headersFactory = headersFactory;
    }

    protected HandshakeResponse respondToOutgoing(HandshakeResponse handshakeResponse) {
        HandshakeStatus handshakeStatus = this.handshakeServices.getHandshakeStatusForResponse(handshakeResponse);
        if (!handshakeStatus.isAcceptable()) {
            return HandshakeResponse.createRejectOutgoingResponse(handshakeStatus);
        }
        Properties properties = new Properties();
        if (handshakeResponse.hasLeafGuidance() && this.handshakeServices.isLeafDemotionAllowed() && handshakeResponse.isGoodUltrapeer()) {
            properties.put("X-Ultrapeer", "False");
        }
        if (handshakeResponse.isDeflateAccepted()) {
            properties.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(properties);
    }

    protected HandshakeResponse respondToIncoming(HandshakeResponse handshakeResponse) {
        if (handshakeResponse.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse(this.handshakeServices);
        }
        Properties properties = this.headersFactory.createUltrapeerHeaders(this.getRemoteIP());
        IpPort ipPort = this.handshakeServices.getLocalIpPort();
        properties.put("Listen-IP", ipPort.getAddress() + ":" + ipPort.getPort());
        HandshakeStatus handshakeStatus = this.reject(handshakeResponse, properties);
        if (!handshakeStatus.isAcceptable()) {
            return HandshakeResponse.createUltrapeerRejectIncomingResponse(handshakeResponse, handshakeStatus, this.handshakeServices);
        }
        if (handshakeResponse.isDeflateAccepted()) {
            properties.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(handshakeResponse, properties, this.handshakeServices);
    }

    private HandshakeStatus reject(HandshakeResponse handshakeResponse, Properties properties) {
        HandshakeStatus handshakeStatus = this.handshakeServices.getHandshakeStatusForResponseAsLeaf(handshakeResponse);
        boolean bl = handshakeStatus.isAcceptable();
        if (handshakeResponse.isLeaf()) {
            return handshakeStatus;
        }
        boolean bl2 = this.handshakeServices.isUltrapeerNeeded();
        if (bl && !bl2) {
            properties.put("X-Ultrapeer-Needed", Boolean.FALSE.toString());
            return HandshakeStatus.OK;
        }
        HandshakeStatus handshakeStatus2 = this.handshakeServices.getHandshakeStatusForResponse(handshakeResponse);
        boolean bl3 = handshakeStatus2.isAcceptable();
        if (bl3) {
            properties.put("X-Ultrapeer-Needed", Boolean.TRUE.toString());
            return handshakeStatus2;
        }
        if (!bl) {
            return handshakeStatus;
        }
        return handshakeStatus2;
    }
}

