/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.BlockingHandshakeSupport;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;

public class BlockingOutgoingHandshaker
implements Handshaker {
    private BlockingHandshakeSupport support;
    private Properties ourRequestHeaders;
    private HandshakeResponder ourResponder;

    public BlockingOutgoingHandshaker(Properties properties, HandshakeResponder handshakeResponder, Socket socket, InputStream inputStream, OutputStream outputStream) {
        this.support = new BlockingHandshakeSupport(socket, inputStream, outputStream);
        this.ourRequestHeaders = properties;
        this.ourResponder = handshakeResponder;
    }

    public HandshakeResponse getReadHeaders() {
        return this.support.getReadHandshakeResponse();
    }

    public HandshakeResponse getWrittenHeaders() {
        return this.support.getWrittenHandshakeResponse();
    }

    public void shake() throws IOException, BadHandshakeException, NoGnutellaOkException {
        this.initializeOutgoing();
        this.concludeOutgoingHandshake();
    }

    private void initializeOutgoing() throws IOException {
        this.support.writeConnectLine();
        this.support.sendHeaders(this.ourRequestHeaders);
    }

    private void concludeOutgoingHandshake() throws IOException {
        String string = this.support.readLine();
        if (!this.support.isConnectLineValid(string)) {
            throw new IOException("Bad connect string");
        }
        this.support.readHeaders(8000);
        HandshakeResponse handshakeResponse = this.support.createRemoteResponse(string);
        switch (handshakeResponse.getStatusCode()) {
            case 200: {
                break;
            }
            case 503: {
                throw NoGnutellaOkException.SERVER_REJECT;
            }
            default: {
                throw NoGnutellaOkException.createServerUnknown(handshakeResponse.getStatusCode());
            }
        }
        HandshakeResponse handshakeResponse2 = this.ourResponder.respond(handshakeResponse, true);
        this.support.writeResponse(handshakeResponse2);
        switch (handshakeResponse2.getStatusCode()) {
            case 200: {
                break;
            }
            case 503: {
                throw NoGnutellaOkException.CLIENT_REJECT;
            }
            case 577: {
                throw NoGnutellaOkException.CLIENT_REJECT_LOCALE;
            }
            default: {
                throw NoGnutellaOkException.createClientUnknown(handshakeResponse2.getStatusCode());
            }
        }
    }
}

