/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.GUIDPair;
import com.limegroup.gnutella.filters.QueryPair;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.QueryRequest;
import java.util.HashSet;
import java.util.Set;
import org.limewire.collection.Buffer;

public class DuplicateFilter
implements SpamFilter {
    private static final int BUF_SIZE = 20;
    private Buffer<GUIDPair> guids = new Buffer(20);
    static final int GUID_LAG = 500;
    private int guidLag = 500;
    private static final int TOLERANCE = 2;
    static final int QUERY_LAG = 1500;
    private int queryLag = 1500;
    private long querySwapTime = 0L;
    private long queryClearTime = this.queryLag;
    private Set<QueryPair> youngQueries = new HashSet<QueryPair>();
    private Set<QueryPair> oldQueries = new HashSet<QueryPair>();

    private static long getTime() {
        return System.currentTimeMillis();
    }

    public boolean allow(Message message) {
        if (!this.allowGUID(message)) {
            return false;
        }
        if (message instanceof QueryRequest) {
            return this.allowQuery((QueryRequest)message);
        }
        return true;
    }

    public boolean allowGUID(Message message) {
        if (!(message instanceof QueryRequest) && !(message instanceof PingRequest)) {
            return true;
        }
        GUIDPair gUIDPair = new GUIDPair(message.getGUID(), DuplicateFilter.getTime(), message.getHops());
        int n = this.guids.getSize();
        for (int i = 0; i < n; ++i) {
            GUIDPair gUIDPair2 = this.guids.get(i);
            if (gUIDPair.time - gUIDPair2.time > (long)this.guidLag) break;
            if (gUIDPair2.hops != gUIDPair.hops) continue;
            int n2 = 0;
            for (int j = 0; j < gUIDPair.guid.length && n2 <= 2; ++j) {
                if (gUIDPair.guid[j] == gUIDPair2.guid[j]) continue;
                ++n2;
            }
            if (n2 > 2) continue;
            this.guids.add(gUIDPair);
            return false;
        }
        this.guids.add(gUIDPair);
        return true;
    }

    public boolean allowQuery(QueryRequest queryRequest) {
        Object object;
        long l = DuplicateFilter.getTime();
        if (l > this.querySwapTime) {
            if (l <= this.queryClearTime) {
                object = this.oldQueries;
                this.oldQueries = this.youngQueries;
                this.youngQueries = object;
                this.youngQueries.clear();
            } else {
                this.youngQueries.clear();
                this.oldQueries.clear();
            }
            this.querySwapTime = l + (long)this.queryLag;
            this.queryClearTime = this.querySwapTime + (long)this.queryLag;
        }
        if (this.oldQueries.contains(object = new QueryPair(queryRequest.getQuery(), queryRequest.getHops(), queryRequest.getRichQuery(), queryRequest.getQueryUrns(), queryRequest.getMetaMask()))) {
            return false;
        }
        boolean bl = this.youngQueries.add((QueryPair)object);
        return bl;
    }

    void setQueryLag(int n) {
        this.queryLag = n;
    }

    int getQueryLag() {
        return this.queryLag;
    }

    void setGUIDLag(int n) {
        this.guidLag = n;
    }

    int getGUIDLag() {
        return this.guidLag;
    }
}

