/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IP;
import org.limewire.mojito.messages.DHTMessage;

abstract class AbstractIPFilter
implements IPFilter {
    private static final Log LOG = LogFactory.getLog(AbstractIPFilter.class);
    private static final IP ALLOWED = new IP(new byte[4]);

    AbstractIPFilter() {
    }

    protected IP extractAddress(Message message) {
        if (message instanceof PingReply) {
            PingReply pingReply = (PingReply)message;
            return this.getIP(pingReply.getAddress());
        }
        if (message instanceof QueryReply) {
            QueryReply queryReply = (QueryReply)message;
            return this.getIP(queryReply.getIPBytes());
        }
        if (message instanceof PushRequest) {
            PushRequest pushRequest = (PushRequest)message;
            return this.getIP(pushRequest.getIP());
        }
        if (message instanceof QueryRequest) {
            QueryRequest queryRequest = (QueryRequest)message;
            if (queryRequest.desiresOutOfBandReplies()) {
                return this.getIP(queryRequest.getGUID());
            }
            return ALLOWED;
        }
        if (message instanceof DHTMessage) {
            DHTMessage dHTMessage = (DHTMessage)((Object)message);
            InetSocketAddress inetSocketAddress = (InetSocketAddress)dHTMessage.getContact().getContactAddress();
            if (inetSocketAddress != null && inetSocketAddress.getAddress() instanceof Inet4Address) {
                return this.getIP(inetSocketAddress.getAddress().getAddress());
            }
            return ALLOWED;
        }
        return ALLOWED;
    }

    private IP getIP(byte[] byArray) {
        IP iP = null;
        try {
            iP = new IP(byArray, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return iP;
    }

    private IP getIP(String string) {
        IP iP = null;
        try {
            iP = new IP(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("doing dns lookup for " + string));
                }
                InetAddress inetAddress = InetAddress.getByName(string);
                string = inetAddress.getHostAddress();
                iP = new IP(string);
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                // empty catch block
            }
        }
        return iP;
    }

    public boolean allow(Message message) {
        return this.allow(this.extractAddress(message));
    }

    public boolean allow(SocketAddress socketAddress) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            return false;
        }
        return this.allow(((InetSocketAddress)socketAddress).getAddress().getAddress());
    }

    public boolean allow(byte[] byArray) {
        return this.allow(this.getIP(byArray));
    }

    public boolean allow(String string) {
        return this.allow(this.getIP(string));
    }

    public boolean allow(IP iP) {
        return this.allowAndLog(iP);
    }

    private boolean allowAndLog(IP iP) {
        if (iP == ALLOWED) {
            LOG.debug((Object)"allowing non-checkable ip.");
            return true;
        }
        if (iP == null) {
            LOG.debug((Object)"not allowing invalid ip");
            return false;
        }
        boolean bl = this.allowImpl(iP);
        if (bl && LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.hashCode() + " allowing " + iP));
        } else if (!bl && LOG.isInfoEnabled()) {
            LOG.info((Object)(this.hashCode() + " NOT allowing " + iP));
        }
        return bl;
    }

    protected abstract boolean allowImpl(IP var1);
}

