/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial.conversion;

import com.limegroup.gnutella.downloader.serial.conversion.SerialIncompleteFileManager;
import com.limegroup.gnutella.downloader.serial.conversion.SerialManagedDownloader;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRemoteFileDesc;
import com.limegroup.gnutella.downloader.serial.conversion.SerialRoot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerialManagedDownloaderImpl
extends SerialRoot
implements SerialManagedDownloader {
    private static final long serialVersionUID = 2772570805975885257L;
    private transient SerialRemoteFileDesc defaultRFD;
    private transient Set<SerialRemoteFileDesc> remoteFileDescs;
    private transient SerialIncompleteFileManager incompleteFileManager;
    private transient Map<String, Serializable> properties;

    protected SerialManagedDownloaderImpl() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        Object object2 = objectInputStream.readObject();
        if (object2 instanceof SerialRemoteFileDesc[]) {
            object = (SerialRemoteFileDesc[])object2;
            if (((SerialRemoteFileDesc[])object).length > 0) {
                this.defaultRFD = object[0];
            }
            this.remoteFileDescs = new HashSet<SerialRemoteFileDesc>(Arrays.asList(object));
        } else if (object2 instanceof Set) {
            this.remoteFileDescs = GenericsUtils.scanForSet(object2, SerialRemoteFileDesc.class, GenericsUtils.ScanMode.REMOVE);
            if (this.remoteFileDescs.size() > 0) {
                this.defaultRFD = this.remoteFileDescs.iterator().next();
            }
        }
        this.incompleteFileManager = (SerialIncompleteFileManager)objectInputStream.readObject();
        object = objectInputStream.readObject();
        this.properties = object instanceof Map ? GenericsUtils.scanForMap(object, String.class, Serializable.class, GenericsUtils.ScanMode.REMOVE) : new HashMap<String, Serializable>();
    }

    @Override
    public SerialRemoteFileDesc getDefaultRFD() {
        return this.defaultRFD;
    }

    @Override
    public Set<SerialRemoteFileDesc> getRemoteFileDescs() {
        return this.remoteFileDescs;
    }

    @Override
    public SerialIncompleteFileManager getIncompleteFileManager() {
        return this.incompleteFileManager;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }
}

