/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial.conversion;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializeSettings;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import com.limegroup.gnutella.downloader.serial.OldDownloadConverter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadUpgradeTask {
    private static final Log LOG = LogFactory.getLog(DownloadUpgradeTask.class);
    private final OldDownloadConverter oldDownloadConverter;
    private final DownloadSerializeSettings oldDownloadSettings;
    private final DownloadSerializeSettings newSettings;
    private final DownloadSerializer downloadSerializer;

    @Inject
    public DownloadUpgradeTask(OldDownloadConverter oldDownloadConverter, @Named(value="oldDownloadSettings") DownloadSerializeSettings downloadSerializeSettings, DownloadSerializeSettings downloadSerializeSettings2, DownloadSerializer downloadSerializer) {
        this.oldDownloadConverter = oldDownloadConverter;
        this.oldDownloadSettings = downloadSerializeSettings;
        this.newSettings = downloadSerializeSettings2;
        this.downloadSerializer = downloadSerializer;
    }

    public void upgrade() {
        File file = this.newSettings.getBackupFile();
        File file2 = this.newSettings.getSaveFile();
        if (!file.exists() && !file2.exists()) {
            try {
                List<DownloadMemento> list = this.readAndConvertOldFormat();
                if (this.downloadSerializer.writeToDisk(list)) {
                    this.oldDownloadSettings.getSaveFile().delete();
                    this.oldDownloadSettings.getBackupFile().delete();
                }
            }
            catch (IOException iOException) {
                LOG.warn((Object)"Unable to read old file or write to backup!", (Throwable)iOException);
            }
        }
    }

    private List<DownloadMemento> readAndConvertOldFormat() throws IOException {
        try {
            return this.oldDownloadConverter.readAndConvertOldDownloads(this.oldDownloadSettings.getSaveFile());
        }
        catch (Throwable throwable) {
            LOG.warn((Object)"Error trying to convert old normal file.", throwable);
            try {
                return this.oldDownloadConverter.readAndConvertOldDownloads(this.oldDownloadSettings.getBackupFile());
            }
            catch (Throwable throwable2) {
                LOG.warn((Object)"Error trying to convert old normal file.", throwable2);
                throw new IOException("Unable to read old files!");
            }
        }
    }
}

