/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.DownloadSerializeSettings;
import com.limegroup.gnutella.downloader.serial.DownloadSerializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DownloadSerializerImpl
implements DownloadSerializer {
    private static final Log LOG = LogFactory.getLog(DownloadSerializerImpl.class);
    private final DownloadSerializeSettings downloadSerializeSettings;

    @Inject
    public DownloadSerializerImpl(DownloadSerializeSettings downloadSerializeSettings) {
        this.downloadSerializeSettings = downloadSerializeSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadMemento> readFromDisk() throws IOException {
        Throwable throwable;
        List<DownloadMemento> list;
        if (!this.downloadSerializeSettings.getSaveFile().exists() && !this.downloadSerializeSettings.getSaveFile().exists()) {
            return Collections.emptyList();
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.downloadSerializeSettings.getSaveFile())));
            list = GenericsUtils.scanForList(objectInputStream.readObject(), DownloadMemento.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                LOG.warn((Object)"Error reading normal file.", throwable2);
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                IOUtils.close(objectInputStream);
            }
        }
        IOUtils.close(objectInputStream);
        return list;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.downloadSerializeSettings.getBackupFile())));
            List<DownloadMemento> list2 = GenericsUtils.scanForList(objectInputStream.readObject(), DownloadMemento.class, GenericsUtils.ScanMode.REMOVE);
            return list2;
        }
        catch (Throwable throwable4) {
            LOG.warn((Object)"Error reading normal file.", throwable4);
        }
        finally {
            IOUtils.close(objectInputStream);
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw (IOException)new IOException().initCause(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeToDisk(List<? extends DownloadMemento> list) {
        File file = this.downloadSerializeSettings.getBackupFile();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            objectOutputStream.writeObject(list);
        }
        catch (IOException iOException) {
            boolean bl;
            try {
                LOG.warn((Object)"Unable to write to backup file!", (Throwable)iOException);
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.close(objectOutputStream);
                throw throwable;
            }
            IOUtils.close(objectOutputStream);
            return bl;
        }
        IOUtils.close(objectOutputStream);
        File file2 = this.downloadSerializeSettings.getSaveFile();
        if (file2.equals(file)) {
            LOG.debug((Object)"backup == save, nothing more to do");
            return true;
        }
        File file3 = file2.getParentFile();
        File file4 = null;
        try {
            file4 = FileUtils.createTempFile("lwc", "tmp", file3);
        }
        catch (IOException iOException) {
            LOG.warn((Object)"Error creating temp file", (Throwable)iOException);
        }
        if (file4 != null) {
            file4.delete();
            if (!file2.renameTo(file4)) {
                LOG.debug((Object)"Unable to rename save to temp, deleting instead!");
                file2.delete();
            }
        } else {
            file2.delete();
        }
        boolean bl = file.renameTo(this.downloadSerializeSettings.getSaveFile());
        if (file4 != null) {
            if (!bl) {
                file4.renameTo(file2);
            }
            file4.delete();
        }
        return bl;
    }
}

