/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Provider;
import com.limegroup.gnutella.downloader.ChunkDiskJob;
import com.limegroup.gnutella.downloader.DelayedWrite;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.SelectionStrategy;
import com.limegroup.gnutella.downloader.SelectionStrategyFactory;
import com.limegroup.gnutella.tigertree.HashTree;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.MultiIterable;
import org.limewire.collection.Range;
import org.limewire.io.DiskException;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyingFile {
    static final Log LOG = LogFactory.getLog(VerifyingFile.class);
    static final float MAX_CORRUPTION = 0.9f;
    static final int DEFAULT_CHUNK_SIZE = 131072;
    private static final int VERIFYABLE_CHUNK = 65536;
    private volatile RandomAccessFile fos;
    private volatile boolean isOpen;
    private final long completedSize;
    private long lostSize;
    private final IntervalSet verifiedBlocks;
    private IntervalSet leasedBlocks;
    private IntervalSet partialBlocks;
    private IntervalSet savedCorruptBlocks;
    private IntervalSet pendingBlocks;
    private SelectionStrategy blockChooser = null;
    private HashTree hashTree;
    private String expectedHashRoot;
    private boolean hashTreeRequested;
    private boolean discardBad = true;
    private IOException storedException;
    private long existingFileSize = -1L;
    private int chunksScheduledPerFile = 0;
    private MultiIterable<Range> allBlocksIterable = null;
    private final Provider<DiskController> diskController;

    VerifyingFile(long l, Provider<DiskController> provider) {
        this.completedSize = l;
        this.verifiedBlocks = new IntervalSet();
        this.leasedBlocks = new IntervalSet();
        this.pendingBlocks = new IntervalSet();
        this.partialBlocks = new IntervalSet();
        this.savedCorruptBlocks = new IntervalSet();
        this.diskController = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file) throws IOException {
        if (this.completedSize == -1L) {
            throw new IllegalStateException("cannot open for unknown size.");
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
            if (!file2.exists()) {
                throw new IOException("permission denied");
            }
            FileUtils.setWriteable(file2);
        }
        FileUtils.setWriteable(file);
        this.fos = new RandomAccessFile(file, "rw");
        SelectionStrategy selectionStrategy = SelectionStrategyFactory.getStrategyFor(FileUtils.getFileExtension(file), this.completedSize);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            this.storedException = null;
            this.blockChooser = selectionStrategy;
            this.isOpen = true;
        }
    }

    public synchronized void addInterval(Range range) {
        this.partialBlocks.add(range);
    }

    public void registerWriteCallback(WriteRequest writeRequest, WriteCallback writeCallback) {
        writeRequest.startScheduling();
        if (this.writeBlockImpl(writeRequest)) {
            writeCallback.writeScheduled();
        } else {
            ((DiskController)this.diskController.get()).addDelayedWrite(new VerifyingFileDelayedWrite(writeRequest, writeCallback, this));
        }
    }

    public boolean writeBlock(WriteRequest writeRequest) {
        if (!this.validateState(writeRequest)) {
            return true;
        }
        writeRequest.startProcessing();
        this.updateState(writeRequest.in);
        boolean bl = ((DiskController)this.diskController.get()).canWriteNow();
        if (bl) {
            return this.writeBlockImpl(writeRequest);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeBlockImpl(WriteRequest writeRequest) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("trying to write block at offset " + writeRequest.currPos + " with size " + writeRequest.length));
        }
        if (!this.validateState(writeRequest)) {
            return true;
        }
        byte[] byArray = ((DiskController)this.diskController.get()).getWriteChunk();
        if (byArray == null) {
            return false;
        }
        writeRequest.setDone();
        assert (byArray.length >= writeRequest.length) : "bad length: " + writeRequest.length + ", needed <= " + byArray.length;
        System.arraycopy(writeRequest.buf, writeRequest.start, byArray, 0, writeRequest.length);
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            ++this.chunksScheduledPerFile;
        }
        ((DiskController)this.diskController.get()).addDiskJob(new ChunkHandler(byArray, writeRequest.in));
        return true;
    }

    private synchronized void updateState(Range range) {
        assert (this.leasedBlocks.contains(range)) : "trying to write an interval " + range + " that wasn't leased.\n" + this.dumpState();
        assert (!(this.partialBlocks.contains(range) || this.savedCorruptBlocks.contains(range) || this.pendingBlocks.contains(range))) : "trying to write an interval " + range + " that was already written" + this.dumpState();
        this.leasedBlocks.delete(range);
        if (this.verifiedBlocks.containsAny(range)) {
            IntervalSet intervalSet = new IntervalSet();
            intervalSet.add(range);
            intervalSet.delete(this.verifiedBlocks);
            this.pendingBlocks.add(intervalSet);
        } else {
            this.pendingBlocks.add(range);
        }
    }

    private boolean validateState(WriteRequest writeRequest) {
        if (writeRequest.length == 0) {
            return false;
        }
        if (this.fos == null) {
            throw new IllegalStateException("no fos!");
        }
        return this.isOpen();
    }

    public void setScanForExistingBlocks(boolean bl, long l) throws IOException {
        if (bl && l != 0L) {
            if (l > this.completedSize) {
                throw new IOException("invalid completed size or length");
            }
            this.existingFileSize = l;
        } else {
            this.existingFileSize = -1L;
        }
    }

    public synchronized String dumpState() {
        return "verified:" + this.verifiedBlocks + "\npartial:" + this.partialBlocks + "\ndiscarded:" + this.savedCorruptBlocks + "\npending:" + this.pendingBlocks + "\nleased:" + this.leasedBlocks;
    }

    public Range leaseWhite() throws NoSuchElementException {
        return this.leaseWhiteHelper(null, this.completedSize);
    }

    public Range leaseWhite(long l) throws NoSuchElementException {
        return this.leaseWhiteHelper(null, l);
    }

    public Range leaseWhite(IntervalSet intervalSet) throws NoSuchElementException {
        return this.leaseWhiteHelper(intervalSet, 131072L);
    }

    public Range leaseWhite(IntervalSet intervalSet, long l) throws NoSuchElementException {
        return this.leaseWhiteHelper(intervalSet, l);
    }

    public synchronized void releaseBlock(Range range) {
        assert (this.leasedBlocks.contains(range)) : "trying to release an interval " + range + " that wasn't leased " + this.dumpState();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Releasing interval: " + range + " state " + this.dumpState()));
        }
        this.leasedBlocks.delete(range);
    }

    public synchronized Iterable<Range> getVerifiedBlocks() {
        return this.verifiedBlocks;
    }

    public synchronized IntervalSet getVerifiedIntervalSet() {
        return this.verifiedBlocks;
    }

    public synchronized IntervalSet getPartialIntervalSet() {
        return this.partialBlocks;
    }

    public synchronized IntervalSet.ByteIntervals toBytes() {
        return this.verifiedBlocks.toBytes();
    }

    public String toString() {
        return this.dumpState();
    }

    public synchronized List<Range> getSerializableBlocks() {
        IntervalSet intervalSet = new IntervalSet();
        for (Range range : new MultiIterable<Range>(this.verifiedBlocks, this.partialBlocks, this.savedCorruptBlocks)) {
            intervalSet.add(range);
        }
        return intervalSet.getAllIntervalsAsList();
    }

    public synchronized Iterable<Range> getBlocks() {
        if (this.allBlocksIterable == null) {
            this.allBlocksIterable = new MultiIterable<Range>(this.verifiedBlocks, this.partialBlocks, this.savedCorruptBlocks, this.pendingBlocks);
        }
        return this.allBlocksIterable;
    }

    public synchronized long getOffsetForPreview() {
        if (!this.savedCorruptBlocks.isEmpty()) {
            IntervalSet intervalSet = new IntervalSet();
            intervalSet.add(this.savedCorruptBlocks);
            intervalSet.add(this.verifiedBlocks);
            intervalSet.add(this.partialBlocks);
            if (intervalSet.getFirst().getLow() != 0L) {
                return 0L;
            }
            return intervalSet.getFirst().getHigh();
        }
        IntervalSet intervalSet = new IntervalSet();
        if (!this.verifiedBlocks.isEmpty()) {
            intervalSet.add(this.verifiedBlocks.getFirst());
        }
        if (!this.partialBlocks.isEmpty()) {
            intervalSet.add(this.partialBlocks.getFirst());
        }
        if (intervalSet.isEmpty() || intervalSet.getFirst().getLow() != 0L) {
            return 0L;
        }
        return intervalSet.getFirst().getHigh();
    }

    public synchronized List<Range> getVerifiedBlocksAsList() {
        return this.verifiedBlocks.getAllIntervalsAsList();
    }

    public synchronized long getBlockSize() {
        return this.verifiedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize();
    }

    public synchronized long getPendingSize() {
        return this.pendingBlocks.getSize();
    }

    public synchronized long getVerifiedBlockSize() {
        return this.verifiedBlocks.getSize();
    }

    public synchronized long getAmountLost() {
        return this.lostSize;
    }

    public synchronized boolean isComplete() {
        if (this.hashTree != null) {
            return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() == this.completedSize;
        }
        return this.verifiedBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.partialBlocks.getSize() == this.completedSize;
    }

    public synchronized String listMissingPieces() {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(Range.createRange(0L, this.completedSize - 1L));
        intervalSet.delete(this.verifiedBlocks);
        intervalSet.delete(this.savedCorruptBlocks);
        if (this.hashTree == null) {
            intervalSet.delete(this.partialBlocks);
        }
        return intervalSet.toString() + ", pending: " + this.pendingBlocks.toString() + ", has tree? " + (this.hashTree != null) + ", verified: " + this.verifiedBlocks + ", savedCorrupt: " + this.savedCorruptBlocks + ", partial: " + this.partialBlocks;
    }

    public synchronized void waitForPendingIfNeeded() throws InterruptedException, DiskException {
        if (this.storedException != null) {
            throw new DiskException(this.storedException);
        }
        while (!this.isComplete() && this.getBlockSize() == this.completedSize) {
            if (this.storedException != null) {
                throw new DiskException(this.storedException);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"waiting for a pending chunk to verify or write..");
            }
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitForPending(int n) throws InterruptedException, DiskException {
        if (this.storedException != null) {
            throw new DiskException(this.storedException);
        }
        VerifyingFile verifyingFile = this;
        synchronized (verifyingFile) {
            while (this.chunksScheduledPerFile > 0) {
                this.wait(n);
            }
        }
    }

    public synchronized boolean isHopeless() {
        return (float)this.lostSize >= 0.9f * (float)this.completedSize;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public synchronized long hasFreeBlocksToAssign() {
        return this.completedSize - (this.verifiedBlocks.getSize() + this.leasedBlocks.getSize() + this.partialBlocks.getSize() + this.savedCorruptBlocks.getSize() + this.pendingBlocks.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isOpen = false;
        if (this.fos == null) {
            return;
        }
        try {
            VerifyingFile verifyingFile = this;
            synchronized (verifyingFile) {
                while (this.chunksScheduledPerFile > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized Range leaseWhiteHelper(IntervalSet intervalSet, long l) throws NoSuchElementException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("leasing white, state:\n" + this.dumpState()));
        }
        if (intervalSet == null) {
            intervalSet = IntervalSet.createSingletonSet(0L, this.completedSize - 1L);
        }
        IntervalSet intervalSet2 = IntervalSet.createSingletonSet(0L, this.completedSize - 1L);
        intervalSet2.delete(this.verifiedBlocks);
        intervalSet2.delete(this.leasedBlocks);
        intervalSet2.delete(this.partialBlocks);
        intervalSet2.delete(this.savedCorruptBlocks);
        intervalSet2.delete(this.pendingBlocks);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("needed bytes: " + intervalSet2));
        }
        intervalSet.delete(intervalSet2.invert(this.completedSize));
        Range range = this.blockChooser.pickAssignment(intervalSet, intervalSet2, l);
        this.leaseBlock(range);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("leasing white interval " + range + "\nof available intervals " + intervalSet2));
        }
        return range;
    }

    private synchronized void leaseBlock(Range range) {
        this.leasedBlocks.add(range);
    }

    public synchronized void setExpectedHashTreeRoot(String string) {
        this.expectedHashRoot = string;
    }

    public synchronized HashTree getHashTree() {
        return this.hashTree;
    }

    public synchronized boolean setHashTree(HashTree hashTree) {
        if (this.expectedHashRoot != null && hashTree != null && !hashTree.getRootHash().equalsIgnoreCase(this.expectedHashRoot)) {
            return false;
        }
        if (hashTree != null && hashTree.getFileSize() != this.completedSize) {
            return false;
        }
        HashTree hashTree2 = this.hashTree;
        if (hashTree2 != null && hashTree != null && !hashTree2.getRootHash().equals(hashTree.getRootHash())) {
            if (this.verifiedBlocks.getSize() > 262144L) {
                return false;
            }
            if (this.verifiedBlocks.getSize() > 0L) {
                this.partialBlocks.add(this.verifiedBlocks);
                this.verifiedBlocks.clear();
                ((DiskController)this.diskController.get()).addDiskJobWithoutChunk(new EmptyVerifier(this.existingFileSize));
            }
        }
        this.hashTree = hashTree;
        if (hashTree2 == null && hashTree != null && (this.existingFileSize != -1L || this.pendingBlocks.getSize() == 0L && this.partialBlocks.getSize() > 0L)) {
            ((DiskController)this.diskController.get()).addDiskJobWithoutChunk(new EmptyVerifier(this.existingFileSize));
            this.existingFileSize = -1L;
        }
        return true;
    }

    public synchronized void setHashTreeRequested(boolean bl) {
        this.hashTreeRequested = bl;
    }

    public synchronized boolean isHashTreeRequested() {
        return this.hashTreeRequested;
    }

    public synchronized void setDiscardUnverified(boolean bl) {
        this.discardBad = bl;
    }

    public synchronized int getChunkSize() {
        return this.hashTree == null ? 131072 : this.hashTree.getNodeSize();
    }

    private void verifyChunks() {
        this.verifyChunks(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyChunks(long l) {
        boolean bl = l != -1L;
        HashTree hashTree = this.getHashTree();
        if (hashTree != null) {
            for (Range range : this.findVerifyableBlocks(l)) {
                byte[] byArray;
                boolean bl2 = !hashTree.isCorrupt(range, this.fos, byArray = ((DiskController)this.diskController.get()).getPowerOf2Chunk(Math.min(65536, hashTree.getNodeSize())));
                VerifyingFile verifyingFile = this;
                synchronized (verifyingFile) {
                    this.partialBlocks.delete(range);
                    if (bl2) {
                        this.verifiedBlocks.add(range);
                    } else if (!bl) {
                        if (!this.discardBad) {
                            this.savedCorruptBlocks.add(range);
                        }
                        this.lostSize += range.getHigh() - range.getLow() + 1L;
                    }
                }
            }
        }
    }

    private synchronized List<Range> findVerifyableBlocks(long l) {
        List<Range> list;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("trying to find verifyable blocks out of " + this.partialBlocks));
        }
        boolean bl = l != -1L;
        ArrayList<Range> arrayList = new ArrayList<Range>(2);
        int n = this.getChunkSize();
        if (bl) {
            IntervalSet intervalSet = this.partialBlocks.clone();
            intervalSet.add(Range.createRange(0L, l));
            list = intervalSet.getAllIntervalsAsList();
        } else {
            list = this.partialBlocks.getAllIntervalsAsList();
        }
        for (int i = 0; i < list.size(); ++i) {
            Range range = list.get(i);
            long l2 = range.getLow() - range.getLow() % (long)n;
            if (range.getLow() % (long)n != 0L) {
                l2 += (long)n;
            }
            while (range.getHigh() >= l2 + (long)n - 1L) {
                Range range2 = Range.createRange(l2, l2 + (long)n - 1L);
                arrayList.add(range2);
                l2 += (long)n;
            }
        }
        if (!list.isEmpty()) {
            Range range;
            long l3 = this.completedSize - this.completedSize % (long)n;
            if (l3 == this.completedSize) {
                l3 -= (long)n;
            }
            if ((range = list.get(list.size() - 1)).getHigh() == this.completedSize - 1L && range.getLow() <= l3) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"adding the last chunk for verification");
                }
                arrayList.add(Range.createRange(l3, range.getHigh()));
            }
        }
        return arrayList;
    }

    public static class WriteRequest {
        public final long currPos;
        public final int start;
        public final int length;
        public final byte[] buf;
        public final Range in;
        private boolean processed;
        private boolean done;
        private boolean scheduled;

        WriteRequest(long l, int n, int n2, byte[] byArray) {
            this.currPos = l;
            this.start = n;
            this.length = n2;
            this.buf = byArray;
            this.in = Range.createRange(l, l + (long)n2 - 1L);
        }

        private synchronized void startProcessing() {
            if (this.isInvalidForWriting()) {
                throw new IllegalStateException("invalid request state");
            }
            this.processed = true;
        }

        private synchronized void startScheduling() {
            if (this.isInvalidForCallback()) {
                throw new IllegalStateException("invalid request state");
            }
            this.scheduled = true;
        }

        private synchronized void setDone() {
            if (this.done) {
                throw new IllegalStateException("invalid request state");
            }
            this.done = true;
        }

        public synchronized boolean isInvalidForCallback() {
            return !this.processed || this.done || this.scheduled;
        }

        public synchronized boolean isInvalidForWriting() {
            return this.done || this.processed;
        }
    }

    private static class VerifyingFileDelayedWrite
    implements DelayedWrite {
        private final WriteRequest request;
        private final WriteCallback callback;
        private final VerifyingFile vf;

        VerifyingFileDelayedWrite(WriteRequest writeRequest, WriteCallback writeCallback, VerifyingFile verifyingFile) {
            this.request = writeRequest;
            this.callback = writeCallback;
            this.vf = verifyingFile;
        }

        public boolean write() {
            if (this.vf.writeBlockImpl(this.request)) {
                this.callback.writeScheduled();
                return true;
            }
            return false;
        }
    }

    static interface WriteCallback {
        public void writeScheduled();
    }

    private class EmptyVerifier
    implements Runnable {
        private final long existingFileSize;

        EmptyVerifier(long l) {
            this.existingFileSize = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            VerifyingFile.this.verifyChunks(this.existingFileSize);
            VerifyingFile verifyingFile = VerifyingFile.this;
            synchronized (verifyingFile) {
                VerifyingFile.this.notify();
            }
        }
    }

    private class ChunkHandler
    extends ChunkDiskJob {
        private final Range intvl;
        private boolean freedPending;

        public ChunkHandler(byte[] byArray, Range range) {
            super(byArray);
            this.freedPending = false;
            this.intvl = range;
            long l = range.getHigh() - range.getLow() + 1L;
            assert (l <= (long)byArray.length) : "invalid length " + l + " vs buf " + byArray.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runChunkJob(byte[] byArray) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Writing intvl: " + this.intvl));
                }
                Object object = VerifyingFile.this.fos;
                synchronized (object) {
                    VerifyingFile.this.fos.seek(this.intvl.getLow());
                    VerifyingFile.this.fos.write(byArray, 0, (int)(this.intvl.getHigh() - this.intvl.getLow() + 1L));
                }
                object = VerifyingFile.this;
                synchronized (object) {
                    VerifyingFile.this.pendingBlocks.delete(this.intvl);
                    VerifyingFile.this.partialBlocks.add(this.intvl);
                    this.freedPending = true;
                }
                VerifyingFile.this.verifyChunks();
            }
            catch (IOException iOException) {
                VerifyingFile verifyingFile = VerifyingFile.this;
                synchronized (verifyingFile) {
                    VerifyingFile.this.pendingBlocks.delete(this.intvl);
                    VerifyingFile.this.storedException = iOException;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            VerifyingFile verifyingFile = VerifyingFile.this;
            synchronized (verifyingFile) {
                try {
                    if (!this.freedPending) {
                        VerifyingFile.this.pendingBlocks.delete(this.intvl);
                    }
                }
                finally {
                    --VerifyingFile.this.chunksScheduledPerFile;
                    VerifyingFile.this.notifyAll();
                }
            }
        }
    }
}

