/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.PingRanker;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.settings.DownloadSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SourceRankerFactory {
    private final NetworkManager networkManager;
    private final Provider<UDPPinger> udpPingerFactory;
    private final Provider<MessageRouter> messageRouter;
    private final RemoteFileDescFactory remoteFileDescFactory;

    @Inject
    public SourceRankerFactory(NetworkManager networkManager, Provider<UDPPinger> provider, Provider<MessageRouter> provider2, RemoteFileDescFactory remoteFileDescFactory) {
        this.networkManager = networkManager;
        this.udpPingerFactory = provider;
        this.messageRouter = provider2;
        this.remoteFileDescFactory = remoteFileDescFactory;
    }

    public SourceRanker getAppropriateRanker() {
        if (this.networkManager.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            return new PingRanker(this.networkManager, (UDPPinger)this.udpPingerFactory.get(), (MessageRouter)this.messageRouter.get(), this.remoteFileDescFactory);
        }
        return new LegacyRanker();
    }

    public SourceRanker getAppropriateRanker(SourceRanker sourceRanker) {
        AbstractSourceRanker abstractSourceRanker;
        if (sourceRanker == null) {
            return this.getAppropriateRanker();
        }
        if (this.networkManager.canReceiveSolicited() && DownloadSettings.USE_HEADPINGS.getValue()) {
            if (sourceRanker instanceof PingRanker) {
                return sourceRanker;
            }
            abstractSourceRanker = new PingRanker(this.networkManager, (UDPPinger)this.udpPingerFactory.get(), (MessageRouter)this.messageRouter.get(), this.remoteFileDescFactory);
        } else {
            if (sourceRanker instanceof LegacyRanker) {
                return sourceRanker;
            }
            abstractSourceRanker = new LegacyRanker();
        }
        abstractSourceRanker.setMeshHandler(sourceRanker.getMeshHandler());
        abstractSourceRanker.addToPool(sourceRanker.getShareableHosts());
        sourceRanker.stop();
        return abstractSourceRanker;
    }
}

