/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RemoteFileDescImpl;
import com.limegroup.gnutella.downloader.UrlRemoteFileDescImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.io.Connectable;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class RemoteFileDescFactoryImpl
implements RemoteFileDescFactory {
    private static final int COPY_INDEX = Integer.MAX_VALUE;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final PushEndpointFactory pushEndpointFactory;
    private final Provider<LimeHttpClient> httpClientProvider;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public RemoteFileDescFactoryImpl(LimeXMLDocumentFactory limeXMLDocumentFactory, PushEndpointFactory pushEndpointFactory, Provider<LimeHttpClient> provider, NetworkInstanceUtils networkInstanceUtils) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.pushEndpointFactory = pushEndpointFactory;
        this.httpClientProvider = provider;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(RemoteFileDesc remoteFileDesc, IpPort ipPort) {
        return this.createRemoteFileDesc(ipPort.getAddress(), ipPort.getPort(), Integer.MAX_VALUE, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), remoteFileDesc.getClientGUID(), 0, false, 2, false, remoteFileDesc.getXMLDocument(), remoteFileDesc.getUrns(), false, false, "ALT", IpPort.EMPTY_SET, remoteFileDesc.getCreationTime(), 0, null, ipPort instanceof Connectable ? ((Connectable)ipPort).isTLSCapable() : false);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(RemoteFileDesc remoteFileDesc, PushEndpoint pushEndpoint) {
        return this.createRemoteFileDesc(pushEndpoint.getAddress(), pushEndpoint.getPort(), Integer.MAX_VALUE, remoteFileDesc.getFileName(), remoteFileDesc.getSize(), DataUtils.EMPTY_GUID, remoteFileDesc.getSpeed(), false, remoteFileDesc.getQuality(), false, remoteFileDesc.getXMLDocument(), remoteFileDesc.getUrns(), false, true, "ALT", null, remoteFileDesc.getCreationTime(), 0, pushEndpoint, false);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(String string, int n, long l, String string2, long l2, byte[] byArray, int n2, boolean bl, int n3, boolean bl2, LimeXMLDocument limeXMLDocument, Set<? extends URN> set, boolean bl3, boolean bl4, String string3, Set<? extends IpPort> set2, long l3, boolean bl5) {
        return this.createRemoteFileDesc(string, n, l, string2, l2, byArray, n2, bl, n3, bl2, limeXMLDocument, set, bl3, bl4, string3, set2, l3, 0, null, bl5);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(String string, int n, long l, String string2, long l2, byte[] byArray, int n2, boolean bl, int n3, boolean bl2, LimeXMLDocument limeXMLDocument, Set<? extends URN> set, boolean bl3, boolean bl4, String string3, Set<? extends IpPort> set2, long l3, int n4, boolean bl5) {
        return this.createRemoteFileDesc(string, n, l, string2, l2, byArray, n2, bl, n3, bl2, limeXMLDocument, set, bl3, bl4, string3, set2, l3, n4, null, bl5);
    }

    @Override
    public RemoteFileDesc createRemoteFileDesc(String string, int n, long l, String string2, long l2, int n2, boolean bl, int n3, boolean bl2, LimeXMLDocument limeXMLDocument, Set<? extends URN> set, boolean bl3, boolean bl4, String string3, long l3, PushEndpoint pushEndpoint) {
        return this.createRemoteFileDesc(string, n, l, string2, l2, null, n2, bl, n3, bl2, limeXMLDocument, set, bl3, bl4, string3, null, l3, 0, pushEndpoint, false);
    }

    private RemoteFileDesc createRemoteFileDesc(String string, int n, long l, String string2, long l2, byte[] byArray, int n2, boolean bl, int n3, boolean bl2, LimeXMLDocument limeXMLDocument, Set<? extends URN> set, boolean bl3, boolean bl4, String string3, Set<? extends IpPort> set2, long l3, int n4, PushEndpoint pushEndpoint, boolean bl5) {
        if (bl4) {
            if (pushEndpoint == null) {
                IpPortImpl ipPortImpl;
                if (!string.equals("1.1.1.1")) {
                    try {
                        ipPortImpl = new IpPortImpl(string, n);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalArgumentException(unknownHostException);
                    }
                } else {
                    ipPortImpl = null;
                    n4 = 0;
                }
                pushEndpoint = this.pushEndpointFactory.createPushEndpoint(byArray, set2, (byte)0, n4, ipPortImpl);
            }
            byArray = pushEndpoint.getClientGUID();
        } else assert (pushEndpoint == null);
        if (set == null) {
            set = Collections.emptySet();
        }
        boolean bl6 = !set.isEmpty();
        return new RemoteFileDescImpl(string, n, l, string2, l2, byArray, n2, bl, n3, bl2, limeXMLDocument, set, bl3, bl4, string3, set2, l3, n4, pushEndpoint, bl5, bl6, this.networkInstanceUtils);
    }

    @Override
    public RemoteFileDesc createUrlRemoteFileDesc(String string, int n, String string2, long l, Set<? extends URN> set, URL uRL) {
        UrlRemoteFileDescImpl urlRemoteFileDescImpl = new UrlRemoteFileDescImpl(string, n, string2, l, set, uRL, this.networkInstanceUtils);
        urlRemoteFileDescImpl.setHTTP11(false);
        return urlRemoteFileDescImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long contentLength(URI uRI) throws HttpException, IOException, InterruptedException {
        HttpHead httpHead = new HttpHead(uRI);
        httpHead.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        HttpResponse httpResponse = null;
        LimeHttpClient limeHttpClient = (LimeHttpClient)this.httpClientProvider.get();
        try {
            httpResponse = limeHttpClient.execute((HttpUriRequest)httpHead);
            if (httpResponse.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Got " + httpResponse.getStatusLine().getStatusCode() + " instead of 200 for URL: " + uRI);
            }
            long l = -1L;
            if (httpResponse.getEntity() != null) {
                l = httpResponse.getEntity().getContentLength();
            }
            if (l < 0L) {
                throw new IOException("No content length");
            }
            long l2 = l;
            return l2;
        }
        finally {
            limeHttpClient.releaseConnection(httpResponse);
        }
    }

    @Override
    public RemoteFileDesc createFromMemento(RemoteHostMemento remoteHostMemento) throws InvalidDataException {
        if (remoteHostMemento.getCustomUrl() != null) {
            return this.createUrlRemoteFileDesc(remoteHostMemento.getHost(), remoteHostMemento.getPort(), remoteHostMemento.getFileName(), remoteHostMemento.getSize(), remoteHostMemento.getUrns(), remoteHostMemento.getCustomUrl());
        }
        try {
            return this.createRemoteFileDesc(remoteHostMemento.getHost(), remoteHostMemento.getPort(), remoteHostMemento.getIndex(), remoteHostMemento.getFileName(), remoteHostMemento.getSize(), remoteHostMemento.getClientGuid(), remoteHostMemento.getSpeed(), remoteHostMemento.isChat(), remoteHostMemento.getQuality(), remoteHostMemento.isBrowseHost(), this.xml(remoteHostMemento.getXml()), remoteHostMemento.getUrns(), remoteHostMemento.isReplyToMulticast(), remoteHostMemento.isFirewalled(), remoteHostMemento.getVendor(), IpPort.EMPTY_SET, -1L, -1, this.pe(remoteHostMemento.getPushAddr()), remoteHostMemento.isTls());
        }
        catch (SAXException sAXException) {
            throw new InvalidDataException(sAXException);
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            throw new InvalidDataException(schemaNotFoundException);
        }
        catch (IOException iOException) {
            throw new InvalidDataException(iOException);
        }
    }

    private PushEndpoint pe(String string) throws IOException {
        if (string != null) {
            return this.pushEndpointFactory.createPushEndpoint(string);
        }
        return null;
    }

    private LimeXMLDocument xml(String string) throws SAXException, SchemaNotFoundException, IOException {
        if (string != null) {
            return this.limeXMLDocumentFactory.createLimeXMLDocument(string);
        }
        return null;
    }
}

