/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.PushDetails;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkInstanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushList {
    private static final Log LOG = LogFactory.getLog(PushList.class);
    private final TreeMap<byte[], List<Push>> pushers = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public PushList(NetworkInstanceUtils networkInstanceUtils) {
        this.networkInstanceUtils = networkInstanceUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPushHost(PushDetails pushDetails, HTTPConnectObserver hTTPConnectObserver) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding observer for details: " + pushDetails));
        }
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            byte[] byArray = pushDetails.getClientGUID();
            List<Push> list = this.pushers.get(byArray);
            if (list == null) {
                list = new LinkedList<Push>();
                this.pushers.put(byArray, list);
            }
            list.add(new Push(pushDetails, hTTPConnectObserver));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getExactHostFor(PushDetails pushDetails) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving exact match for details: " + pushDetails));
        }
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            byte[] byArray = pushDetails.getClientGUID();
            List<Push> list = this.pushers.get(byArray);
            if (list == null) {
                LOG.debug((Object)"No pushes waiting on those exact details.");
                return null;
            }
            Push push = this.getExactHost(list, pushDetails);
            if (list.isEmpty()) {
                this.pushers.remove(byArray);
            }
            if (push != null) {
                return push.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getHostFor(byte[] byArray, String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving best match for address: " + string + ", guid: " + new GUID(byArray)));
        }
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            List<Push> list = this.pushers.get(byArray);
            if (list == null) {
                LOG.debug((Object)"No pushes waiting on that GUID.");
                return null;
            }
            Push push = this.getBestHost(list, string);
            if (list.isEmpty()) {
                this.pushers.remove(byArray);
            }
            if (push != null) {
                return push.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HTTPConnectObserver> getAllAndClear() {
        LinkedList<HTTPConnectObserver> linkedList = new LinkedList<HTTPConnectObserver>();
        TreeMap<byte[], List<Push>> treeMap = this.pushers;
        synchronized (treeMap) {
            for (List<Push> list : this.pushers.values()) {
                if (list == null) continue;
                for (Push push : list) {
                    linkedList.add(push.observer);
                }
            }
            this.pushers.clear();
        }
        return linkedList;
    }

    private Push getBestHost(List<? extends Push> list, String string) {
        Push push;
        if (list.isEmpty()) {
            return null;
        }
        Iterator<? extends Push> iterator = list.iterator();
        while (iterator.hasNext()) {
            push = iterator.next();
            if (!push.details.getAddress().equals(string)) continue;
            LOG.debug((Object)"Found an exact match!");
            iterator.remove();
            return push;
        }
        LOG.debug((Object)"No exact match, using first private|bogus address.");
        iterator = list.iterator();
        while (iterator.hasNext()) {
            push = iterator.next();
            if (!this.networkInstanceUtils.isPrivateAddress(push.details.getAddress()) && !push.details.getAddress().equals("1.1.1.1")) continue;
            iterator.remove();
            return push;
        }
        LOG.debug((Object)"No private address to use!");
        return null;
    }

    private Push getExactHost(List<? extends Push> list, PushDetails pushDetails) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<? extends Push> iterator = list.iterator();
        while (iterator.hasNext()) {
            Push push = iterator.next();
            if (!push.details.equals(pushDetails)) continue;
            iterator.remove();
            return push;
        }
        LOG.debug((Object)"No exact match!");
        return null;
    }

    private static class Push {
        private final PushDetails details;
        private final HTTPConnectObserver observer;

        Push(PushDetails pushDetails, HTTPConnectObserver hTTPConnectObserver) {
            this.details = pushDetails;
            this.observer = hTTPConnectObserver;
        }
    }
}

