/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RemoteHostData;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.DirectDHTAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.AbstractCoreDownloader;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskController;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.DownloadStatusEvent;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.DownloadWorkerFactory;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.DownloaderType;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.RequeryListener;
import com.limegroup.gnutella.downloader.RequeryManager;
import com.limegroup.gnutella.downloader.RequeryManagerFactory;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.SourceRankerFactory;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.downloader.VerifyingFileFactory;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMemento;
import com.limegroup.gnutella.downloader.serial.GnutellaDownloadMementoImpl;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.ApproximateMatcher;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.DiskException;
import org.limewire.io.IOUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.service.ErrorService;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ManagedDownloaderImpl
extends AbstractCoreDownloader
implements AltLocListener,
ManagedDownloader,
DownloadWorkerSupport {
    private static final Log LOG = LogFactory.getLog(ManagedDownloaderImpl.class);
    private Set<RemoteFileDesc> cachedRFDs;
    private SourceRanker ranker;
    private static final int GUESS_WAIT_TIME = 5000;
    private static final int MATCHER_BUF_SIZE = 120;
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private volatile Thread dloaderManagerThread;
    private volatile boolean stopped;
    private volatile boolean paused;
    private volatile boolean invalidated;
    private volatile List<DownloadWorker> _activeWorkers;
    private List<DownloadWorker> _workers;
    private volatile Map<DownloadWorker, Integer> _queuedWorkers;
    private Set<RemoteFileDesc> currentRFDs;
    private volatile URN downloadSHA1;
    private Set<AlternateLocation> validAlts;
    private Set<RemoteHostData> invalidAlts;
    private Set<AlternateLocation> recentInvalidAlts;
    protected VerifyingFile commonOutFile;
    private volatile PushList pushes;
    private Downloader.DownloadStatus state = Downloader.DownloadStatus.INITIALIZING;
    private long stateTime;
    private File incompleteFile;
    private int queuePosition;
    private String queuedVendor;
    private volatile long corruptFileBytes;
    private volatile File corruptFile;
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private volatile int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private volatile GUID originalQueryGUID;
    private boolean triedLocatingSources;
    private volatile boolean receivedNewSources;
    private volatile int triedHosts;
    private long contentLength = -1L;
    private final EventListenerList<DownloadStatusEvent> listeners = new EventListenerList();
    protected final DownloadManager downloadManager;
    protected final FileManager fileManager;
    protected final IncompleteFileManager incompleteFileManager;
    protected final DownloadCallback downloadCallback;
    protected final NetworkManager networkManager;
    protected final AlternateLocationFactory alternateLocationFactory;
    protected final RequeryManager requeryManager;
    protected final QueryRequestFactory queryRequestFactory;
    protected final OnDemandUnicaster onDemandUnicaster;
    protected final DownloadWorkerFactory downloadWorkerFactory;
    protected final AltLocManager altLocManager;
    protected final ContentManager contentManager;
    protected final SourceRankerFactory sourceRankerFactory;
    protected final UrnCache urnCache;
    protected final SavedFileManager savedFileManager;
    protected final VerifyingFileFactory verifyingFileFactory;
    protected final DiskController diskController;
    protected final IPFilter ipFilter;
    protected final ScheduledExecutorService backgroundExecutor;
    protected final Provider<MessageRouter> messageRouter;
    protected final Provider<HashTreeCache> tigerTreeCache;
    protected final ApplicationServices applicationServices;
    protected final RemoteFileDescFactory remoteFileDescFactory;
    protected final Provider<PushList> pushListProvider;
    private static boolean initDone = false;
    private boolean canceled = false;

    @Inject
    protected ManagedDownloaderImpl(SaveLocationManager saveLocationManager, DownloadManager downloadManager, FileManager fileManager, IncompleteFileManager incompleteFileManager, DownloadCallback downloadCallback, NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, RequeryManagerFactory requeryManagerFactory, QueryRequestFactory queryRequestFactory, OnDemandUnicaster onDemandUnicaster, DownloadWorkerFactory downloadWorkerFactory, AltLocManager altLocManager, ContentManager contentManager, SourceRankerFactory sourceRankerFactory, UrnCache urnCache, SavedFileManager savedFileManager, VerifyingFileFactory verifyingFileFactory, DiskController diskController, IPFilter iPFilter, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<MessageRouter> provider, Provider<HashTreeCache> provider2, ApplicationServices applicationServices, RemoteFileDescFactory remoteFileDescFactory, Provider<PushList> provider3) {
        super(saveLocationManager);
        this.downloadManager = downloadManager;
        this.fileManager = fileManager;
        this.incompleteFileManager = incompleteFileManager;
        this.downloadCallback = downloadCallback;
        this.networkManager = networkManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.requeryManager = requeryManagerFactory.createRequeryManager(new RequeryListenerImpl());
        this.queryRequestFactory = queryRequestFactory;
        this.onDemandUnicaster = onDemandUnicaster;
        this.downloadWorkerFactory = downloadWorkerFactory;
        this.altLocManager = altLocManager;
        this.contentManager = contentManager;
        this.sourceRankerFactory = sourceRankerFactory;
        this.urnCache = urnCache;
        this.savedFileManager = savedFileManager;
        this.verifyingFileFactory = verifyingFileFactory;
        this.diskController = diskController;
        this.ipFilter = iPFilter;
        this.backgroundExecutor = scheduledExecutorService;
        this.messageRouter = provider;
        this.tigerTreeCache = provider2;
        this.applicationServices = applicationServices;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.cachedRFDs = new HashSet<RemoteFileDesc>();
        this.pushListProvider = provider3;
    }

    @Override
    public synchronized void addInitialSources(Collection<RemoteFileDesc> collection, String string) {
        if (collection == null) {
            collection = Collections.emptyList();
        }
        this.cachedRFDs.addAll(collection);
        if (collection.size() > 0) {
            this.initPropertiesMap(collection.iterator().next());
        }
        assert (collection.size() > 0 || string != null);
        if (!this.hasDefaultFileName()) {
            this.setDefaultFileName(string);
        }
    }

    @Override
    public void setQueryGuid(GUID gUID) {
        this.originalQueryGUID = gUID;
    }

    protected synchronized void initPropertiesMap(RemoteFileDesc remoteFileDesc) {
        if (!this.hasDefaultFileName()) {
            this.setDefaultFileName(remoteFileDesc.getFileName());
        }
        if (this.getContentLength() == -1L) {
            this.setContentLength(remoteFileDesc.getSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        this.setState(Downloader.DownloadStatus.INITIALIZING);
        Object object = this;
        synchronized (object) {
            this.currentRFDs = new HashSet<RemoteFileDesc>();
            this._activeWorkers = new LinkedList<DownloadWorker>();
            this._workers = new ArrayList<DownloadWorker>();
            this._queuedWorkers = new HashMap<DownloadWorker, Integer>();
            this.chatList = new DownloadChatList();
            this.browseList = new DownloadBrowseHostList();
            this.stopped = false;
            this.paused = false;
            this.pushes = (PushList)this.pushListProvider.get();
            this.corruptState = 0;
            this.corruptStateLock = new Object();
            this.altLock = new Object();
            this.numMeasures = 0;
            this.averageBandwidth = 0.0f;
            this.queuePosition = Integer.MAX_VALUE;
            this.queuedVendor = "";
            this.triedLocatingSources = false;
            this.ranker = this.getSourceRanker(null);
            this.ranker.setMeshHandler(this);
            for (RemoteFileDesc remoteFileDesc : this.cachedRFDs) {
                if (this.getSha1Urn() != null) break;
                if (remoteFileDesc.getSHA1Urn() == null) continue;
                this.setSha1Urn(remoteFileDesc.getSHA1Urn());
            }
        }
        this.setState(Downloader.DownloadStatus.QUEUED);
        if (this.getSha1Urn() != null) {
            this.altLocManager.addListener(this.getSha1Urn(), this);
        }
        this.verifyAllFiles();
        object = this.altLock;
        synchronized (object) {
            this.validAlts = new HashSet<AlternateLocation>();
            this.invalidAlts = new FixedSizeExpiringSet<RemoteHostData>(1000, 3600000L);
            this.recentInvalidAlts = new FixedSizeExpiringSet<AlternateLocation>(10, 600000L);
        }
        object = this;
        synchronized (object) {
            if (this.shouldInitAltLocs()) {
                this.initializeAlternateLocations();
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
        }
        catch (IOException iOException) {
            this.setState(Downloader.DownloadStatus.DISK_PROBLEM);
            this.reportDiskProblem(iOException);
            return;
        }
        this.setState(Downloader.DownloadStatus.QUEUED);
    }

    private void reportDiskProblem(IOException iOException) {
        if (DownloadSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            if (!(iOException instanceof DiskException)) {
                iOException = new DiskException(iOException);
            }
            ErrorService.error(iOException);
        }
    }

    protected void reportDiskProblem(String string) {
        if (DownloadSettings.REPORT_DISK_PROBLEMS.getBoolean()) {
            ErrorService.error(new DiskException(string));
        }
    }

    private synchronized void verifyAllFiles() {
        if (this.getSha1Urn() == null) {
            return;
        }
        Iterator<RemoteFileDesc> iterator = this.cachedRFDs.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = iterator.next();
            if (remoteFileDesc.getSHA1Urn() == null || this.getSha1Urn().equals(remoteFileDesc.getSHA1Urn())) continue;
            iterator.remove();
        }
    }

    @Override
    public synchronized void startDownload() {
        assert (this.dloaderManagerThread == null) : "already started";
        ThreadExecutor.startThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ManagedDownloaderImpl.this.dloaderManagerThread = Thread.currentThread();
                    ManagedDownloaderImpl.this.validateDownload();
                    ManagedDownloaderImpl.this.receivedNewSources = false;
                    ManagedDownloaderImpl.this.triedHosts = 0;
                    Downloader.DownloadStatus downloadStatus = ManagedDownloaderImpl.this.performDownload();
                    ManagedDownloaderImpl.this.completeDownload(downloadStatus);
                }
                catch (Throwable throwable) {
                    ManagedDownloaderImpl.this.stop();
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.ABORTED);
                    ManagedDownloaderImpl.this.downloadManager.remove(ManagedDownloaderImpl.this, true);
                    ErrorService.error(throwable);
                }
                finally {
                    ManagedDownloaderImpl.this.dloaderManagerThread = null;
                }
            }
        }, "ManagedDownload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeDownload(Downloader.DownloadStatus downloadStatus) {
        block34: {
            boolean bl;
            block36: {
                boolean bl2;
                boolean bl3 = false;
                int n = 0;
                Object object = this;
                synchronized (object) {
                    switch (downloadStatus) {
                        case COMPLETE: 
                        case DISK_PROBLEM: 
                        case CORRUPT_FILE: {
                            bl3 = true;
                            this.setState(downloadStatus);
                            break;
                        }
                        case BUSY: 
                        case GAVE_UP: {
                            if (this.invalidated) {
                                bl3 = true;
                                this.setState(Downloader.DownloadStatus.INVALID);
                                break;
                            }
                            if (this.stopped) {
                                this.setState(Downloader.DownloadStatus.ABORTED);
                                break;
                            }
                            if (this.paused) {
                                this.setState(Downloader.DownloadStatus.PAUSED);
                                break;
                            }
                            this.setState(downloadStatus);
                            break;
                        }
                        default: {
                            assert (false) : "Bad status from tad2: " + (Object)((Object)downloadStatus);
                            break;
                        }
                    }
                    bl2 = this.isCompleted();
                    n = this.ranker.calculateWaitTime();
                    this.ranker.stop();
                    if (bl3) {
                        this.ranker = null;
                    }
                }
                this.downloadManager.remove(this, bl2);
                if (bl3) {
                    object = this.altLock;
                    synchronized (object) {
                        this.recentInvalidAlts.clear();
                        this.invalidAlts.clear();
                        this.validAlts.clear();
                    }
                    if (bl2) {
                        object = this;
                        synchronized (object) {
                            this.cachedRFDs.clear();
                        }
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("MD completing <" + this.getSaveFile().getName() + "> completed download, state: " + (Object)((Object)this.getState())));
                }
                this.diskController.clearCaches();
                if (bl2 || this.getState() == Downloader.DownloadStatus.PAUSED || this.tryGUESSing()) break block34;
                bl = false;
                ManagedDownloaderImpl managedDownloaderImpl = this;
                synchronized (managedDownloaderImpl) {
                    block37: {
                        block35: {
                            if (this.getState() != Downloader.DownloadStatus.BUSY) break block35;
                            this.setState(Downloader.DownloadStatus.BUSY, n);
                            break block36;
                        }
                        if (!this.requeryManager.isWaitingForResults()) break block37;
                        switch (this.requeryManager.getLastQueryType()) {
                            case DHT: {
                                this.setState(Downloader.DownloadStatus.QUERYING_DHT, this.requeryManager.getTimeLeftInQuery());
                                break block36;
                            }
                            case GNUTELLA: {
                                this.setState(Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS, this.requeryManager.getTimeLeftInQuery());
                                break block36;
                            }
                            default: {
                                throw new IllegalStateException("Not any query type!");
                            }
                        }
                    }
                    if (this.canSendRequeryNow()) {
                        bl = true;
                    } else if (this.requeryManager.canSendQueryAfterActivate()) {
                        this.setState(Downloader.DownloadStatus.WAITING_FOR_USER);
                    } else {
                        this.setState(Downloader.DownloadStatus.GAVE_UP);
                    }
                }
            }
            if (bl) {
                this.requeryManager.sendQuery();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("MD completed <" + this.getSaveFile().getName() + "> completed download, state: " + (Object)((Object)this.getState())));
        }
    }

    @Override
    public synchronized void handleInactivity() {
        switch (this.getState()) {
            case BUSY: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: {
                if (this.getRemainingStateTime() > 0 && !this.hasNewSources()) break;
                this.setState(Downloader.DownloadStatus.QUEUED);
                break;
            }
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: {
                if (this.hasNewSources()) {
                    this.setState(Downloader.DownloadStatus.QUEUED);
                    break;
                }
                if (this.requeryManager.getTimeLeftInQuery() > 0L) break;
                this.setState(Downloader.DownloadStatus.GAVE_UP);
                break;
            }
            case WAITING_FOR_USER: {
                if (!this.hasNewSources() && !this.requeryManager.canSendQueryNow()) break;
                this.setState(Downloader.DownloadStatus.QUEUED);
                break;
            }
            case GAVE_UP: {
                if (this.hasNewSources() || this.requeryManager.canSendQueryAfterActivate()) {
                    this.setState(Downloader.DownloadStatus.QUEUED);
                }
            }
            case QUEUED: 
            case PAUSED: {
                break;
            }
            default: {
                throw new IllegalStateException("invalid state: " + (Object)((Object)this.getState()) + ", workers: " + this._workers.size() + ", _activeWorkers: " + this._activeWorkers.size() + ", _queuedWorkers: " + this._queuedWorkers.size());
            }
        }
    }

    private boolean tryGUESSing() {
        if (this.originalQueryGUID == null || this.triedLocatingSources || this.getSha1Urn() == null) {
            return false;
        }
        Set<GUESSEndpoint> set = ((MessageRouter)this.messageRouter.get()).getQueryLocs(this.originalQueryGUID);
        if (set.isEmpty()) {
            return false;
        }
        this.setState(Downloader.DownloadStatus.ITERATIVE_GUESSING, 5000L);
        this.triedLocatingSources = true;
        for (GUESSEndpoint gUESSEndpoint : set) {
            this.onDemandUnicaster.query(gUESSEndpoint, this.getSha1Urn());
            if (!this.receivedNewSources) continue;
            break;
        }
        return true;
    }

    @Override
    public boolean isAlive() {
        return this.dloaderManagerThread != null;
    }

    @Override
    public boolean isCompleted() {
        switch (this.getState()) {
            case COMPLETE: 
            case DISK_PROBLEM: 
            case CORRUPT_FILE: 
            case ABORTED: 
            case INVALID: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isRelocatable() {
        if (this.isInactive()) {
            return true;
        }
        switch (this.getState()) {
            case INITIALIZING: 
            case CONNECTING: 
            case DOWNLOADING: 
            case REMOTE_QUEUED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isActive() {
        switch (this.getState()) {
            case CONNECTING: 
            case DOWNLOADING: 
            case REMOTE_QUEUED: 
            case HASHING: 
            case SAVING: 
            case IDENTIFY_CORRUPTION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInactive() {
        switch (this.getState()) {
            case BUSY: 
            case GAVE_UP: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: 
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: 
            case WAITING_FOR_USER: 
            case QUEUED: 
            case PAUSED: 
            case INITIALIZING: {
                return true;
            }
        }
        return false;
    }

    private synchronized void initializeRanker() {
        this.ranker.setMeshHandler(this);
        this.ranker.addToPool(this.cachedRFDs);
    }

    protected void initializeVerifyingFile() throws IOException {
        if (this.incompleteFile == null) {
            return;
        }
        this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
        if (this.commonOutFile == null) {
            long l = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            if (l > 0xFFFFFFFFFFL) {
                throw new IOException("invalid incomplete file " + l);
            }
            this.commonOutFile = this.verifyingFileFactory.createVerifyingFile(l);
            this.commonOutFile.setScanForExistingBlocks(true, this.incompleteFile.length());
            this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile, this.shouldPublishIFD());
        }
    }

    protected void initializeIncompleteFile() throws IOException {
        if (this.incompleteFile != null) {
            return;
        }
        URN uRN = this.getSha1Urn();
        if (uRN != null) {
            this.incompleteFile = this.incompleteFileManager.getFileForUrn(uRN);
        }
        if (this.incompleteFile == null) {
            this.incompleteFile = this.getIncompleteFile(this.getSaveFile().getName(), uRN, this.getContentLength());
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Incomplete File: " + this.incompleteFile));
        }
    }

    protected File getIncompleteFile(String string, URN uRN, long l) throws IOException {
        return this.incompleteFileManager.getFile(string, uRN, l);
    }

    private synchronized void initializeAlternateLocations() {
        HTTPHeaderValue hTTPHeaderValue;
        if (this.incompleteFile == null) {
            return;
        }
        FileDesc fileDesc = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fileDesc != null && fileDesc instanceof IncompleteFileDesc) {
            hTTPHeaderValue = (IncompleteFileDesc)fileDesc;
            if (this.getSha1Urn() != null && !this.getSha1Urn().equals(((FileDesc)((Object)hTTPHeaderValue)).getSHA1Urn())) {
                ErrorService.error(new IllegalStateException("wrong IFD.\nclass: " + this.getClass().getName() + "\nours  :   " + this.incompleteFile + "\ntheirs: " + ((FileDesc)((Object)hTTPHeaderValue)).getFile() + "\nour hash    : " + this.getSha1Urn() + "\ntheir hashes: " + ((FileDesc)((Object)hTTPHeaderValue)).getUrns() + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes()));
                this.fileManager.removeFileIfSharedOrStore(this.incompleteFile);
            }
        }
        if ((hTTPHeaderValue = this.incompleteFileManager.getCompletedHash(this.incompleteFile)) != null) {
            long l = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            this.addLocationsToDownload(this.altLocManager.getDirect((URN)hTTPHeaderValue), this.altLocManager.getPushNoFWT((URN)hTTPHeaderValue), this.altLocManager.getPushFWT((URN)hTTPHeaderValue), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToDownload(AlternateLocationCollection<? extends AlternateLocation> alternateLocationCollection, AlternateLocationCollection<? extends AlternateLocation> alternateLocationCollection2, AlternateLocationCollection<? extends AlternateLocation> alternateLocationCollection3, long l) {
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(alternateLocationCollection.getAltLocsSize() + alternateLocationCollection2.getAltLocsSize() + alternateLocationCollection3.getAltLocsSize());
        AlternateLocationCollection<? extends AlternateLocation> alternateLocationCollection4 = alternateLocationCollection;
        synchronized (alternateLocationCollection4) {
            for (AlternateLocation alternateLocation : alternateLocationCollection) {
                arrayList.add(alternateLocation.createRemoteFileDesc(l, this.remoteFileDescFactory));
            }
        }
        alternateLocationCollection4 = alternateLocationCollection2;
        synchronized (alternateLocationCollection4) {
            for (AlternateLocation alternateLocation : alternateLocationCollection2) {
                arrayList.add(alternateLocation.createRemoteFileDesc(l, this.remoteFileDescFactory));
            }
        }
        alternateLocationCollection4 = alternateLocationCollection3;
        synchronized (alternateLocationCollection4) {
            for (AlternateLocation alternateLocation : alternateLocationCollection3) {
                arrayList.add(alternateLocation.createRemoteFileDesc(l, this.remoteFileDescFactory));
            }
        }
        this.addPossibleSources(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean conflictsWithIncompleteFile(File file) {
        File file2 = this.incompleteFile;
        if (file2 != null) {
            return file2.equals(file);
        }
        URN uRN = this.getSha1Urn();
        if (uRN != null) {
            file2 = this.incompleteFileManager.getFileForUrn(uRN);
        }
        if (file2 != null) {
            return file2.equals(file);
        }
        RemoteFileDesc remoteFileDesc = null;
        Object object = this;
        synchronized (object) {
            if (!this.hasRFD()) {
                return false;
            }
            remoteFileDesc = this.cachedRFDs.iterator().next();
        }
        if (remoteFileDesc != null) {
            try {
                object = this.incompleteFileManager.getFile(remoteFileDesc);
                return ((File)object).equals(file);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean conflicts(URN uRN, long l, File ... fileArray) {
        if (uRN != null && this.getSha1Urn() != null) {
            return uRN.equals(this.getSha1Urn());
        }
        if (l > 0L) {
            try {
                File file = this.incompleteFileManager.getFile(fileArray[0].getName(), null, l);
                return this.conflictsWithIncompleteFile(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized QueryRequest newRequery() throws CantResumeException {
        String string = QueryUtils.createQueryString(this.getDefaultFileName());
        if (string == null || string.equals("")) {
            throw new CantResumeException(this.getSaveFile().getName());
        }
        return this.queryRequestFactory.createQuery(string);
    }

    protected boolean shouldInitAltLocs() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hostIsAllowed(RemoteFileDesc remoteFileDesc) {
        if (!this.ipFilter.allow(remoteFileDesc.getHost())) {
            return false;
        }
        if (this.networkManager.acceptedIncomingConnection() || !remoteFileDesc.isFirewalled() || remoteFileDesc.supportsFWTransfer() && this.networkManager.canDoFWT()) {
            Object object = this.altLock;
            synchronized (object) {
                if (remoteFileDesc.isFromAlternateLocation() && this.invalidAlts.contains(remoteFileDesc.getRemoteHostData())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        Object object;
        if (!initDone) {
            object = matcher;
            synchronized (object) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            initDone = true;
        }
        if (remoteFileDesc.getQuality() < 1) {
            return false;
        }
        object = remoteFileDesc.getSHA1Urn();
        String string = remoteFileDesc.getFileName();
        long l = remoteFileDesc.getFileSize();
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            long l2 = this.getContentLength();
            if (l2 != -1L && l2 != l) {
                return false;
            }
            if (object != null && this.getSha1Urn() != null) {
                return ((URN)object).equals(this.getSha1Urn());
            }
            for (RemoteFileDesc remoteFileDesc2 : this.cachedRFDs) {
                String string2 = remoteFileDesc2.getFileName();
                long l3 = remoteFileDesc2.getFileSize();
                if (l != l3 || !this.namesClose(string, string2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String string, String string2) {
        boolean bl = false;
        int n = Math.round(Math.min(0.1f * (float)QueryUtils.ripExtension(string).length(), 0.1f * (float)QueryUtils.ripExtension(string2).length()));
        n = Math.min(n, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            bl = matcher.matches(matcher.process(string), matcher.process(string2), n);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MD.namesClose(): one = " + string));
            LOG.debug((Object)("MD.namesClose(): two = " + string2));
            LOG.debug((Object)("MD.namesClose(): retVal = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void locationAdded(AlternateLocation alternateLocation) {
        long l;
        assert (alternateLocation.getSHA1Urn().equals(this.getSha1Urn()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("alt loc added: " + alternateLocation));
        }
        long l2 = -1L;
        if (alternateLocation instanceof DirectDHTAltLoc && (l = ((DirectDHTAltLoc)alternateLocation).getFileSize()) >= 0L) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                l2 = this.getContentLength();
                if (l2 < 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Using file size from AltLocValue: " + l));
                    }
                    if ((l2 = l) <= 0xFFFFFFFFFFL) {
                        this.setContentLength(l2);
                    }
                }
            }
            if (l != l2) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("File sizes do not match: " + l + " vs. " + l2));
                }
                return;
            }
        }
        if ((l2 = this.getContentLength()) < 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unknown file size: " + l2));
            }
            return;
        }
        if (l2 > 0xFFFFFFFFFFL) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Content length is too big: " + l2));
            }
            return;
        }
        this.addDownload(alternateLocation.createRemoteFileDesc(l2, this.remoteFileDescFactory), false);
    }

    @Override
    public synchronized boolean addDownload(RemoteFileDesc remoteFileDesc, boolean bl) {
        return this.addDownload(Collections.singleton(remoteFileDesc), bl);
    }

    @Override
    public synchronized boolean addDownload(Collection<? extends RemoteFileDesc> collection, boolean bl) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(collection.size());
        for (RemoteFileDesc remoteFileDesc : collection) {
            if (!this.allowAddition(remoteFileDesc)) continue;
            remoteFileDesc.setDownloading(true);
            if (!this.hostIsAllowed(remoteFileDesc)) continue;
            arrayList.add(remoteFileDesc);
        }
        return this.addDownloadForced(arrayList, bl);
    }

    protected synchronized boolean addDownloadForced(RemoteFileDesc remoteFileDesc, boolean bl) {
        return this.addDownloadForced(Collections.singleton(remoteFileDesc), bl);
    }

    protected final synchronized boolean addDownloadForced(Collection<? extends RemoteFileDesc> collection, boolean bl) {
        HashSet<? extends RemoteFileDesc> hashSet = new HashSet<RemoteFileDesc>(collection);
        hashSet.removeAll(this.currentRFDs);
        byte[] byArray = this.applicationServices.getMyGUID();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc.isMe(byArray)) {
                iterator.remove();
                continue;
            }
            this.prepareRFD(remoteFileDesc, bl);
        }
        if (this.ranker.addToPool(hashSet)) {
            this.receivedNewSources = true;
        }
        return true;
    }

    private void prepareRFD(RemoteFileDesc remoteFileDesc, boolean bl) {
        if (this.getSha1Urn() == null && remoteFileDesc.getSHA1Urn() != null) {
            this.setSha1Urn(remoteFileDesc.getSHA1Urn());
            this.altLocManager.addListener(this.getSha1Urn(), this);
        }
        if (bl) {
            this.cachedRFDs.add(remoteFileDesc);
        }
    }

    @Override
    public boolean hasNewSources() {
        return !this.paused && this.receivedNewSources;
    }

    @Override
    public boolean shouldBeRestarted() {
        Downloader.DownloadStatus downloadStatus = this.getState();
        return this.hasNewSources() || this.getRemainingStateTime() <= 0 && downloadStatus != Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS && downloadStatus != Downloader.DownloadStatus.QUERYING_DHT;
    }

    @Override
    public boolean shouldBeRemoved() {
        return this.isCancelled() || this.isCompleted();
    }

    @Override
    public boolean isQueuable() {
        return !this.isPaused();
    }

    @Override
    public boolean acceptDownload(String string, Socket socket, int n, byte[] byArray) {
        if (this.stopped) {
            return false;
        }
        HTTPConnectObserver hTTPConnectObserver = this.pushes.getHostFor(byArray, socket.getInetAddress().getHostAddress());
        if (hTTPConnectObserver != null) {
            hTTPConnectObserver.handleConnect(socket);
        }
        return hTTPConnectObserver != null;
    }

    @Override
    public void registerPushObserver(HTTPConnectObserver hTTPConnectObserver, PushDetails pushDetails) {
        this.pushes.addPushHost(pushDetails, hTTPConnectObserver);
    }

    @Override
    public void unregisterPushObserver(PushDetails pushDetails, boolean bl) {
        HTTPConnectObserver hTTPConnectObserver = this.pushes.getExactHostFor(pushDetails);
        if (hTTPConnectObserver != null && bl) {
            hTTPConnectObserver.shutdown();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.stopped;
    }

    @Override
    public synchronized void pause() {
        if (!this.stopped && !this.isCompleted()) {
            this.stop();
            this.stopped = false;
            this.paused = true;
            if (this.isInactive()) {
                this.setState(Downloader.DownloadStatus.PAUSED);
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isPausable() {
        Downloader.DownloadStatus downloadStatus = this.getState();
        return !this.isPaused() && !this.isCompleted() && downloadStatus != Downloader.DownloadStatus.SAVING && downloadStatus != Downloader.DownloadStatus.HASHING;
    }

    @Override
    public boolean isResumable() {
        return this.isInactive() && this.state != Downloader.DownloadStatus.QUEUED;
    }

    @Override
    public boolean isLaunchable() {
        return this.state == Downloader.DownloadStatus.COMPLETE || this.amountForPreview() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.paused) {
            this.stopped = true;
            this.paused = false;
        }
        if (this.stopped || this.paused) {
            return;
        }
        LOG.debug((Object)"STOPPING ManagedDownloader");
        this.stopped = true;
        this.killAllWorkers();
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            Thread thread = this.dloaderManagerThread;
            if (thread != null) {
                thread.interrupt();
            } else {
                LOG.warn((Object)"MANAGER: no thread to interrupt");
            }
        }
    }

    private void killAllWorkers() {
        List<DownloadWorker> list = this.getAllWorkers();
        for (DownloadWorker object2 : list) {
            object2.interrupt();
        }
        List<HTTPConnectObserver> list2 = this.pushes.getAllAndClear();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            HTTPConnectObserver hTTPConnectObserver = (HTTPConnectObserver)iterator.next();
            hTTPConnectObserver.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void informMesh(RemoteFileDesc remoteFileDesc, boolean bl) {
        Object object;
        AlternateLocation alternateLocation;
        AlternateLocation alternateLocation2;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("informing mesh that " + remoteFileDesc + " is " + bl));
        }
        if (bl) {
            this.cachedRFDs.add(remoteFileDesc);
        }
        if (!remoteFileDesc.isAltLocCapable()) {
            return;
        }
        assert (this.getSha1Urn() != null) : "null hash.";
        assert (this.getSha1Urn().equals(remoteFileDesc.getSHA1Urn())) : "wrong loc SHA1";
        try {
            alternateLocation2 = this.alternateLocationFactory.create(remoteFileDesc);
        }
        catch (IOException iOException) {
            return;
        }
        if (alternateLocation2 instanceof PushAltLoc) {
            alternateLocation = alternateLocation2.createClone();
            object = (PushAltLoc)alternateLocation2;
            if (((PushAltLoc)object).getPushAddress().getProxies().isEmpty()) {
                return;
            }
            ((PushAltLoc)object).updateProxies(bl);
        } else {
            alternateLocation = alternateLocation2;
        }
        if (bl) {
            this.altLocManager.add(alternateLocation2, this);
        } else {
            this.altLocManager.remove(alternateLocation2, this);
        }
        for (DownloadWorker downloadWorker : this.getActiveWorkers()) {
            HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
            RemoteFileDesc remoteFileDesc2 = hTTPDownloader.getRemoteFileDesc();
            if (alternateLocation instanceof PushAltLoc ? remoteFileDesc2.getPushAddr() != null && ((Object)remoteFileDesc2.getPushAddr()).equals(remoteFileDesc.getPushAddr()) : remoteFileDesc2.getHost().equals(remoteFileDesc.getHost()) && remoteFileDesc2.getPort() == remoteFileDesc.getPort()) continue;
            if (!(alternateLocation instanceof DirectAltLoc) && !hTTPDownloader.wantsFalts()) continue;
            if (bl) {
                hTTPDownloader.addSuccessfulAltLoc(alternateLocation);
                continue;
            }
            hTTPDownloader.addFailedAltLoc(alternateLocation);
        }
        object = this.altLock;
        synchronized (object) {
            if (bl) {
                if (!this.validAlts.contains(alternateLocation)) {
                    this.validAlts.add(alternateLocation);
                }
            } else {
                this.validAlts.remove(alternateLocation);
                this.invalidAlts.add(remoteFileDesc.getRemoteHostData());
                this.recentInvalidAlts.add(alternateLocation);
            }
        }
    }

    @Override
    public synchronized void addPossibleSources(Collection<? extends RemoteFileDesc> collection) {
        this.addDownload(collection, false);
    }

    protected boolean canSendRequeryNow() {
        return this.requeryManager.canSendQueryNow();
    }

    @Override
    public synchronized boolean resume() {
        if (!this.isInactive()) {
            return false;
        }
        if (this.getState() == Downloader.DownloadStatus.WAITING_FOR_USER) {
            this.requeryManager.activate();
        }
        for (RemoteFileDesc remoteFileDesc : this.cachedRFDs) {
            remoteFileDesc.setRetryAfter(0);
        }
        if (this.paused) {
            this.paused = false;
            this.stopped = false;
        }
        this.setState(Downloader.DownloadStatus.QUEUED);
        return true;
    }

    @Override
    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == Downloader.DownloadStatus.COMPLETE) {
            return this.getSaveFile();
        }
        return this.incompleteFile;
    }

    @Override
    public URN getSha1Urn() {
        return this.downloadSHA1;
    }

    protected void setSha1Urn(URN uRN) {
        if (!uRN.isSHA1()) {
            throw new IllegalArgumentException("not sha1: " + uRN);
        }
        if (this.downloadSHA1 != null && !uRN.equals(this.downloadSHA1)) {
            throw new IllegalStateException("sha1 already set to: " + this.downloadSHA1);
        }
        this.downloadSHA1 = uRN;
    }

    @Override
    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == Downloader.DownloadStatus.CORRUPT_FILE) {
            return this.corruptFile;
        }
        if (this.state != Downloader.DownloadStatus.COMPLETE) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            long l = this.amountForPreview();
            if (l <= 0L) {
                return null;
            }
            if (FileUtils.copy(this.incompleteFile, l, file) <= 0L) {
                return null;
            }
            return file;
        }
        return this.getSaveFile();
    }

    private synchronized long amountForPreview() {
        if (this.commonOutFile == null) {
            return 0L;
        }
        return this.commonOutFile.getOffsetForPreview();
    }

    @Override
    protected File getDefaultSaveFile() {
        String string = this.getDefaultFileName();
        return new File(SharingSettings.getSaveDirectory(string), string);
    }

    @Override
    public synchronized void finish() {
        if (this.getSha1Urn() != null) {
            this.altLocManager.removeListener(this.getSha1Urn(), this);
        }
        this.requeryManager.cleanUp();
        if (this.cachedRFDs != null) {
            for (RemoteFileDesc remoteFileDesc : this.cachedRFDs) {
                remoteFileDesc.setDownloading(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Downloader.DownloadStatus performDownload() {
        Downloader.DownloadStatus downloadStatus;
        block14: {
            if (this.checkHosts()) {
                this.setState(Downloader.DownloadStatus.GAVE_UP);
                return Downloader.DownloadStatus.GAVE_UP;
            }
            downloadStatus = this.initializeDownload();
            if (downloadStatus == Downloader.DownloadStatus.CONNECTING) {
                try {
                    try {
                        downloadStatus = this.fireDownloadWorkers();
                    }
                    finally {
                        this.commonOutFile.close();
                    }
                    if (downloadStatus == Downloader.DownloadStatus.COMPLETE) {
                        downloadStatus = this.verifyAndSave();
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("stopping early with status: " + (Object)((Object)downloadStatus)));
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!this.stopped && !this.paused) {
                        ErrorService.error(interruptedException);
                    } else {
                        downloadStatus = Downloader.DownloadStatus.GAVE_UP;
                    }
                    if (this.corruptState != 2) break block14;
                    this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
                    downloadStatus = Downloader.DownloadStatus.CORRUPT_FILE;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MANAGER: TAD2 returned: " + (Object)((Object)downloadStatus)));
        }
        return downloadStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Downloader.DownloadStatus initializeDownload() {
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (this.cachedRFDs.size() == 0 && !this.ranker.hasMore()) {
                return Downloader.DownloadStatus.GAVE_UP;
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
            this.openVerifyingFile();
        }
        catch (IOException iOException) {
            this.reportDiskProblem(iOException);
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        if (this.getSha1Urn() != null) {
            this.initializeHashTree();
        }
        this.initializeRanker();
        return Downloader.DownloadStatus.CONNECTING;
    }

    private Downloader.DownloadStatus verifyAndSave() throws InterruptedException {
        URN uRN = this.scanForCorruption();
        if (this.corruptState == 2) {
            this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
            return Downloader.DownloadStatus.CORRUPT_FILE;
        }
        return this.saveFile(uRN);
    }

    private void validateDownload() {
        if (this.shouldValidate() && this.getSha1Urn() != null) {
            this.contentManager.request(this.getSha1Urn(), new ContentResponseObserver(){

                public void handleResponse(URN uRN, ContentResponseData contentResponseData) {
                    if (contentResponseData != null && !contentResponseData.isOK()) {
                        ManagedDownloaderImpl.this.invalidated = true;
                        ManagedDownloaderImpl.this.stop();
                    }
                }
            }, 5000L);
        }
    }

    protected boolean shouldValidate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCorruptResponse() {
        if (this.corruptState != 0) {
            Object object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private URN scanForCorruption() throws InterruptedException {
        if (this.corruptState == 2) {
            return null;
        }
        URN uRN = null;
        try {
            this.setState(Downloader.DownloadStatus.HASHING);
            uRN = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.getSha1Urn() == null) {
            return uRN;
        }
        if (this.getSha1Urn().equals(uRN)) {
            return uRN;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("hash verification problem, fileHash=" + uRN + ", ourHash=" + this.getSha1Urn()));
        }
        if (this.commonOutFile.getHashTree() == null) {
            this.fileManager.removeFileIfSharedOrStore(this.incompleteFile);
        }
        ((HashTreeCache)this.tigerTreeCache.get()).purgeTree(this.getSha1Urn());
        this.commonOutFile.setHashTree(null);
        this.promptAboutCorruptDownload();
        this.waitForCorruptResponse();
        return uRN;
    }

    private void initializeHashTree() {
        HashTree hashTree = ((HashTreeCache)this.tigerTreeCache.get()).getHashTree(this.getSha1Urn());
        if (hashTree != null && hashTree.isDepthGoodEnough()) {
            this.commonOutFile.setHashTree(hashTree);
        }
    }

    protected Downloader.DownloadStatus saveFile(URN uRN) {
        this.setState(Downloader.DownloadStatus.SAVING);
        if (!FileUtils.setWriteable(this.getSaveFile().getParentFile())) {
            this.reportDiskProblem("could not set file writeable " + this.getSaveFile().getParentFile());
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        File file = this.getSaveFile();
        file.delete();
        try {
            file = this.getSuggestedSaveLocation(file, this.incompleteFile);
        }
        catch (IOException iOException) {
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        boolean bl = FileUtils.forceRename(this.incompleteFile, file);
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (!bl) {
            this.reportDiskProblem("forceRename failed " + this.incompleteFile + " -> " + file);
            return Downloader.DownloadStatus.DISK_PROBLEM;
        }
        if (file.exists()) {
            this.fileManager.removeFileIfSharedOrStore(file);
        }
        this.addFileHash(uRN, file);
        this.shareSavedFile(file);
        return Downloader.DownloadStatus.COMPLETE;
    }

    protected File getSuggestedSaveLocation(File file, File file2) throws IOException {
        return file;
    }

    private void addFileHash(URN uRN, File file) {
        if (uRN != null) {
            UrnSet urnSet = new UrnSet(uRN);
            File file2 = file;
            try {
                file2 = FileUtils.getCanonicalFile(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            URN uRN2 = this.saveTreeHash(uRN);
            if (uRN2 != null) {
                urnSet.add(uRN2);
            }
            this.urnCache.addUrns(file2, urnSet);
            this.savedFileManager.addSavedFile(file2, urnSet);
        }
    }

    protected URN saveTreeHash(URN uRN) {
        if (this.getSha1Urn() != null && this.getSha1Urn().equals(uRN) && this.commonOutFile.getHashTree() != null) {
            ((HashTreeCache)this.tigerTreeCache.get()).addHashTree(this.getSha1Urn(), this.commonOutFile.getHashTree());
            return this.commonOutFile.getHashTree().getTreeRootUrn();
        }
        return null;
    }

    protected void shareSavedFile(File file) {
        if (SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
            this.fileManager.addFileAlways(file, this.getXMLDocuments());
        } else {
            this.fileManager.addFileIfShared(file, this.getXMLDocuments());
        }
    }

    private void cleanupCorrupt(File file, String string) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(file);
        boolean bl = false;
        for (int i = 0; i < 10 && !bl; ++i) {
            this.corruptFile = new File(file.getParent(), "CORRUPT-" + i + "-" + string);
            if (this.corruptFile.exists()) continue;
            bl = file.renameTo(this.corruptFile);
        }
        if (!bl) {
            file.delete();
            this.corruptFile = null;
        }
    }

    private void openVerifyingFile() throws IOException {
        try {
            this.commonOutFile.open(this.incompleteFile);
        }
        catch (IOException iOException) {
            IOUtils.handleException(iOException, IOUtils.ErrorType.DOWNLOAD);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker(RemoteFileDesc remoteFileDesc) {
        DownloadWorker downloadWorker = this.downloadWorkerFactory.create(this, remoteFileDesc, this.commonOutFile);
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            this._workers.add(downloadWorker);
            this.currentRFDs.add(remoteFileDesc);
        }
        downloadWorker.start();
    }

    @Override
    public synchronized void workerFinished(DownloadWorker downloadWorker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("worker " + downloadWorker + " finished."));
        }
        this.removeWorker(downloadWorker);
        this.notify();
    }

    @Override
    public synchronized void workerStarted(DownloadWorker downloadWorker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("worker " + downloadWorker + " started."));
        }
        if (!this._workers.contains(downloadWorker)) {
            throw new IllegalStateException("attempting to start invalid worker: " + downloadWorker);
        }
        this.setState(Downloader.DownloadStatus.DOWNLOADING);
        this.addActiveWorker(downloadWorker);
        this.chatList.addHost(downloadWorker.getDownloader());
        this.browseList.addHost(downloadWorker.getDownloader());
    }

    @Override
    public void workerFailed(DownloadWorker downloadWorker) {
        HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
        if (hTTPDownloader != null) {
            this.chatList.removeHost(hTTPDownloader);
            this.browseList.removeHost(hTTPDownloader);
        }
    }

    synchronized void removeWorker(DownloadWorker downloadWorker) {
        boolean bl = this.removeActiveWorker(downloadWorker);
        this.workerFailed(downloadWorker);
        boolean bl2 = this._workers.remove(downloadWorker);
        if (bl && !bl2) {
            throw new IllegalStateException("active removed but not in workers");
        }
    }

    @Override
    public synchronized boolean removeActiveWorker(DownloadWorker downloadWorker) {
        this.currentRFDs.remove(downloadWorker.getRFD());
        ArrayList<DownloadWorker> arrayList = new ArrayList<DownloadWorker>(this.getActiveWorkers());
        boolean bl = arrayList.remove(downloadWorker);
        this._activeWorkers = Collections.unmodifiableList(arrayList);
        return bl;
    }

    synchronized void addActiveWorker(DownloadWorker downloadWorker) {
        if (!this.getActiveWorkers().contains(downloadWorker)) {
            ArrayList<DownloadWorker> arrayList = new ArrayList<DownloadWorker>(this.getActiveWorkers());
            arrayList.add(downloadWorker);
            this._activeWorkers = Collections.unmodifiableList(arrayList);
        }
    }

    synchronized String getWorkersInfo() {
        String string = "";
        for (DownloadWorker downloadWorker : this._workers) {
            string = string + downloadWorker.getInfo();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AlternateLocation> getValidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            Set<AlternateLocation> set;
            if (this.validAlts != null) {
                set = new HashSet();
                for (AlternateLocation alternateLocation : this.validAlts) {
                    set.add(alternateLocation);
                }
            } else {
                set = Collections.emptySet();
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AlternateLocation> getInvalidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            Set<AlternateLocation> set;
            if (this.invalidAlts != null) {
                set = new HashSet();
                for (AlternateLocation alternateLocation : this.recentInvalidAlts) {
                    set.add(alternateLocation);
                }
            } else {
                set = Collections.emptySet();
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Downloader.DownloadStatus fireDownloadWorkers() throws InterruptedException {
        LOG.trace((Object)"MANAGER: entered fireDownloadWorkers");
        while (true) {
            if (this.stopped || this.paused) {
                LOG.warn((Object)"MANAGER: terminating because of stop|pause");
                throw new InterruptedException();
            }
            try {
                this.commonOutFile.waitForPendingIfNeeded();
            }
            catch (DiskException diskException) {
                if (this.stopped || this.paused) {
                    LOG.warn((Object)"MANAGER: terminating because of stop|pause");
                    throw new InterruptedException();
                }
                this.stop();
                this.reportDiskProblem(diskException);
                return Downloader.DownloadStatus.DISK_PROBLEM;
            }
            if (this.commonOutFile.isComplete()) {
                this.killAllWorkers();
                LOG.trace((Object)"MANAGER: terminating because of completion");
                return Downloader.DownloadStatus.COMPLETE;
            }
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                if (this._workers.size() == 0 && !this.ranker.hasNonBusy()) {
                    this.receivedNewSources = false;
                    if (this.ranker.calculateWaitTime() > 0) {
                        LOG.trace((Object)"MANAGER: terminating with busy");
                        return Downloader.DownloadStatus.BUSY;
                    }
                    LOG.trace((Object)"MANAGER: terminating w/o hope");
                    return Downloader.DownloadStatus.GAVE_UP;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MANAGER: kicking off workers.  state: " + (Object)((Object)this.getState()) + ", allWorkers: " + this._workers.size() + ", activeWorkers: " + this._activeWorkers.size() + ", queuedWorkers: " + this._queuedWorkers.size() + ", swarm cap: " + this.getSwarmCapacity()));
                }
                if (this.shouldStartWorker()) {
                    this.ranker = this.getSourceRanker(this.ranker);
                    RemoteFileDesc remoteFileDesc = this.ranker.getBest();
                    if (remoteFileDesc != null) {
                        if (remoteFileDesc.isBusy()) {
                            this.addRFD(remoteFileDesc);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Staring worker for RFD: " + remoteFileDesc));
                            }
                            this.startWorker(remoteFileDesc);
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"no blocks but can't steal - sleeping.");
                }
                try {
                    this.wait(DownloadSettings.WORKER_INTERVAL.getValue());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected SourceRanker getSourceRanker(SourceRanker sourceRanker) {
        return this.sourceRankerFactory.getAppropriateRanker(sourceRanker);
    }

    private boolean shouldStartWorker() {
        return (this.commonOutFile.hasFreeBlocksToAssign() > 0L || this.victimsExist()) && this._workers.size() - this._queuedWorkers.size() < this.getSwarmCapacity() && this.ranker.hasMore();
    }

    private boolean victimsExist() {
        if (this._workers.isEmpty()) {
            return false;
        }
        for (DownloadWorker downloadWorker : this._workers) {
            if (downloadWorker.isStealing() || !downloadWorker.isSlow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addRFD(RemoteFileDesc remoteFileDesc) {
        if (this.ranker != null) {
            this.ranker.addToPool(remoteFileDesc);
        }
    }

    @Override
    public synchronized void forgetRFD(RemoteFileDesc remoteFileDesc) {
        if (this.cachedRFDs.remove(remoteFileDesc) && this.cachedRFDs.isEmpty()) {
            remoteFileDesc.setSerializeProxies();
            this.cachedRFDs.add(remoteFileDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            if (this.validAlts == null) {
                return 0;
            }
            return this.validAlts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfInvalidAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            if (this.invalidAlts == null) {
                return 0;
            }
            return this.invalidAlts.size();
        }
    }

    @Override
    public synchronized int getPossibleHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumKnownHosts();
    }

    @Override
    public synchronized int getBusyHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumBusyHosts();
    }

    @Override
    public synchronized int getQueuedHostCount() {
        return this._queuedWorkers.size();
    }

    int getSwarmCapacity() {
        int n = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (n <= 56) {
            return 2;
        }
        if (n <= 1000) {
            return 8;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            if (this.corruptState == 0) {
                this.corruptState = 1;
                this.sendCorruptCallback();
            }
        }
    }

    protected void sendCorruptCallback() {
        this.downloadCallback.promptAboutCorruptDownload(this);
    }

    @Override
    public void discardCorruptDownload(final boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User chose to delete corrupt " + bl));
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ManagedDownloaderImpl.this.corruptStateLock;
                synchronized (object) {
                    if (bl) {
                        ManagedDownloaderImpl.this.corruptState = 2;
                    } else {
                        ManagedDownloaderImpl.this.corruptState = 3;
                    }
                }
                if (bl) {
                    ManagedDownloaderImpl.this.stop();
                } else {
                    ManagedDownloaderImpl.this.commonOutFile.setDiscardUnverified(false);
                }
                object = ManagedDownloaderImpl.this.corruptStateLock;
                synchronized (object) {
                    ManagedDownloaderImpl.this.corruptStateLock.notify();
                }
            }
        };
        this.backgroundExecutor.execute(runnable);
    }

    private synchronized List<LimeXMLDocument> getXMLDocuments() {
        ArrayList<LimeXMLDocument> arrayList = new ArrayList<LimeXMLDocument>();
        for (RemoteFileDesc remoteFileDesc : this.cachedRFDs) {
            LimeXMLDocument limeXMLDocument = remoteFileDesc.getXMLDocument();
            if (limeXMLDocument == null) continue;
            arrayList.add(limeXMLDocument);
        }
        return arrayList;
    }

    @Override
    public void setState(Downloader.DownloadStatus downloadStatus) {
        this.setState(downloadStatus, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(Downloader.DownloadStatus downloadStatus, long l) {
        Downloader.DownloadStatus downloadStatus2 = null;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            downloadStatus2 = this.state;
            this.state = downloadStatus;
            this.stateTime = System.currentTimeMillis() + l;
        }
        if (downloadStatus2 != downloadStatus) {
            this.fireEventLater(downloadStatus);
        }
    }

    synchronized boolean setStateIfExistingStateIs(Downloader.DownloadStatus downloadStatus, Downloader.DownloadStatus downloadStatus2) {
        if (this.getState() == downloadStatus2) {
            this.setState(downloadStatus);
            return true;
        }
        return false;
    }

    @Override
    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    @Override
    public synchronized Downloader.DownloadStatus getState() {
        return this.state;
    }

    @Override
    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case BUSY: 
            case WAITING_FOR_CONNECTIONS: 
            case ITERATIVE_GUESSING: 
            case CONNECTING: {
                long l = this.stateTime - System.currentTimeMillis();
                return (int)Math.ceil((float)Math.max(l, 0L) / 1000.0f);
            }
            case QUERYING_DHT: 
            case WAITING_FOR_GNET_RESULTS: {
                return (int)Math.ceil((float)Math.max(this.requeryManager.getTimeLeftInQuery(), 0L) / 1000.0f);
            }
            case QUEUED: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected synchronized boolean hasRFD() {
        return this.cachedRFDs != null && !this.cachedRFDs.isEmpty();
    }

    @Override
    public synchronized long getContentLength() {
        return this.contentLength;
    }

    protected synchronized void setContentLength(long l) {
        this.contentLength = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountRead() {
        VerifyingFile verifyingFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            if (this.state == Downloader.DownloadStatus.CORRUPT_FILE) {
                return this.corruptFileBytes;
            }
            if (this.state == Downloader.DownloadStatus.HASHING) {
                if (this.incompleteFile == null) {
                    return 0L;
                }
                return URN.getHashingProgress(this.incompleteFile);
            }
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile == null ? 0L : verifyingFile.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAmountPending() {
        VerifyingFile verifyingFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            verifyingFile = this.commonOutFile;
        }
        return (int)(verifyingFile == null ? 0L : verifyingFile.getPendingSize());
    }

    @Override
    public int getNumHosts() {
        return this._activeWorkers.size();
    }

    @Override
    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    @Override
    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    @Override
    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    @Override
    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    @Override
    public synchronized int getQueuePosition() {
        return this.queuePosition;
    }

    @Override
    public int getNumDownloaders() {
        return this.getActiveWorkers().size() + this.getQueuedWorkers().size();
    }

    @Override
    public List<DownloadWorker> getActiveWorkers() {
        return this._activeWorkers;
    }

    @Override
    public synchronized List<DownloadWorker> getAllWorkers() {
        return new ArrayList<DownloadWorker>(this._workers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueuedWorker(DownloadWorker downloadWorker) {
        if (this.getQueuedWorkers().containsKey(downloadWorker)) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                HashMap<DownloadWorker, Integer> hashMap = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
                hashMap.remove(downloadWorker);
                this._queuedWorkers = Collections.unmodifiableMap(hashMap);
            }
        }
    }

    private synchronized void addQueuedWorker(DownloadWorker downloadWorker, int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding queued worker " + downloadWorker + " at position " + n + " current queued workers:\n" + this._queuedWorkers));
        }
        if (!this._workers.contains(downloadWorker)) {
            throw new IllegalStateException("attempting to queue invalid worker: " + downloadWorker);
        }
        if (n < this.queuePosition) {
            this.queuePosition = n;
            this.queuedVendor = downloadWorker.getDownloader().getVendor();
        }
        HashMap<DownloadWorker, Integer> hashMap = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
        hashMap.put(downloadWorker, new Integer(n));
        this._queuedWorkers = Collections.unmodifiableMap(hashMap);
    }

    @Override
    public Map<DownloadWorker, Integer> getQueuedWorkers() {
        return this._queuedWorkers;
    }

    int getWorkerQueuePosition(DownloadWorker downloadWorker) {
        Integer n = this.getQueuedWorkers().get(downloadWorker);
        return n == null ? -1 : n;
    }

    @Override
    public synchronized boolean killQueuedIfNecessary(DownloadWorker downloadWorker, int n) {
        int n2;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deciding whether to kill a queued host for (" + n + ") worker " + downloadWorker));
        }
        DownloadWorker downloadWorker2 = null;
        int n3 = this.getNumDownloaders();
        if (n3 <= (n2 = this.getSwarmCapacity()) && n == -1) {
            return true;
        }
        if (this._queuedWorkers.containsKey(downloadWorker) && n > -1) {
            this.addQueuedWorker(downloadWorker, n);
            return true;
        }
        if (n3 >= n2) {
            int n4 = n;
            for (Map.Entry<DownloadWorker, Integer> entry : this._queuedWorkers.entrySet()) {
                int n5 = entry.getValue();
                if (n5 <= n4) continue;
                downloadWorker2 = entry.getKey();
                n4 = n5;
            }
            if (downloadWorker2 == null) {
                LOG.debug((Object)"not queueing myself");
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("will replace " + downloadWorker2));
            }
            downloadWorker2.interrupt();
        }
        if (n > -1) {
            this.addQueuedWorker(downloadWorker, n);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hashTreeRead(HashTree hashTree) {
        HTTPHeaderValue hTTPHeaderValue;
        boolean bl = false;
        Object object = this.commonOutFile;
        synchronized (object) {
            this.commonOutFile.setHashTreeRequested(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Downloaded tree: " + hashTree));
            }
            if (hashTree != null && hashTree.isBetterTree((HashTree)(hTTPHeaderValue = this.commonOutFile.getHashTree()))) {
                bl = this.commonOutFile.setHashTree(hashTree);
            }
        }
        if (bl && hashTree != null) {
            object = this.getSha1Urn();
            hTTPHeaderValue = hashTree.getTreeRootUrn();
            ((HashTreeCache)this.tigerTreeCache.get()).addRoot((URN)object, (URN)hTTPHeaderValue);
            FileManager fileManager = this.fileManager;
            synchronized (fileManager) {
                FileDesc fileDesc = this.fileManager.getFileDescForUrn((URN)object);
                if (fileDesc == null) {
                    return;
                }
                if (fileDesc.setTTRoot((URN)hTTPHeaderValue)) {
                    this.fileManager.fileURNSUpdated(fileDesc);
                }
            }
        }
    }

    @Override
    public synchronized String getVendor() {
        List<DownloadWorker> list = this.getActiveWorkers();
        if (list.size() > 0) {
            HTTPDownloader hTTPDownloader = list.get(0).getDownloader();
            return hTTPDownloader.getVendor();
        }
        if (this.getState() == Downloader.DownloadStatus.REMOTE_QUEUED) {
            return this.queuedVendor;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void measureBandwidth() {
        float f = 0.0f;
        boolean bl = false;
        for (DownloadWorker downloadWorker : this.getActiveWorkers()) {
            bl = true;
            HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
            hTTPDownloader.measureBandwidth();
            f += hTTPDownloader.getAverageBandwidth();
        }
        if (bl) {
            ManagedDownloaderImpl managedDownloaderImpl = this;
            synchronized (managedDownloaderImpl) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
            }
        }
    }

    @Override
    public float getMeasuredBandwidth() {
        float f = 0.0f;
        for (DownloadWorker downloadWorker : this.getActiveWorkers()) {
            HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
            float f2 = 0.0f;
            try {
                f2 = hTTPDownloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    @Override
    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountVerified() {
        VerifyingFile verifyingFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile == null ? 0L : verifyingFile.getVerifiedBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountLost() {
        VerifyingFile verifyingFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile == null ? 0L : verifyingFile.getAmountLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChunkSize() {
        VerifyingFile verifyingFile;
        ManagedDownloaderImpl managedDownloaderImpl = this;
        synchronized (managedDownloaderImpl) {
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile != null ? verifyingFile.getChunkSize() : 131072;
    }

    private boolean checkHosts() {
        String string = "LimeWire";
        return string.hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    @Override
    public synchronized void incrementTriedHostsCount() {
        ++this.triedHosts;
    }

    @Override
    public int getTriedHostCount() {
        return this.triedHosts;
    }

    @Override
    public String getCustomIconDescriptor() {
        return null;
    }

    @Override
    public DownloaderType getDownloadType() {
        return DownloaderType.MANAGED;
    }

    protected synchronized void setIncompleteFile(File file) {
        this.incompleteFile = file;
    }

    protected synchronized File getIncompleteFile() {
        return this.incompleteFile;
    }

    @Override
    protected DownloadMemento createMemento() {
        return new GnutellaDownloadMementoImpl();
    }

    @Override
    public synchronized void initFromMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        super.initFromMemento(downloadMemento);
        GnutellaDownloadMemento gnutellaDownloadMemento = (GnutellaDownloadMemento)downloadMemento;
        this.setContentLength(gnutellaDownloadMemento.getContentLength());
        if (gnutellaDownloadMemento.getSha1Urn() != null) {
            this.setSha1Urn(gnutellaDownloadMemento.getSha1Urn());
        }
        this.setIncompleteFile(gnutellaDownloadMemento.getIncompleteFile());
        if (gnutellaDownloadMemento.getRemoteHosts().isEmpty() && gnutellaDownloadMemento.getDefaultFileName() == null) {
            throw new InvalidDataException("must have a name!");
        }
        this.addInitialSources(this.toRfds(gnutellaDownloadMemento.getRemoteHosts()), gnutellaDownloadMemento.getDefaultFileName());
        if (this.getIncompleteFile() != null) {
            this.incompleteFileManager.initEntry(this.getIncompleteFile(), gnutellaDownloadMemento.getSavedBlocks(), this.getSha1Urn(), this.shouldPublishIFD());
        }
    }

    protected boolean shouldPublishIFD() {
        return true;
    }

    @Override
    protected void fillInMemento(DownloadMemento downloadMemento) {
        GnutellaDownloadMemento gnutellaDownloadMemento = (GnutellaDownloadMemento)downloadMemento;
        super.fillInMemento(gnutellaDownloadMemento);
        gnutellaDownloadMemento.setContentLength(this.getContentLength());
        gnutellaDownloadMemento.setSha1Urn(this.getSha1Urn());
        if (this.commonOutFile != null) {
            gnutellaDownloadMemento.setSavedBlocks(this.commonOutFile.getSerializableBlocks());
        }
        gnutellaDownloadMemento.setIncompleteFile(this.getIncompleteFile());
        gnutellaDownloadMemento.setRemoteHosts(this.getRemoteHostMementos());
    }

    private Set<RemoteHostMemento> getRemoteHostMementos() {
        HashSet<RemoteHostMemento> hashSet = new HashSet<RemoteHostMemento>(this.cachedRFDs.size());
        for (RemoteFileDesc remoteFileDesc : this.cachedRFDs) {
            hashSet.add(remoteFileDesc.toMemento());
        }
        return hashSet;
    }

    private Collection<RemoteFileDesc> toRfds(Collection<? extends RemoteHostMemento> collection) throws InvalidDataException {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(collection.size());
        for (RemoteHostMemento remoteHostMemento : collection) {
            arrayList.add(this.remoteFileDescFactory.createFromMemento(remoteHostMemento));
        }
        return arrayList;
    }

    Set<RemoteFileDesc> getCachedRFDs() {
        return this.cachedRFDs;
    }

    private void fireEventLater(final Downloader.DownloadStatus downloadStatus) {
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                ManagedDownloaderImpl.this.listeners.broadcast(new DownloadStatusEvent(ManagedDownloaderImpl.this, downloadStatus));
            }
        });
    }

    @Override
    public void addListener(EventListener<DownloadStatusEvent> eventListener) {
        this.listeners.addListener(eventListener);
    }

    @Override
    public boolean removeListener(EventListener<DownloadStatusEvent> eventListener) {
        return this.listeners.removeListener(eventListener);
    }

    protected SourceRanker getSourceRanker() {
        return this.ranker;
    }

    @Override
    public synchronized String getActiveHostAddresses() {
        StringBuffer stringBuffer = new StringBuffer();
        for (RemoteFileDesc remoteFileDesc : this.currentRFDs) {
            if (!remoteFileDesc.isBrowseHostEnabled()) continue;
            stringBuffer.append(remoteFileDesc.getAddress());
            stringBuffer.append(":");
            stringBuffer.append(remoteFileDesc.getPort());
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    @Override
    public synchronized int getActiveHostCount() {
        return this._activeWorkers.size();
    }

    @Override
    public boolean canceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.stop();
    }

    private class RequeryListenerImpl
    implements RequeryListener {
        private RequeryListenerImpl() {
        }

        public QueryRequest createQuery() {
            try {
                return ManagedDownloaderImpl.this.newRequery();
            }
            catch (CantResumeException cantResumeException) {
                return null;
            }
        }

        public URN getSHA1Urn() {
            return ManagedDownloaderImpl.this.getSha1Urn();
        }

        public void lookupFinished(RequeryManager.QueryType queryType) {
            switch (queryType) {
                case DHT: {
                    ManagedDownloaderImpl.this.setStateIfExistingStateIs(Downloader.DownloadStatus.GAVE_UP, Downloader.DownloadStatus.QUERYING_DHT);
                    break;
                }
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.GAVE_UP);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }

        public void lookupPending(RequeryManager.QueryType queryType, int n) {
            switch (queryType) {
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.WAITING_FOR_CONNECTIONS, n);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }

        public void lookupStarted(RequeryManager.QueryType queryType, long l) {
            switch (queryType) {
                case DHT: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.QUERYING_DHT, l);
                    break;
                }
                case GNUTELLA: {
                    ManagedDownloaderImpl.this.setState(Downloader.DownloadStatus.WAITING_FOR_GNET_RESULTS, l);
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid type: " + (Object)((Object)queryType));
                }
            }
        }
    }
}

