/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyRanker
extends AbstractSourceRanker {
    private static final Log LOG = LogFactory.getLog(LegacyRanker.class);
    private final Set<RemoteFileDesc> rfds = new HashSet<RemoteFileDesc>();

    @Override
    public synchronized boolean addToPool(RemoteFileDesc remoteFileDesc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding host " + remoteFileDesc + " to be ranked"));
        }
        return this.rfds.add(remoteFileDesc);
    }

    @Override
    public synchronized RemoteFileDesc getBest() {
        if (!this.hasMore()) {
            return null;
        }
        RemoteFileDesc remoteFileDesc = LegacyRanker.getBest(this.rfds.iterator());
        boolean bl = this.rfds.remove(remoteFileDesc);
        assert (bl) : "unable to remove RFD.";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("the best we came with is " + remoteFileDesc));
        }
        return remoteFileDesc;
    }

    static RemoteFileDesc getBest(Iterator<RemoteFileDesc> iterator) {
        RemoteFileDesc remoteFileDesc = iterator.next();
        long l = System.currentTimeMillis();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc2 = iterator.next();
            if (remoteFileDesc2.isBusy(l)) continue;
            if (remoteFileDesc.isBusy(l)) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getSHA1Urn() != null && remoteFileDesc.getSHA1Urn() == null) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getSHA1Urn() == null != (remoteFileDesc.getSHA1Urn() == null)) continue;
            if (remoteFileDesc2.getQuality() > remoteFileDesc.getQuality()) {
                remoteFileDesc = remoteFileDesc2;
                continue;
            }
            if (remoteFileDesc2.getQuality() != remoteFileDesc.getQuality() || remoteFileDesc2.getSpeed() <= remoteFileDesc.getSpeed()) continue;
            remoteFileDesc = remoteFileDesc2;
        }
        return remoteFileDesc;
    }

    @Override
    public boolean hasMore() {
        return !this.rfds.isEmpty();
    }

    @Override
    public Collection<RemoteFileDesc> getShareableHosts() {
        return this.rfds;
    }

    @Override
    protected Collection<RemoteFileDesc> getPotentiallyBusyHosts() {
        return this.rfds;
    }

    @Override
    public int getNumKnownHosts() {
        return this.rfds.size();
    }
}

