/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.BandwidthManager;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HTTPDownloaderFactory;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.tigertree.ThexReaderFactory;
import java.net.Socket;
import org.limewire.io.NetworkInstanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HTTPDownloaderFactoryImpl
implements HTTPDownloaderFactory {
    private final NetworkManager networkManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final DownloadManager downloadManager;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final BandwidthManager bandwidthManager;
    private final Provider<PushEndpointCache> pushEndpointCache;
    private final PushEndpointFactory pushEndpointFactory;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private final ThexReaderFactory thexReaderFactory;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HTTPDownloaderFactoryImpl(NetworkManager networkManager, AlternateLocationFactory alternateLocationFactory, DownloadManager downloadManager, Provider<CreationTimeCache> provider, BandwidthManager bandwidthManager, Provider<PushEndpointCache> provider2, PushEndpointFactory pushEndpointFactory, RemoteFileDescFactory remoteFileDescFactory, ThexReaderFactory thexReaderFactory, TcpBandwidthStatistics tcpBandwidthStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.downloadManager = downloadManager;
        this.creationTimeCache = provider;
        this.bandwidthManager = bandwidthManager;
        this.pushEndpointCache = provider2;
        this.pushEndpointFactory = pushEndpointFactory;
        this.remoteFileDescFactory = remoteFileDescFactory;
        this.thexReaderFactory = thexReaderFactory;
        this.tcpBandwidthStatistics = tcpBandwidthStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public HTTPDownloader create(Socket socket, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, boolean bl) {
        return new HTTPDownloader(socket, remoteFileDesc, verifyingFile, bl, true, this.networkManager, this.alternateLocationFactory, this.downloadManager, (CreationTimeCache)this.creationTimeCache.get(), this.bandwidthManager, this.pushEndpointCache, this.pushEndpointFactory, this.remoteFileDescFactory, this.thexReaderFactory, this.tcpBandwidthStatistics, this.networkInstanceUtils);
    }
}

