/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Provider;
import com.limegroup.gnutella.AssertFailure;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.ConnectionStatus;
import com.limegroup.gnutella.downloader.ContentUrnMismatchException;
import com.limegroup.gnutella.downloader.DownloadState;
import com.limegroup.gnutella.downloader.DownloadStatsTracker;
import com.limegroup.gnutella.downloader.DownloadWorkerSupport;
import com.limegroup.gnutella.downloader.FileNotFoundException;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.HTTPDownloaderFactory;
import com.limegroup.gnutella.downloader.NoSuchRangeException;
import com.limegroup.gnutella.downloader.NotSharingException;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.QueuedException;
import com.limegroup.gnutella.downloader.RangeNotAvailableException;
import com.limegroup.gnutella.downloader.TryAgainLaterException;
import com.limegroup.gnutella.downloader.UnknownCodeException;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.http.ProblemReadingHeaderException;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.MultiShutdownable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.io.IOUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.statemachine.IOStateObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadWorker {
    private static final Log LOG = LogFactory.getLog(DownloadWorker.class);
    private static final int MIN_SPLIT_SIZE = 16384;
    private static final float MIN_ACCEPTABLE_SPEED = DownloadSettings.MAX_DOWNLOAD_BYTES_PER_SEC.getValue() < 8 ? 0.1f : 0.5f;
    private static final int UNKNOWN_SPEED = -1;
    private static int NORMAL_CONNECT_TIME = 10000;
    private static int PUSH_CONNECT_TIME = 20000;
    private static final int UDP_PUSH_CONNECT_TIME = 6000;
    private static final int NO_RANGES_RETRY_AFTER = 300;
    private static final int FAILED_RETRY_AFTER = 60;
    public static final int RETRY_AFTER_NONE_ACTIVE = 60;
    private static final int RETRY_AFTER_SOME_ACTIVE = 600;
    private final DownloadWorkerSupport _manager;
    private final RemoteFileDesc _rfd;
    private final VerifyingFile _commonOutFile;
    private final DownloadStatsTracker statsTracker;
    private final AtomicBoolean _interrupted = new AtomicBoolean(false);
    private volatile HTTPDownloader _downloader;
    private volatile boolean _shouldRelease;
    private final String _workerName;
    private DirectConnector _connectObserver;
    private DownloadState _currentState;
    private volatile boolean _stealing;
    private final HTTPDownloaderFactory httpDownloaderFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private final ScheduledExecutorService nioExecutor;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final SocketsManager socketsManager;

    protected DownloadWorker(DownloadWorkerSupport downloadWorkerSupport, RemoteFileDesc remoteFileDesc, VerifyingFile verifyingFile, HTTPDownloaderFactory hTTPDownloaderFactory, ScheduledExecutorService scheduledExecutorService, ScheduledExecutorService scheduledExecutorService2, Provider<PushDownloadManager> provider, SocketsManager socketsManager, DownloadStatsTracker downloadStatsTracker) {
        this.httpDownloaderFactory = hTTPDownloaderFactory;
        this.backgroundExecutor = scheduledExecutorService;
        this.nioExecutor = scheduledExecutorService2;
        this.pushDownloadManager = provider;
        this.socketsManager = socketsManager;
        this._manager = downloadWorkerSupport;
        this._rfd = remoteFileDesc;
        this._commonOutFile = verifyingFile;
        this.statsTracker = downloadStatsTracker;
        this._currentState = new DownloadState();
        this._workerName = LOG.isDebugEnabled() ? "DownloadWorker for " + this._manager.getSaveFile().getName() + " #" + System.identityHashCode(this) : "DownloaderWorker";
    }

    public void start() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting worker: " + this._workerName));
        }
        this.establishConnection();
    }

    private void initializeAlternateLocations() {
        int n = 0;
        for (AlternateLocation alternateLocation : this._manager.getValidAlts()) {
            if (n++ >= 10) break;
            this._downloader.addSuccessfulAltLoc(alternateLocation);
        }
        n = 0;
        for (AlternateLocation alternateLocation : this._manager.getInvalidAlts()) {
            if (n++ >= 10) break;
            this._downloader.addFailedAltLoc(alternateLocation);
        }
    }

    private void httpLoop() {
        LOG.debug((Object)"Starting HTTP Loop");
        this.incrementState(null);
    }

    public void incrementState(ConnectionStatus connectionStatus) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("WORKER: " + this + ", State Changed, Current: " + this._currentState + ", status: " + connectionStatus));
        }
        if (this._interrupted.get()) {
            this.finishHttpLoop();
            return;
        }
        switch (this._currentState.getCurrentState()) {
            case 6: {
                this.releaseRanges();
            }
            case 0: 
            case 5: {
                this._currentState.setHttp11(this._rfd.isHTTP11());
                this._currentState.setState(1);
                if (this.requestTHEXIfNeeded()) break;
            }
            case 1: {
                this._currentState.setState(2);
                if (this.downloadThexIfNeeded()) break;
            }
            case 2: {
                this._currentState.setState(3);
                if (this.consumeBodyIfNeeded()) break;
            }
            case 3: {
                this._downloader.forgetRanges();
                if (connectionStatus == null || !connectionStatus.isQueued()) {
                    this._currentState.setState(4);
                    if (this.assignAndRequest()) break;
                    this.finishHttpLoop();
                    break;
                }
            }
            case 4: {
                this.httpRequestFinished(connectionStatus);
                break;
            }
            default: {
                throw new IllegalStateException("bad state: " + this._currentState);
            }
        }
    }

    private boolean consumeBodyIfNeeded() {
        if (this._downloader.isBodyConsumed()) {
            LOG.debug((Object)"Not consuming body.");
            return false;
        }
        this._downloader.consumeBody(new State(){

            protected void handleState(boolean bl) {
                if (!bl) {
                    DownloadWorker.this.handleRFDFailure();
                }
            }
        });
        return true;
    }

    private void handleRFDFailure() {
        this._rfd.incrementFailedCount();
        LOG.debug((Object)("handling rfd failure for " + this._rfd + " with count now " + this._rfd.getFailedCount()));
        if (this._rfd.getFailedCount() < 2) {
            LOG.debug((Object)"will try again in a minute");
            this._rfd.setRetryAfter(60);
            this._manager.addRFD(this._rfd);
        } else {
            this._manager.informMesh(this._rfd, false);
        }
    }

    private void httpRequestFinished(ConnectionStatus connectionStatus) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HTTP req finished, status: " + connectionStatus));
        }
        this._manager.addPossibleSources(this._downloader.getLocationsReceived());
        if (connectionStatus.isNoData() || connectionStatus.isNoFile()) {
            this.finishHttpLoop();
        } else {
            if (!connectionStatus.isConnected()) {
                this.releaseRanges();
            }
            if (!connectionStatus.isQueued()) {
                this._manager.removeQueuedWorker(this);
            }
            if (connectionStatus.isPartialData()) {
                this._currentState.setState(0);
                this.incrementState(null);
            } else {
                assert (connectionStatus.isQueued() || connectionStatus.isConnected());
                boolean bl = this._manager.killQueuedIfNecessary(this, !connectionStatus.isQueued() ? -1 : connectionStatus.getQueuePosition());
                if (connectionStatus.isConnected()) {
                    this._currentState.setState(6);
                    this.beginDownload();
                } else if (!bl) {
                    this.finishHttpLoop();
                } else {
                    this.handleQueued(connectionStatus);
                }
            }
        }
    }

    private void beginDownload() {
        try {
            this._downloader.doDownload(new State(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void handleState(boolean bl) {
                    if (bl) {
                        DownloadWorker.this._rfd.resetFailedCount();
                    } else {
                        DownloadWorker.this._manager.workerFailed(DownloadWorker.this);
                    }
                    if (DownloadWorker.this._commonOutFile.isHopeless()) {
                        DownloadWorker.this._manager.promptAboutCorruptDownload();
                    }
                    long l = DownloadWorker.this._downloader.getInitialReadingPoint() + DownloadWorker.this._downloader.getAmountRead();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: terminating from " + DownloadWorker.this._downloader + " at " + l + " error? " + !bl));
                    }
                    DownloadWorkerSupport downloadWorkerSupport = DownloadWorker.this._manager;
                    synchronized (downloadWorkerSupport) {
                        if (!bl) {
                            DownloadWorker.this._downloader.stop();
                            DownloadWorker.this.handleRFDFailure();
                        } else {
                            DownloadWorker.this._manager.informMesh(DownloadWorker.this._rfd, true);
                            if (!DownloadWorker.this._currentState.isHttp11()) {
                                DownloadWorker.this._manager.addRFD(DownloadWorker.this._rfd);
                            }
                        }
                    }
                }
            });
        }
        catch (SocketException socketException) {
            this.finishHttpLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestTHEXIfNeeded() {
        boolean bl = false;
        VerifyingFile verifyingFile = this._commonOutFile;
        synchronized (verifyingFile) {
            if (!this._commonOutFile.isHashTreeRequested()) {
                HashTree hashTree = this._commonOutFile.getHashTree();
                boolean bl2 = bl = this._downloader.hasHashTree() && this._manager.getSha1Urn() != null && (hashTree == null || !hashTree.isDepthGoodEnough());
                if (bl) {
                    this._commonOutFile.setHashTreeRequested(true);
                }
            }
        }
        if (bl) {
            this._downloader.requestHashTree(this._manager.getSha1Urn(), new State(){

                protected void handleState(boolean bl) {
                }
            });
        }
        return bl;
    }

    private boolean downloadThexIfNeeded() {
        if (!this._downloader.isRequestingThex()) {
            return false;
        }
        ConnectionStatus connectionStatus = this._downloader.parseThexResponseHeaders();
        if (!connectionStatus.isConnected()) {
            this._rfd.setTHEXFailed();
            this.incrementState(connectionStatus);
        } else {
            this._manager.removeQueuedWorker(this);
            this._downloader.downloadThexBody(this._manager.getSha1Urn(), new State(){

                protected void handleState(boolean bl) {
                    HashTree hashTree = DownloadWorker.this._downloader.getHashTree();
                    DownloadWorker.this._manager.hashTreeRead(hashTree);
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRanges() {
        long l;
        long l2;
        HTTPDownloader hTTPDownloader;
        if (!this._shouldRelease) {
            return;
        }
        this._shouldRelease = false;
        if (this._commonOutFile.isComplete()) {
            return;
        }
        HTTPDownloader hTTPDownloader2 = hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader2) {
            l2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead();
            l2 = Math.max(l2, hTTPDownloader.getInitialWritingPoint());
            l = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead() - 1L;
        }
        if (l - l2 >= 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("releasing ranges " + Range.createRange(l2, l)));
            }
            try {
                this._commonOutFile.releaseBlock(Range.createRange(l2, l));
            }
            catch (AssertFailure assertFailure) {
                hTTPDownloader.createAssertionReport(assertFailure);
            }
            hTTPDownloader.forgetRanges();
        } else {
            LOG.debug((Object)"nothing to release!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQueued(ConnectionStatus connectionStatus) {
        this._manager.removeActiveWorker(this);
        DownloadState downloadState = this._currentState;
        synchronized (downloadState) {
            if (this._interrupted.get()) {
                LOG.debug((Object)"Exiting from queueing");
                return;
            }
            LOG.debug((Object)"Queueing");
            this._currentState.setState(5);
        }
        this.backgroundExecutor.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LOG.debug((Object)"Queue time up");
                DownloadState downloadState = DownloadWorker.this._currentState;
                synchronized (downloadState) {
                    if (DownloadWorker.this._interrupted.get()) {
                        LOG.warn((Object)("WORKER: interrupted while waiting in queue " + DownloadWorker.this._downloader));
                        return;
                    }
                }
                DownloadWorker.this.nioExecutor.execute(new Runnable(){

                    public void run() {
                        DownloadWorker.this.incrementState(null);
                    }
                });
            }
        }, (long)connectionStatus.getQueuePollTime(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishConnection() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("establishConnection(" + this._rfd + ")"));
        }
        if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted.get()) {
            this._manager.addRFD(this._rfd);
            this.finishWorker();
            return;
        }
        boolean bl = this._rfd.needsPush(this.statsTracker);
        DownloadWorkerSupport downloadWorkerSupport = this._manager;
        synchronized (downloadWorkerSupport) {
            Downloader.DownloadStatus downloadStatus = this._manager.getState();
            if (this._manager.getNumDownloaders() == 0 && downloadStatus != Downloader.DownloadStatus.COMPLETE && downloadStatus != Downloader.DownloadStatus.ABORTED && downloadStatus != Downloader.DownloadStatus.GAVE_UP && downloadStatus != Downloader.DownloadStatus.DISK_PROBLEM && downloadStatus != Downloader.DownloadStatus.CORRUPT_FILE && downloadStatus != Downloader.DownloadStatus.HASHING && downloadStatus != Downloader.DownloadStatus.SAVING) {
                if (this._interrupted.get()) {
                    return;
                }
                this._manager.setState(Downloader.DownloadStatus.CONNECTING);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WORKER: attempting connect to " + this._rfd.getHost() + ":" + this._rfd.getPort()));
        }
        this._manager.incrementTriedHostsCount();
        if (this._rfd.isReplyToMulticast()) {
            this.connectWithPush(new PushConnector(false, true));
        } else if (!bl) {
            this.connectDirectly(new DirectConnector(true));
        } else {
            this.connectWithPush(new PushConnector(true, false));
        }
    }

    private boolean finishConnect() {
        if (this._downloader == null) {
            this._manager.informMesh(this._rfd, false);
            return false;
        }
        if (this._interrupted.get()) {
            this._downloader.stop();
            this._downloader = null;
            return false;
        }
        return true;
    }

    private void connectDirectly(DirectConnector directConnector) {
        if (!this._interrupted.get()) {
            SocketsManager.ConnectType connectType;
            SocketsManager.ConnectType connectType2 = connectType = this._rfd.isTLSCapable() && SSLSettings.isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WORKER: attempt asynchronous direct connection w/ " + (Object)((Object)connectType) + " to: " + this._rfd));
            }
            this._connectObserver = directConnector;
            try {
                Socket socket = this.socketsManager.connect(new InetSocketAddress(this._rfd.getHost(), this._rfd.getPort()), NORMAL_CONNECT_TIME, directConnector, connectType);
                if (!directConnector.isShutdown()) {
                    directConnector.setSocket(socket);
                }
            }
            catch (IOException iOException) {
                directConnector.shutdown();
            }
        } else {
            this.finishWorker();
        }
    }

    private void connectWithPush(PushConnector pushConnector) {
        if (!this._interrupted.get()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("WORKER: attempt push connection to: " + this._rfd + " proxies " + this._rfd.getPushProxies()));
            }
            this._connectObserver = null;
            final PushDetails pushDetails = new PushDetails(this._rfd.getClientGUID(), this._rfd.getHost());
            pushConnector.setPushDetails(pushDetails);
            this._manager.registerPushObserver(pushConnector, pushDetails);
            ((PushDownloadManager)this.pushDownloadManager.get()).sendPush(this._rfd, pushConnector);
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    DownloadWorker.this._manager.unregisterPushObserver(pushDetails, true);
                }
            }, this._rfd.isFromAlternateLocation() ? 6000L : (long)PUSH_CONNECT_TIME, TimeUnit.MILLISECONDS);
        } else {
            this.finishWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInfo() {
        if (this._downloader != null) {
            HTTPDownloader hTTPDownloader = this._downloader;
            synchronized (hTTPDownloader) {
                return this + "hashcode " + System.identityHashCode(this._downloader) + " will release? " + this._shouldRelease + " interrupted? " + this._interrupted.get() + " active? " + this._downloader.isActive() + " victim? " + this._downloader.isVictim() + " initial reading " + this._downloader.getInitialReadingPoint() + " initial writing " + this._downloader.getInitialWritingPoint() + " amount to read " + this._downloader.getAmountToRead() + " amount read " + this._downloader.getAmountRead() + " is in stealing " + this.isStealing() + "\n";
            }
        }
        return "worker not started";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignAndRequest() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("assignAndRequest for: " + this._rfd));
        }
        Range range = null;
        try {
            VerifyingFile verifyingFile = this._commonOutFile;
            synchronized (verifyingFile) {
                if (this._commonOutFile.hasFreeBlocksToAssign() > 0L) {
                    range = this.pickAvailableInterval();
                }
            }
        }
        catch (NoSuchRangeException noSuchRangeException) {
            this.handleNoRanges();
            return false;
        }
        if (range == null) {
            if (!this.assignGrey()) {
                return false;
            }
        } else {
            this.assignWhite(range);
        }
        return true;
    }

    private void completeAssignAndRequest(IOException iOException, Range range, DownloadWorker downloadWorker) {
        ConnectionStatus connectionStatus = this.completeAssignAndRequestImpl(iOException, range, downloadWorker);
        if (downloadWorker != null) {
            downloadWorker.setStealing(false);
            this.setStealing(false);
        }
        this.incrementState(connectionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus completeAssignAndRequestImpl(IOException iOException, Range range, DownloadWorker downloadWorker) {
        try {
            try {
                this._downloader.parseHeaders();
            }
            finally {
                if (iOException != null) {
                    throw iOException;
                }
            }
            if (downloadWorker == null) {
                this.completeAssignWhite(range);
            } else {
                this.completeAssignGrey(downloadWorker, range);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            LOG.debug((Object)this._downloader, (Throwable)noSuchElementException);
            return this.handleNoMoreDownloaders();
        }
        catch (NoSuchRangeException noSuchRangeException) {
            LOG.debug((Object)this._downloader, (Throwable)noSuchRangeException);
            return this.handleNoRanges();
        }
        catch (TryAgainLaterException tryAgainLaterException) {
            LOG.debug((Object)this._downloader, (Throwable)tryAgainLaterException);
            return this.handleTryAgainLater();
        }
        catch (RangeNotAvailableException rangeNotAvailableException) {
            LOG.debug((Object)this._downloader, (Throwable)rangeNotAvailableException);
            return this.handleRangeNotAvailable();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.debug((Object)this._downloader, (Throwable)fileNotFoundException);
            return this.handleFileNotFound();
        }
        catch (NotSharingException notSharingException) {
            LOG.debug((Object)this._downloader, (Throwable)notSharingException);
            return this.handleNotSharing();
        }
        catch (QueuedException queuedException) {
            LOG.debug((Object)this._downloader, (Throwable)queuedException);
            return this.handleQueued(queuedException.getQueuePosition(), queuedException.getMinPollTime());
        }
        catch (ProblemReadingHeaderException problemReadingHeaderException) {
            LOG.debug((Object)this._downloader, (Throwable)problemReadingHeaderException);
            return this.handleProblemReadingHeader();
        }
        catch (UnknownCodeException unknownCodeException) {
            LOG.debug((Object)this._downloader, (Throwable)unknownCodeException);
            return this.handleUnknownCode();
        }
        catch (ContentUrnMismatchException contentUrnMismatchException) {
            LOG.debug((Object)this._downloader, (Throwable)contentUrnMismatchException);
            return ConnectionStatus.getNoFile();
        }
        catch (IOException iOException2) {
            LOG.debug((Object)this._downloader, (Throwable)iOException2);
            return this.handleIO();
        }
        this._rfd.resetFailedCount();
        DownloadWorkerSupport downloadWorkerSupport = this._manager;
        synchronized (downloadWorkerSupport) {
            if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted.get()) {
                LOG.trace((Object)"Stopped in assignAndRequest");
                this._manager.addRFD(this._rfd);
                return ConnectionStatus.getNoData();
            }
            this._manager.workerStarted(this);
        }
        return ConnectionStatus.getConnected();
    }

    private void assignWhite(Range range) {
        final long l = range.getLow();
        final long l2 = range.getHigh();
        this._shouldRelease = true;
        this._downloader.connectHTTP(l, l2 + 1L, true, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, Range.createRange(l, l2), null);
            }

            public void handleIOException(IOException iOException) {
                DownloadWorker.this.completeAssignAndRequest(iOException, null, null);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignWhite(Range range) {
        HTTPDownloader hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader) {
            long l = range.getLow();
            long l2 = range.getHigh();
            long l3 = this._downloader.getInitialReadingPoint();
            long l4 = this._downloader.getAmountToRead() - 1L + l3;
            if (l4 - l3 >= 0L) {
                if (l3 > l) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: Host gave subrange, different low.  Was: " + l + ", is now: " + l3));
                    }
                    this._commonOutFile.releaseBlock(Range.createRange(l, l3 - 1L));
                }
                if (l4 < l2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("WORKER: Host gave subrange, different high.  Was: " + l2 + ", is now: " + l4));
                    }
                    this._commonOutFile.releaseBlock(Range.createRange(l4 + 1L, l2));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WORKER: assigning white " + l3 + "-" + l4 + " to " + this._downloader));
                }
            } else {
                LOG.debug((Object)"debouched at birth");
            }
        }
    }

    private Range pickAvailableInterval() throws NoSuchRangeException {
        Range range = null;
        if (!this._downloader.getRemoteFileDesc().isPartialSource()) {
            range = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(this.findChunkSize()) : this._commonOutFile.leaseWhite();
        } else {
            try {
                IntervalSet intervalSet = this._downloader.getRemoteFileDesc().getAvailableRanges();
                range = this._currentState.isHttp11() ? this._commonOutFile.leaseWhite(intervalSet, this.findChunkSize()) : this._commonOutFile.leaseWhite(intervalSet);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NoSuchRangeException();
            }
        }
        return range;
    }

    private long findChunkSize() {
        long l = this._commonOutFile.getChunkSize();
        long l2 = this._commonOutFile.hasFreeBlocksToAssign();
        if (l2 <= l && this._manager.getActiveWorkers().size() > 1) {
            l = Math.max(16384L, l2 / 2L);
        }
        return l;
    }

    private boolean assignGrey() {
        if (this.isStealing()) {
            return false;
        }
        if (this._downloader.getRemoteFileDesc().isPartialSource()) {
            this.handleNoRanges();
            return false;
        }
        final DownloadWorker downloadWorker = this.findSlowestDownloader();
        if (downloadWorker == null) {
            LOG.debug((Object)"didn't find anybody to steal from");
            this.handleNoMoreDownloaders();
            return false;
        }
        final Range range = downloadWorker.getDownloadInterval();
        if (range.getLow() == range.getHigh()) {
            this.handleNoMoreDownloaders();
            return false;
        }
        downloadWorker.setStealing(true);
        this.setStealing(true);
        this._downloader.connectHTTP(range.getLow(), range.getHigh(), false, this._commonOutFile.getBlockSize(), new IOStateObserver(){

            public void handleStatesFinished() {
                DownloadWorker.this.completeAssignAndRequest(null, range, downloadWorker);
            }

            public void handleIOException(IOException iOException) {
                DownloadWorker.this.completeAssignAndRequest(iOException, null, downloadWorker);
            }

            public void shutdown() {
                DownloadWorker.this.completeAssignAndRequest(new IOException("shutdown"), null, downloadWorker);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAssignGrey(DownloadWorker downloadWorker, Range range) throws IOException {
        long l;
        HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
        synchronized (hTTPDownloader) {
            if (!downloadWorker.getDownloader().isActive()) {
                LOG.debug((Object)"victim is no longer active");
                throw new NoSuchElementException();
            }
            Range range2 = downloadWorker.getDownloadInterval();
            if (range2.getHigh() != range.getHigh()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("victim is now downloading something else " + range2 + " vs. " + range));
                }
                throw new NoSuchElementException();
            }
            if (range2.getLow() > range.getLow() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("victim managed to download " + (range2.getLow() - range.getLow()) + " bytes while stealer was connecting"));
            }
            long l2 = this._downloader.getInitialReadingPoint();
            long l3 = this._downloader.getAmountToRead() + l2;
            if (l3 < range.getHigh()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WORKER: not stealing because stealer gave a subrange.  Expected low: " + range.getLow() + ", high: " + range.getHigh() + ".  Was low: " + l2 + ", high: " + l3));
                }
                throw new IOException();
            }
            l = Math.max(range2.getLow(), l2);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("WORKER: picking stolen grey " + l + "-" + range.getHigh() + " from [" + downloadWorker + "] to [" + this + "]"));
            }
            downloadWorker.getDownloader().stopAt(l);
        }
        this._downloader.startAt(l);
        this._shouldRelease = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Range getDownloadInterval() {
        HTTPDownloader hTTPDownloader;
        HTTPDownloader hTTPDownloader2 = hTTPDownloader = this._downloader;
        synchronized (hTTPDownloader2) {
            long l = Math.max(hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountRead(), hTTPDownloader.getInitialWritingPoint());
            long l2 = hTTPDownloader.getInitialReadingPoint() + hTTPDownloader.getAmountToRead();
            return Range.createRange(l, l2);
        }
    }

    private void setStealing(boolean bl) {
        this._stealing = bl;
    }

    boolean isStealing() {
        return this._stealing;
    }

    private DownloadWorker findSlowestDownloader() {
        float f;
        DownloadWorker downloadWorker = null;
        float f2 = f = this.getOurSpeed();
        Set<DownloadWorker> set = this._manager.getQueuedWorkers().keySet();
        for (DownloadWorker downloadWorker2 : this._manager.getAllWorkers()) {
            HTTPDownloader hTTPDownloader;
            if (downloadWorker2.isStealing() || set.contains(downloadWorker2) || (hTTPDownloader = downloadWorker2.getDownloader()) == null || hTTPDownloader == this._downloader || hTTPDownloader.isVictim()) continue;
            if (f == -1.0f) {
                if (!downloadWorker2.isSlow()) continue;
                return downloadWorker2;
            }
            float f3 = 0.0f;
            try {
                hTTPDownloader.getMeasuredBandwidth();
                f3 = hTTPDownloader.getAverageBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f3 = Math.max(0.0f, f - 0.1f);
            }
            if (!(f3 < f2)) continue;
            f2 = f3;
            downloadWorker = downloadWorker2;
        }
        return downloadWorker;
    }

    private float getOurSpeed() {
        if (this._downloader == null) {
            return -1.0f;
        }
        try {
            this._downloader.getMeasuredBandwidth();
            return this._downloader.getAverageBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return -1.0f;
        }
    }

    boolean isSlow() {
        float f = this.getOurSpeed();
        return f < MIN_ACCEPTABLE_SPEED && f != -1.0f;
    }

    private ConnectionStatus handleNoMoreDownloaders() {
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoData();
    }

    private ConnectionStatus handleNoRanges() {
        this._rfd.setAvailableRanges(null);
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(300);
        }
        this._rfd.resetFailedCount();
        this._manager.addRFD(this._rfd);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleTryAgainLater() {
        if (!this._rfd.isBusy()) {
            this._rfd.setRetryAfter(60);
        }
        if (!this._manager.getActiveWorkers().isEmpty() && this._rfd.getWaitTime(System.currentTimeMillis()) < 600) {
            this._rfd.setRetryAfter(600);
        }
        this._manager.addRFD(this._rfd);
        this._rfd.resetFailedCount();
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleRangeNotAvailable() {
        this._rfd.resetFailedCount();
        this._manager.informMesh(this._rfd, true);
        return ConnectionStatus.getPartialData();
    }

    private ConnectionStatus handleFileNotFound() {
        this._manager.informMesh(this._rfd, false);
        return ConnectionStatus.getNoFile();
    }

    private ConnectionStatus handleNotSharing() {
        return this.handleFileNotFound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionStatus handleQueued(int n, int n2) {
        DownloadWorkerSupport downloadWorkerSupport = this._manager;
        synchronized (downloadWorkerSupport) {
            if (this._manager.getActiveWorkers().isEmpty()) {
                if (this._manager.isCancelled() || this._manager.isPaused() || this._interrupted.get()) {
                    return ConnectionStatus.getNoData();
                }
                this._manager.setState(Downloader.DownloadStatus.REMOTE_QUEUED);
            }
            this._rfd.resetFailedCount();
            return ConnectionStatus.getQueued(n, n2);
        }
    }

    private ConnectionStatus handleProblemReadingHeader() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleUnknownCode() {
        return this.handleFileNotFound();
    }

    private ConnectionStatus handleIO() {
        this.handleRFDFailure();
        return ConnectionStatus.getNoFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupt() {
        boolean bl;
        if (this._interrupted.getAndSet(true)) {
            return;
        }
        Object object = this._currentState;
        synchronized (object) {
            bl = this._currentState.getCurrentState() == 5;
        }
        if (bl) {
            this.finishHttpLoop();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stopping while state is: " + this._currentState + ", this: " + this.toString()));
        }
        if (this._downloader != null) {
            this._downloader.stop();
        } else {
            Socket socket;
            object = this._connectObserver;
            if (object != null && (socket = ((DirectConnector)object).getSocket()) != null) {
                IOUtils.close(socket);
            }
        }
    }

    public RemoteFileDesc getRFD() {
        return this._rfd;
    }

    HTTPDownloader getDownloader() {
        return this._downloader;
    }

    public String toString() {
        return this._workerName + "[" + this._currentState + "] -> " + this._rfd;
    }

    private void finishWorker() {
        this._interrupted.set(true);
        this._manager.workerFinished(this);
    }

    private void startDownload(HTTPDownloader hTTPDownloader) {
        this._downloader = hTTPDownloader;
        if (this.finishConnect()) {
            LOG.trace((Object)"Starting download");
            this.initializeAlternateLocations();
            this.httpLoop();
        } else {
            this.finishWorker();
        }
    }

    private void finishHttpLoop() {
        this.releaseRanges();
        this._manager.removeQueuedWorker(this);
        this._downloader.stop();
        this.finishWorker();
    }

    private class DirectConnector
    extends HTTPConnectObserver {
        private boolean pushConnectOnFailure;
        private Socket connectingSocket;
        private boolean shutdown;

        DirectConnector(boolean bl) {
            this.pushConnectOnFailure = bl;
        }

        public void handleConnect(Socket socket) {
            this.connectingSocket = null;
            HTTPDownloader hTTPDownloader = DownloadWorker.this.httpDownloaderFactory.create(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, false);
            try {
                hTTPDownloader.initializeTCP();
                DownloadWorker.this.statsTracker.successfulDirectConnect();
            }
            catch (IOException iOException) {
                this.shutdown();
                return;
            }
            DownloadWorker.this.startDownload(hTTPDownloader);
        }

        public void shutdown() {
            DownloadWorker.this.statsTracker.failedDirectConnect();
            this.shutdown = true;
            this.connectingSocket = null;
            if (this.pushConnectOnFailure) {
                DownloadWorker.this.statsTracker.increment(DownloadStatsTracker.PushReason.DIRECT_FAILED);
                DownloadWorker.this.connectWithPush(new PushConnector(false, false));
            } else {
                DownloadWorker.this.finishConnect();
                DownloadWorker.this.finishWorker();
            }
        }

        void setSocket(Socket socket) {
            this.connectingSocket = socket;
        }

        Socket getSocket() {
            return this.connectingSocket;
        }

        public boolean isShutdown() {
            return this.shutdown;
        }
    }

    private class PushConnector
    extends HTTPConnectObserver
    implements MultiShutdownable {
        private boolean forgetOnFailure;
        private boolean directConnectOnFailure;
        private PushDetails pushDetails;
        private volatile Shutdownable toCancel;
        private AtomicBoolean shutdown = new AtomicBoolean(false);

        PushConnector(boolean bl, boolean bl2) {
            this.forgetOnFailure = bl;
            this.directConnectOnFailure = bl2;
        }

        public void addShutdownable(Shutdownable shutdownable) {
            this.toCancel = shutdownable;
        }

        public void handleConnect(Socket socket) {
            HTTPDownloader hTTPDownloader = DownloadWorker.this.httpDownloaderFactory.create(socket, DownloadWorker.this._rfd, DownloadWorker.this._commonOutFile, false);
            try {
                hTTPDownloader.initializeTCP();
                DownloadWorker.this.statsTracker.successfulPushConnect();
            }
            catch (IOException iOException) {
                this.failed();
                return;
            }
            DownloadWorker.this.startDownload(hTTPDownloader);
        }

        public boolean isCancelled() {
            return this.shutdown.get();
        }

        public void shutdown() {
            DownloadWorker.this.statsTracker.failedPushConnect();
            if (this.shutdown.getAndSet(true)) {
                return;
            }
            Shutdownable shutdownable = this.toCancel;
            if (shutdownable != null) {
                shutdownable.shutdown();
            }
            this.failed();
        }

        void setPushDetails(PushDetails pushDetails) {
            this.pushDetails = pushDetails;
        }

        private void failed() {
            DownloadWorker.this._manager.unregisterPushObserver(this.pushDetails, false);
            if (!this.directConnectOnFailure) {
                if (this.forgetOnFailure) {
                    DownloadWorker.this._manager.forgetRFD(DownloadWorker.this._rfd);
                }
                DownloadWorker.this.finishConnect();
                DownloadWorker.this.finishWorker();
            } else {
                DownloadWorker.this.connectDirectly(new DirectConnector(false));
            }
        }
    }

    private abstract class State
    implements IOStateObserver {
        private State() {
        }

        public final void handleIOException(IOException iOException) {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        public final void handleStatesFinished() {
            this.handleState(true);
            DownloadWorker.this.incrementState(null);
        }

        public final void shutdown() {
            this.handleState(false);
            DownloadWorker.this.finishHttpLoop();
        }

        protected abstract void handleState(boolean var1);
    }
}

