/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Singleton;
import com.limegroup.gnutella.downloader.DownloadStatsTracker;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class DownloadStatsTrackerImpl
implements DownloadStatsTracker {
    private HashMap<DownloadStatsTracker.PushReason, AtomicInteger> pushReasonStats = new HashMap();
    private AtomicInteger directConnectSuccess = new AtomicInteger(0);
    private AtomicInteger directConnectFail = new AtomicInteger(0);
    private AtomicInteger pushConnectSuccess = new AtomicInteger(0);
    private AtomicInteger pushConnectFail = new AtomicInteger(0);

    public DownloadStatsTrackerImpl() {
        for (DownloadStatsTracker.PushReason pushReason : DownloadStatsTracker.PushReason.values()) {
            this.pushReasonStats.put(pushReason, new AtomicInteger(0));
        }
    }

    public Object inspect() {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("direct connect success", this.directConnectSuccess);
        hashMap.put("direct connect fail", this.directConnectFail);
        hashMap.put("push connect success", this.pushConnectSuccess);
        hashMap.put("push connect fail", this.pushConnectFail);
        hashMap.put("push reasons", this.pushReasonStats);
        return hashMap;
    }

    public void successfulDirectConnect() {
        this.directConnectSuccess.incrementAndGet();
    }

    public void failedDirectConnect() {
        this.directConnectFail.incrementAndGet();
    }

    public void successfulPushConnect() {
        this.pushConnectSuccess.incrementAndGet();
    }

    public void failedPushConnect() {
        this.pushConnectFail.incrementAndGet();
    }

    public void increment(DownloadStatsTracker.PushReason pushReason) {
        if (pushReason != null) {
            this.pushReasonStats.get((Object)pushReason).incrementAndGet();
        }
    }
}

