/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.CoreDownloaderFactory;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.ResumeDownloader;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import java.io.File;
import java.util.Arrays;
import org.limewire.io.InvalidDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CoreDownloaderFactoryImpl
implements CoreDownloaderFactory {
    private final Provider<ManagedDownloader> managedDownloaderFactory;
    private final Provider<ResumeDownloader> resumeDownloaderFactory;

    @Inject
    public CoreDownloaderFactoryImpl(Provider<ManagedDownloader> provider, Provider<ResumeDownloader> provider2) {
        this.managedDownloaderFactory = provider;
        this.resumeDownloaderFactory = provider2;
    }

    @Override
    public ManagedDownloader createManagedDownloader(RemoteFileDesc[] remoteFileDescArray, GUID gUID, File file, String string, boolean bl) throws SaveLocationException {
        ManagedDownloader managedDownloader = (ManagedDownloader)this.managedDownloaderFactory.get();
        managedDownloader.addInitialSources(Arrays.asList(remoteFileDescArray), string);
        managedDownloader.setQueryGuid(gUID);
        managedDownloader.setSaveFile(file, string, bl);
        return managedDownloader;
    }

    @Override
    public ResumeDownloader createResumeDownloader(File file, String string, long l) throws SaveLocationException {
        ResumeDownloader resumeDownloader = (ResumeDownloader)this.resumeDownloaderFactory.get();
        resumeDownloader.addInitialSources(null, string);
        resumeDownloader.setSaveFile(null, string, false);
        resumeDownloader.initIncompleteFile(file, l);
        return resumeDownloader;
    }

    @Override
    public CoreDownloader createFromMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        try {
            Provider<? extends CoreDownloader> provider = this.providerForMemento(downloadMemento);
            CoreDownloader coreDownloader = (CoreDownloader)provider.get();
            coreDownloader.initFromMemento(downloadMemento);
            return coreDownloader;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidDataException("invalid memento!", classCastException);
        }
    }

    private Provider<? extends CoreDownloader> providerForMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        switch (downloadMemento.getDownloadType()) {
            case MANAGED: {
                return this.managedDownloaderFactory;
            }
        }
        throw new InvalidDataException("invalid memento type: " + (Object)((Object)downloadMemento.getDownloadType()));
    }
}

