/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.RandomDownloadStrategy;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.util.SystemUtils;

public class BiasedRandomDownloadStrategy
extends RandomDownloadStrategy {
    private static final Log LOG = LogFactory.getLog(BiasedRandomDownloadStrategy.class);
    private static final int MIN_PREVIEW_BYTES = 0x100000;
    private static final float MIN_PREVIEW_FRACTION = 0.1f;
    private static final float MAX_PREVIEW_FRACTION = 0.5f;
    static final int MIN_IDLE_MILLISECONDS = 300000;

    public BiasedRandomDownloadStrategy(long l) {
        super(l);
    }

    public synchronized Range pickAssignment(IntervalSet intervalSet, IntervalSet intervalSet2, long l) throws NoSuchElementException {
        Range range;
        long l2 = intervalSet2.getFirst().getLow();
        long l3 = intervalSet2.getLast().getHigh();
        if (l < 1L) {
            throw new IllegalArgumentException("Block size cannot be " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("First needed byte must be >= 0, " + l2 + "<0");
        }
        if (l3 >= this.completedSize) {
            throw new IllegalArgumentException("neededBytes contains bytes beyond the end of the file." + l3 + " >= " + this.completedSize);
        }
        if (intervalSet.isEmpty()) {
            throw new NoSuchElementException();
        }
        if (this.getIdleTime() >= 300000L || pseudoRandom.nextFloat() >= this.getBiasProbability(l2, this.completedSize)) {
            return super.pickAssignment(intervalSet, intervalSet2, l);
        }
        Range range2 = intervalSet.getFirst();
        long l4 = this.alignHigh(range2.getLow(), l);
        if (l4 > range2.getHigh()) {
            l4 = range2.getHigh();
        }
        if ((range = range2).getHigh() != l4) {
            range = Range.createRange(range2.getLow(), l4);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Non-random download, probability=" + this.getBiasProbability(l2, this.completedSize) + ", range=" + range + " out of choices " + intervalSet));
        }
        return range;
    }

    private float getBiasProbability(long l, long l2) {
        long l3 = Math.max(0x100000L, (long)(0.1f * (float)l2));
        if (l < l3) {
            return 1.0f;
        }
        if ((float)l < 0.5f * (float)l2) {
            return 0.5f;
        }
        return 0.0f;
    }

    protected long getIdleTime() {
        return SystemUtils.getIdleTime();
    }
}

