/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SaveLocationManager;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.serial.DownloadMemento;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.limewire.io.InvalidDataException;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.Objects;

public abstract class AbstractCoreDownloader
implements CoreDownloader {
    private volatile int inactivePriority;
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    private File saveFile;
    private String defaultFileName;
    private final SaveLocationManager saveLocationManager;

    protected AbstractCoreDownloader(SaveLocationManager saveLocationManager) {
        this.saveLocationManager = Objects.nonNull(saveLocationManager, "saveLocationManager");
    }

    public void setInactivePriority(int n) {
        this.inactivePriority = n;
    }

    public int getInactivePriority() {
        return this.inactivePriority;
    }

    public Object setAttribute(String string, Object object, boolean bl) {
        return this.attributes.put(string, new Attribute(bl, object));
    }

    public Object getAttribute(String string) {
        Attribute attribute = this.attributes.get(string);
        if (attribute != null) {
            return attribute.getObject();
        }
        return null;
    }

    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public boolean conflictsSaveFile(File file) {
        return this.getSaveFile().equals(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSaveFile(File file, String string, boolean bl) throws SaveLocationException {
        block18: {
            if (string == null) {
                string = this.getDefaultFileName();
            }
            if (file == null) {
                file = SharingSettings.getSaveDirectory(string);
            }
            try {
                string = CommonUtils.convertFileName(file, string);
            }
            catch (IOException iOException) {
                if (!file.isDirectory()) break block18;
                throw new SaveLocationException(11, file);
            }
        }
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new SaveLocationException(8, file);
            }
            throw new SaveLocationException(4, file);
        }
        File file2 = new File(file, string);
        try {
            if (!FileUtils.isReallyParent(file, file2)) {
                throw new SaveLocationException(1, file2);
            }
        }
        catch (IOException iOException) {
            throw new SaveLocationException(9, file2);
        }
        if (!FileUtils.setWriteable(file)) {
            throw new SaveLocationException(3, file);
        }
        if (file2.exists()) {
            if (!file2.isFile()) {
                throw new SaveLocationException(7, file2);
            }
            if (!bl) {
                throw new SaveLocationException(5, file2);
            }
        }
        if (this.saveLocationManager.isSaveLocationTaken(file2)) {
            throw new SaveLocationException(6, file2);
        }
        AbstractCoreDownloader abstractCoreDownloader = this;
        synchronized (abstractCoreDownloader) {
            if (!this.isRelocatable()) {
                throw new SaveLocationException(2, file2);
            }
            this.saveFile = file2;
        }
    }

    public synchronized File getSaveFile() {
        if (this.saveFile == null) {
            return this.getDefaultSaveFile();
        }
        return this.saveFile;
    }

    protected abstract File getDefaultSaveFile();

    protected synchronized String getDefaultFileName() {
        assert (this.defaultFileName != null) : "no default filename initialized!";
        return CommonUtils.convertFileName(this.defaultFileName);
    }

    protected synchronized boolean hasDefaultFileName() {
        return this.defaultFileName != null;
    }

    protected synchronized void setDefaultFileName(String string) {
        this.defaultFileName = string;
    }

    public synchronized void initFromMemento(DownloadMemento downloadMemento) throws InvalidDataException {
        this.saveFile = downloadMemento.getSaveFile();
        this.setDefaultFileName(downloadMemento.getDefaultFileName());
        if (downloadMemento.getAttributes() != null) {
            for (Map.Entry<String, Object> entry : downloadMemento.getAttributes().entrySet()) {
                this.attributes.put(entry.getKey(), new Attribute(true, entry.getValue()));
            }
        }
    }

    public final synchronized DownloadMemento toMemento() {
        DownloadMemento downloadMemento = this.createMemento();
        this.fillInMemento(downloadMemento);
        return downloadMemento;
    }

    protected abstract DownloadMemento createMemento();

    protected void fillInMemento(DownloadMemento downloadMemento) {
        downloadMemento.setDownloadType(this.getDownloadType());
        downloadMemento.setSaveFile(this.saveFile);
        downloadMemento.setDefaultFileName(this.defaultFileName);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.attributes.size());
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            if (!entry.getValue().isSerialize()) continue;
            hashMap.put(entry.getKey(), entry.getValue().getObject());
        }
        downloadMemento.setAttributes(hashMap);
    }

    private static class Attribute {
        private final boolean serialize;
        private final Object object;

        public Attribute(boolean bl, Object object) {
            this.serialize = bl;
            this.object = object;
        }

        public boolean isSerialize() {
            return this.serialize;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

