/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.messages;

import com.limegroup.gnutella.dht.messages.FindNodeRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindNodeResponseWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueResponseWireImpl;
import com.limegroup.gnutella.dht.messages.PingRequestWireImpl;
import com.limegroup.gnutella.dht.messages.PingResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StatsRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StatsResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StoreRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StoreResponseWireImpl;
import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageFactory;
import org.limewire.mojito.messages.MessageFormatException;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFactoryWire
implements MessageFactory {
    private final MessageFactory delegate;

    public MessageFactoryWire(MessageFactory messageFactory) {
        if (messageFactory == null) {
            throw new NullPointerException("Delegate is null");
        }
        if (messageFactory instanceof MessageFactoryWire) {
            throw new IllegalArgumentException("Recursive delegation");
        }
        this.delegate = messageFactory;
    }

    @Override
    public MessageID createMessageID(SocketAddress socketAddress) {
        return this.delegate.createMessageID(socketAddress);
    }

    @Override
    public DHTMessage createMessage(SocketAddress socketAddress, ByteBuffer ... byteBufferArray) throws MessageFormatException, IOException {
        DHTMessage dHTMessage = this.delegate.createMessage(socketAddress, byteBufferArray);
        if (dHTMessage instanceof PingRequest) {
            return new PingRequestWireImpl((PingRequest)dHTMessage);
        }
        if (dHTMessage instanceof PingResponse) {
            return new PingResponseWireImpl((PingResponse)dHTMessage);
        }
        if (dHTMessage instanceof FindNodeRequest) {
            return new FindNodeRequestWireImpl((FindNodeRequest)dHTMessage);
        }
        if (dHTMessage instanceof FindNodeResponse) {
            return new FindNodeResponseWireImpl((FindNodeResponse)dHTMessage);
        }
        if (dHTMessage instanceof FindValueRequest) {
            return new FindValueRequestWireImpl((FindValueRequest)dHTMessage);
        }
        if (dHTMessage instanceof FindValueResponse) {
            return new FindValueResponseWireImpl((FindValueResponse)dHTMessage);
        }
        if (dHTMessage instanceof StoreRequest) {
            return new StoreRequestWireImpl((StoreRequest)dHTMessage);
        }
        if (dHTMessage instanceof StoreResponse) {
            return new StoreResponseWireImpl((StoreResponse)dHTMessage);
        }
        if (dHTMessage instanceof StatsRequest) {
            return new StatsRequestWireImpl((StatsRequest)dHTMessage);
        }
        if (dHTMessage instanceof StatsResponse) {
            return new StatsResponseWireImpl((StatsResponse)dHTMessage);
        }
        throw new IOException(dHTMessage.getClass() + " is unhandled");
    }

    @Override
    public ByteBuffer writeMessage(SocketAddress socketAddress, DHTMessage dHTMessage) throws IOException {
        return this.delegate.writeMessage(socketAddress, dHTMessage);
    }

    @Override
    public FindNodeRequest createFindNodeRequest(Contact contact, SocketAddress socketAddress, KUID kUID) {
        return new FindNodeRequestWireImpl(this.delegate.createFindNodeRequest(contact, socketAddress, kUID));
    }

    @Override
    public FindNodeResponse createFindNodeResponse(Contact contact, Contact contact2, MessageID messageID, Collection<? extends Contact> collection) {
        return new FindNodeResponseWireImpl(this.delegate.createFindNodeResponse(contact, contact2, messageID, collection));
    }

    @Override
    public FindValueRequest createFindValueRequest(Contact contact, SocketAddress socketAddress, KUID kUID, Collection<KUID> collection, DHTValueType dHTValueType) {
        return new FindValueRequestWireImpl(this.delegate.createFindValueRequest(contact, socketAddress, kUID, collection, dHTValueType));
    }

    @Override
    public FindValueResponse createFindValueResponse(Contact contact, Contact contact2, MessageID messageID, float f, Collection<? extends DHTValueEntity> collection, Collection<KUID> collection2) {
        return new FindValueResponseWireImpl(this.delegate.createFindValueResponse(contact, contact2, messageID, f, collection, collection2));
    }

    @Override
    public PingRequest createPingRequest(Contact contact, SocketAddress socketAddress) {
        return new PingRequestWireImpl(this.delegate.createPingRequest(contact, socketAddress));
    }

    @Override
    public PingResponse createPingResponse(Contact contact, Contact contact2, MessageID messageID, SocketAddress socketAddress, BigInteger bigInteger) {
        return new PingResponseWireImpl(this.delegate.createPingResponse(contact, contact2, messageID, socketAddress, bigInteger));
    }

    @Override
    public StatsRequest createStatsRequest(Contact contact, SocketAddress socketAddress, StatsRequest.StatisticType statisticType) {
        return new StatsRequestWireImpl(this.delegate.createStatsRequest(contact, socketAddress, statisticType));
    }

    @Override
    public StatsResponse createStatsResponse(Contact contact, Contact contact2, MessageID messageID, byte[] byArray) {
        return new StatsResponseWireImpl(this.delegate.createStatsResponse(contact, contact2, messageID, byArray));
    }

    @Override
    public StoreRequest createStoreRequest(Contact contact, SocketAddress socketAddress, SecurityToken securityToken, Collection<? extends DHTValueEntity> collection) {
        return new StoreRequestWireImpl(this.delegate.createStoreRequest(contact, socketAddress, securityToken, collection));
    }

    @Override
    public StoreResponse createStoreResponse(Contact contact, Contact contact2, MessageID messageID, Collection<StoreResponse.StoreStatusCode> collection) {
        return new StoreResponseWireImpl(this.delegate.createStoreResponse(contact, contact2, messageID, collection));
    }
}

