/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.io;

import com.google.inject.Provider;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.dht.io.MessageParserDelegate;
import com.limegroup.gnutella.dht.messages.FindNodeRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindNodeResponseWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueRequestWireImpl;
import com.limegroup.gnutella.dht.messages.FindValueResponseWireImpl;
import com.limegroup.gnutella.dht.messages.MessageFactoryWire;
import com.limegroup.gnutella.dht.messages.PingRequestWireImpl;
import com.limegroup.gnutella.dht.messages.PingResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StatsRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StatsResponseWireImpl;
import com.limegroup.gnutella.dht.messages.StoreRequestWireImpl;
import com.limegroup.gnutella.dht.messages.StoreResponseWireImpl;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.PublicKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.io.Tag;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.routing.impl.RemoteContact;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeMessageDispatcherImpl
extends org.limewire.mojito.io.MessageDispatcher
implements MessageHandler {
    private static final Log LOG = LogFactory.getLog(LimeMessageDispatcherImpl.class);
    private static final Class[] UDP_MESSAGE_TYPES = new Class[]{PingRequestWireImpl.class, PingResponseWireImpl.class, StoreRequestWireImpl.class, StoreResponseWireImpl.class, FindNodeRequestWireImpl.class, FindNodeResponseWireImpl.class, FindValueRequestWireImpl.class, FindValueResponseWireImpl.class, StatsRequestWireImpl.class, StatsResponseWireImpl.class};
    private volatile boolean running = false;
    private volatile boolean bound = false;
    private final Provider<UDPService> udpService;
    private final Provider<SecureMessageVerifier> secureMessageVerifier;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<MessageDispatcher> messageDispatcher;

    public LimeMessageDispatcherImpl(Context context, Provider<UDPService> provider, Provider<SecureMessageVerifier> provider2, Provider<MessageRouter> provider3, Provider<MessageDispatcher> provider4, MessageFactory messageFactory) {
        super(context);
        this.udpService = provider;
        this.secureMessageVerifier = provider2;
        this.messageRouter = provider3;
        this.messageDispatcher = provider4;
        context.setMessageFactory(new MessageFactoryWire(context.getMessageFactory()));
        MessageParserDelegate messageParserDelegate = new MessageParserDelegate(context.getMessageFactory());
        messageFactory.setParser((byte)68, messageParserDelegate);
    }

    @Override
    protected boolean allow(DHTMessage dHTMessage) {
        return true;
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        assert (!this.bound);
        this.bound = true;
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public synchronized void start() {
        for (Class clazz : UDP_MESSAGE_TYPES) {
            ((MessageRouter)this.messageRouter.get()).setUDPMessageHandler(clazz, this);
        }
        this.running = true;
        super.start();
    }

    @Override
    public synchronized void stop() {
        this.running = false;
        super.stop();
        for (Class clazz : UDP_MESSAGE_TYPES) {
            ((MessageRouter)this.messageRouter.get()).setUDPMessageHandler(clazz, null);
        }
    }

    @Override
    public void close() {
        this.bound = false;
        super.close();
    }

    @Override
    protected boolean submit(Tag tag) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)tag.getSocketAddress();
        ByteBuffer byteBuffer = tag.getData();
        ((UDPService)this.udpService.get()).send(byteBuffer, inetSocketAddress, true);
        this.register(tag);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Sent: " + tag));
        }
        return true;
    }

    @Override
    public void handleMessage(Message message, InetSocketAddress inetSocketAddress, ReplyHandler replyHandler) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Received message from " + inetSocketAddress + ", " + message));
        }
        if (!this.isRunning()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Dropping message from " + inetSocketAddress + " because DHT is not running"));
            }
            return;
        }
        DHTMessage dHTMessage = (DHTMessage)((Object)message);
        ((RemoteContact)dHTMessage.getContact()).fixSourceAndContactAddress(inetSocketAddress);
        this.handleMessage(dHTMessage);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    protected void process(Runnable runnable) {
        if (this.isRunning()) {
            ((MessageDispatcher)this.messageDispatcher.get()).dispatch(runnable);
        }
    }

    @Override
    protected void verify(SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
        PublicKey publicKey = this.context.getPublicKey();
        if (publicKey == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Dropping SecureMessage " + secureMessage + " because PublicKey is not set"));
            }
            return;
        }
        ((SecureMessageVerifier)this.secureMessageVerifier.get()).verify(publicKey, "SHA1withDSA", secureMessage, secureMessageCallback);
    }
}

