/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GGEP;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.exceptions.DHTValueException;
import org.limewire.mojito.routing.Version;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushProxiesValueImpl
extends AbstractPushProxiesValue {
    private static final long serialVersionUID = -2912251955825278890L;
    private final byte[] guid;
    private final byte features;
    private final int fwtVersion;
    private final int port;
    private final Set<? extends IpPort> proxies;
    private final byte[] data;
    private final BitNumbers tlsInfo;

    public PushProxiesValueImpl(Version version, byte[] byArray, byte by, int n, int n2, Set<? extends IpPort> set) {
        super(version);
        this.guid = byArray;
        this.features = by;
        this.fwtVersion = n;
        this.port = n2;
        this.proxies = new IpPortSet((Collection<? extends IpPort>)set);
        this.tlsInfo = AbstractPushProxiesValue.getNumbersFromProxies(set);
        this.data = AbstractPushProxiesValue.serialize(this);
    }

    public PushProxiesValueImpl(Version version, byte[] byArray) throws DHTValueException {
        super(version);
        if (version == null) {
            throw new DHTValueException("Version is null");
        }
        if (byArray == null) {
            throw new DHTValueException("Data is null");
        }
        this.data = byArray;
        try {
            GGEP gGEP = new GGEP(byArray, 0);
            this.guid = gGEP.getBytes("client-id");
            if (this.guid.length != 16) {
                throw new DHTValueException("Illegal GUID length: " + this.guid.length);
            }
            this.features = (byte)gGEP.getInt("features");
            this.fwtVersion = gGEP.getInt("fwt-version");
            byte[] byArray2 = gGEP.getBytes("port");
            this.port = ByteUtils.beb2short(byArray2, 0) & 0xFFFF;
            if (!NetworkUtils.isValidPort(this.port)) {
                throw new DHTValueException("Illegal port: " + this.port);
            }
            BitNumbers bitNumbers = BitNumbers.EMPTY_BN;
            try {
                bitNumbers = new BitNumbers(gGEP.getBytes("tls"));
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
            byte[] byArray3 = gGEP.getBytes("proxies");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            IpPortSet ipPortSet = new IpPortSet();
            int n = 0;
            while (dataInputStream.available() > 0) {
                int n2 = dataInputStream.readUnsignedByte();
                if (n2 != 6 && n2 != 18) {
                    throw new IOException("Illegal IP:Port length: " + n2);
                }
                byte[] byArray4 = new byte[n2 - 2];
                dataInputStream.readFully(byArray4);
                int n3 = dataInputStream.readUnsignedShort();
                if (!NetworkUtils.isValidPort(n3)) {
                    throw new DHTValueException("Illegal port: " + n3);
                }
                IpPort ipPort = new IpPortImpl(InetAddress.getByAddress(byArray4), n3);
                if (bitNumbers.isSet(n++)) {
                    ipPort = new ConnectableImpl(ipPort, true);
                }
                ipPortSet.add(ipPort);
            }
            this.proxies = ipPortSet;
            this.tlsInfo = bitNumbers;
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            throw new DHTValueException(badGGEPPropertyException);
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
            throw new DHTValueException(badGGEPBlockException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new DHTValueException(unknownHostException);
        }
        catch (IOException iOException) {
            throw new DHTValueException(iOException);
        }
    }

    @Override
    public byte[] getValue() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        return byArray;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    @Override
    public byte[] getGUID() {
        return this.guid;
    }

    @Override
    public byte getFeatures() {
        return this.features;
    }

    @Override
    public int getFwtVersion() {
        return this.fwtVersion;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Set<? extends IpPort> getPushProxies() {
        return this.proxies;
    }

    @Override
    public BitNumbers getTLSInfo() {
        return this.tlsInfo;
    }
}

